/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.utils;

import java.net.IDN;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DomainValidator {
    private static final int MAX_LABEL_LENGTH = 63;
    private static final int MAX_DOMAIN_LENGTH = 255;
    private static Pattern PATTERN = Pattern.compile("\\p{Alnum}([\\p{Alnum}\\-]*\\p{Alnum})?");
    private static Pattern FIRST = Pattern.compile("\\p{Alnum}");
    private static Pattern LAST = Pattern.compile("\\p{Alnum}");
    private static Pattern MIDDLE = Pattern.compile("[^\\p{Alnum}\\-]*");

    public static String validateLabel(String label) {
        boolean internationalized;
        String errorMsg = null;
        String asciiLabel = IDN.toASCII(label);
        boolean bl = internationalized = !asciiLabel.equals(label);
        if (asciiLabel.isEmpty()) {
            errorMsg = "cannot be empty";
        } else if (asciiLabel.length() > 63) {
            errorMsg = label + " is too long";
        } else {
            Matcher matcher = PATTERN.matcher(asciiLabel);
            if (!matcher.matches()) {
                String slug;
                String first = asciiLabel.substring(0, 1);
                String last = asciiLabel.substring(asciiLabel.length() - 1);
                String string = slug = internationalized ? "n international" : "n";
                if (!FIRST.matcher(first).matches()) {
                    errorMsg = String.format("first character of \"%s\" must be a%s alphanumeric character, but was: \"%s\"", label, slug, first);
                } else if (!LAST.matcher(last).matches()) {
                    errorMsg = String.format("last character of \"%s\" must be a%s alphanumeric character, but was: \"%s\"", label, slug, last);
                } else {
                    matcher = MIDDLE.matcher(asciiLabel);
                    String group = null;
                    while (matcher.find() && group == null) {
                        if (matcher.group().isEmpty()) continue;
                        group = matcher.group();
                    }
                    errorMsg = group != null ? String.format("all characters of \"%s\" must be a%s alphanumeric character or a hyphen, but found: \"%s\"", label, slug, group) : String.format("all characters of \"%s\" must be a%s alphanumeric character or a hyphen, but were: \"%s\"", label, slug, label);
                }
            }
        }
        return errorMsg;
    }

    public static String validate(String domain) {
        String errorMsg = null;
        String[] labels = domain.split("\\.");
        int totalLength = labels.length + 1;
        for (String label : labels) {
            String asciiLabel = IDN.toASCII(label);
            if ((totalLength += asciiLabel.length()) > 255) {
                errorMsg = "Invalid domain name, \"" + domain + "\" is too long";
                break;
            }
            errorMsg = DomainValidator.validateLabel(label);
            if (errorMsg == null) continue;
            errorMsg = "Invalid domain name, " + errorMsg;
            break;
        }
        return errorMsg;
    }
}

