/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.utils;

import com.archivas.clienttools.arcutils.utils.Base64Utils;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;

public class EncryptionUtils {
    private static final String UNICODE_FORMAT = "UTF8";
    public static final String ENCRYPTION_SCHEME = "DESede";
    public static final String PACKAGE_NAME = EncryptionUtils.class.getPackage().getName();
    public static final String CLASS_FULL_NAME = EncryptionUtils.class.getName();
    public static final String CLASS_NAME = CLASS_FULL_NAME.substring(PACKAGE_NAME.length() + 1);
    public static Logger LOG = Logger.getLogger(CLASS_FULL_NAME);
    private SecretKeyFactory keyFactory;
    private Cipher cipher;
    private String encryptionKey = "RWfjC98rwv3yKkxF89tpZv00ud1w7pgp";

    public EncryptionUtils() {
        try {
            this.keyFactory = SecretKeyFactory.getInstance(ENCRYPTION_SCHEME);
            this.cipher = Cipher.getInstance(ENCRYPTION_SCHEME);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warning("Tried to set up the encrytion service and failed: " + e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            LOG.warning("Tried to set up the encrytion service and failed: " + e.getMessage());
        }
    }

    public EncryptionUtils(String encryptionKey) {
        this();
        this.encryptionKey = encryptionKey;
    }

    public String EncryptValue(String value) {
        String result = value;
        try {
            this.setUpCiper(1);
            byte[] cleartext = value.getBytes(UNICODE_FORMAT);
            byte[] ciphertext = this.cipher.doFinal(cleartext);
            result = Base64Utils.encode(ciphertext);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warning("Encoding for encryption is not supported: " + e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            LOG.warning("Error encrypting the string: " + e.getMessage());
        }
        catch (BadPaddingException e) {
            LOG.warning("Error encrypting the string: " + e.getMessage());
        }
        return result;
    }

    public String DecryptValue(String encryptedValue) {
        String result = encryptedValue;
        try {
            this.setUpCiper(2);
            byte[] cleartext = Base64Utils.decodeBuffer(encryptedValue);
            byte[] ciphertext = this.cipher.doFinal(cleartext);
            result = EncryptionUtils.bytes2String(ciphertext);
        }
        catch (IllegalBlockSizeException e) {
            LOG.warning("Error decrypting the string: " + e.getMessage());
        }
        catch (BadPaddingException e) {
            LOG.warning("Error encrypting the string: " + e.getMessage());
        }
        return result;
    }

    private void setUpCiper(int cipherMode) {
        try {
            byte[] keyAsBytes = this.encryptionKey.getBytes(UNICODE_FORMAT);
            DESedeKeySpec keySpec = new DESedeKeySpec(keyAsBytes);
            SecretKey key = this.keyFactory.generateSecret(keySpec);
            this.cipher.init(cipherMode, key);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warning("Encoding for encryption/decrption is not supported: " + e.getMessage());
        }
        catch (InvalidKeySpecException e) {
            LOG.warning("Failed creating the key for encryption/decrption: " + e.getMessage());
        }
        catch (InvalidKeyException e) {
            LOG.warning("Failed creating the key for encryption/decrption: " + e.getMessage());
        }
    }

    private static String bytes2String(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            stringBuffer.append((char)bytes[i]);
        }
        return stringBuffer.toString();
    }
}

