/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.utils;

import com.archivas.clienttools.arcutils.api.jobs.CopyJob;
import com.archivas.clienttools.arcutils.api.jobs.DeleteJob;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.api.jobs.SetMetadataJob;
import com.archivas.clienttools.arcutils.model.ArcCopyFile;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.model.ArcProcessFile;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.ProfileManager;
import com.archivas.clienttools.arcutils.utils.FileListParserException;
import com.archivas.clienttools.arcutils.utils.FileUtil;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobSchema;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FileListParser {
    private static List<ArcProcessFile> testList;
    private static int DM_MAX_CHAR_LIMIT_FOR_FILE;
    private static final String relativeTestFileName = "/temp/path-test/testing1-rel";
    private static final String absoluteTestFileName = "/temp/path-test/testing1-abs";
    private static final String windowsTestFileName = "/temp/path-test/testing1-windows";
    private static String newline;
    private static boolean useForwardSlash;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateFile(File file, AbstractProfileBase sourceProfile, String sourcePath, String targetPath) throws IOException, FileListParserException {
        if (!file.exists()) {
            throw new IOException("Input file does not exist");
        }
        if (!file.canRead()) {
            throw new IOException("Cannot open input file for reading");
        }
        try (BufferedReader inFile = null;){
            inFile = new BufferedReader(new FileReader(file));
            String fileName = inFile.readLine();
            if (fileName == null) {
                throw new IOException("Input file is empty");
            }
            boolean isWindows = sourceProfile.getName().equals("Local File System") && sourceProfile.getPathSeparator().equals("\\");
            char lowerCaseWinDriveLetter = ':';
            if (isWindows) {
                if (sourcePath == null || sourcePath.length() < 2 || sourcePath.charAt(1) != ':') {
                    throw new FileListParserException("Source path on windows at least required to have a drive letter in the form C:");
                }
                String srcPath = FileUtil.converWindowsPathToUnix(sourcePath, sourceProfile.getPathSeparator());
                lowerCaseWinDriveLetter = Character.toLowerCase(srcPath.charAt(0));
            }
            int maxFileNameLength = DM_MAX_CHAR_LIMIT_FOR_FILE - targetPath.getBytes().length;
            while (fileName != null) {
                char driveLetter;
                char lowercaseDriveLetter;
                if (fileName.length() > maxFileNameLength) {
                    throw new FileListParserException("Cannot create a file with greater than " + DM_MAX_CHAR_LIMIT_FOR_FILE + " bytes in its name.");
                }
                if (isWindows && fileName.length() > 2 && fileName.charAt(1) == ':' && lowerCaseWinDriveLetter != (lowercaseDriveLetter = Character.toLowerCase(driveLetter = fileName.charAt(0)))) {
                    throw new FileListParserException("All files in the file list must be from " + lowerCaseWinDriveLetter + ":   Found: " + fileName);
                }
                fileName = inFile.readLine();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseFile(File file, ManagedJob job, ManagedJobSchema jobSchema) throws IOException, DatabaseException {
        ArrayList<ArcProcessFile> fileList = new ArrayList<ArcProcessFile>();
        AbstractProfileBase sourceProfile = job.getSourceProfile();
        AbstractProfileBase targetProfile = job.getTargetProfile();
        String rootTargetPath = job.getTargetPath();
        String rootSourcePath = job.getSourcePath();
        if (rootTargetPath == null) {
            rootTargetPath = "";
        }
        if (rootSourcePath == null) {
            rootSourcePath = "";
        }
        if (job instanceof CopyJob && (sourceProfile == null || targetProfile == null)) {
            throw new IllegalArgumentException("Null profile for copy job");
        }
        if (job instanceof DeleteJob && sourceProfile == null) {
            throw new IllegalArgumentException("Null sourceProfile for DeleteJob");
        }
        if (job instanceof SetMetadataJob && sourceProfile == null) {
            throw new IllegalArgumentException("Null sourceProfile for metadata job");
        }
        try (BufferedReader inFile = null;){
            inFile = new BufferedReader(new FileReader(file));
            String fileName = inFile.readLine();
            while (fileName != null) {
                if (!fileName.isEmpty()) {
                    String sourceFileName = fileName = FileUtil.converWindowsPathToUnix(fileName, sourceProfile.getPathSeparator());
                    if (sourceFileName.indexOf(":") == 1 && rootSourcePath.indexOf(":") == 1) {
                        sourceFileName = sourceFileName.substring(2);
                    }
                    String targetFileName = fileName;
                    if (fileName.indexOf(":") == 1) {
                        targetFileName = targetFileName.substring(2);
                    }
                    sourceFileName = sourceProfile.encode(sourceFileName);
                    String completeSourcePath = FileUtil.resolvePath(rootSourcePath, sourceFileName, sourceProfile.getPathSeparator());
                    String completeTargetPath = null;
                    if (targetProfile != null) {
                        targetFileName = targetProfile.encode(targetFileName);
                        completeTargetPath = FileUtil.resolvePath(rootTargetPath, targetFileName, targetProfile.getPathSeparator());
                    }
                    ArcMoverFile source = ArcMoverFile.getFileInstance(sourceProfile, completeSourcePath, null);
                    fileList.add(new ArcCopyFile(source, targetProfile, completeTargetPath, null));
                    if (fileList.size() == 1000 && jobSchema != null) {
                        jobSchema.insertFilesToDiscover(fileList, true);
                        fileList.clear();
                    }
                }
                fileName = inFile.readLine();
            }
        }
        if (fileList.size() > 0 && jobSchema != null) {
            jobSchema.insertFilesToDiscover(fileList, true);
            fileList.clear();
        }
        if (jobSchema == null) {
            testList = fileList;
        }
    }

    private static List<ArcProcessFile> testParseFile(File file, ManagedJob job) throws IOException, DatabaseException {
        FileListParser.parseFile(file, job, null);
        return testList;
    }

    public static void main(String[] args) {
        String relSourcePath;
        String absSourcePath;
        ProfileManager.initialize(null);
        if (File.separator.equals("\\")) {
            useForwardSlash = true;
            newline = "\r\n";
            absSourcePath = "C:\\";
            relSourcePath = "C:\\temp";
        } else {
            useForwardSlash = false;
            newline = "\n";
            absSourcePath = "/";
            relSourcePath = "/temp";
        }
        FileListParser.loadFileForTestingWindowsPaths();
        System.out.println("**************** TESTING ABSOLUTE *******************");
        FileListParser.testFile(absoluteTestFileName, absSourcePath);
        System.out.println("**************** TESTING RELATIVE *******************");
        FileListParser.testFile(relativeTestFileName, relSourcePath);
        System.out.println("**************** TESTING WINDOWS *******************");
        FileListParser.testWindows();
    }

    private static void loadFileForTestingWindowsPaths() {
        int maxFiles = 10;
        try {
            File listFile = new File(absoluteTestFileName);
            listFile.createNewFile();
            FileWriter writerAbs = new FileWriter(listFile);
            listFile = new File(relativeTestFileName);
            listFile.createNewFile();
            FileWriter writerRel = new FileWriter(listFile);
            for (int i = 0; i < maxFiles; ++i) {
                File f = new File("/temp/path-test/test" + i);
                if (useForwardSlash) {
                    writerAbs.write("C:\\temp\\path-test\\test" + i + newline);
                    writerRel.write("path-test\\test" + i + newline);
                } else {
                    writerAbs.write("/temp/path-test/test" + i + newline);
                    writerRel.write("path-test/test" + i + newline);
                }
                f.createNewFile();
            }
            writerAbs.close();
            writerRel.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void testFile(String testFileName, String sourcePath) {
        AbstractProfileBase srcProfile = ProfileManager.getProfileByName("Local File System");
        AbstractProfileBase dstProfile = ProfileManager.getProfileByName("d");
        CopyJob job = new CopyJob(srcProfile, dstProfile, new File(testFileName));
        job.setTargetPath("/test");
        if (sourcePath != null) {
            job.setSourcePath(sourcePath);
        }
        File f = new File(testFileName);
        try {
            List<ArcProcessFile> results = FileListParser.testParseFile(f, job);
            for (int i = 0; i < results.size(); ++i) {
                System.out.println(results.get(i).getSourcePath() + " to " + ((ArcCopyFile)results.get(i)).getTargetPath());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    private static void testWindows() {
        FileListParser.testMixedDrivesOnWindows();
        FileListParser.testNoSourceOnWindows();
    }

    private static void testMixedDrivesOnWindows() {
        try {
            File listFile = new File(windowsTestFileName);
            listFile.createNewFile();
            FileWriter writer = new FileWriter(listFile);
            writer.write("C:\\temp\\test1" + newline);
            writer.write("C:\\temp\\test2" + newline);
            writer.write("C:\\temp\\test3" + newline);
            writer.write("D:\\temp\\test4" + newline);
            writer.write("C:\\temp\\test5" + newline);
            writer.write("E:\\temp\\test6" + newline);
            writer.close();
            AbstractProfileBase srcProfile = ProfileManager.getProfileByName("Local File System");
            FileListParser.validateFile(listFile, srcProfile, "C:\\", "/test/temp");
        }
        catch (FileListParserException e) {
            System.out.println("Got FileListParserException: " + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void testNoSourceOnWindows() {
        try {
            File listFile = new File(windowsTestFileName);
            AbstractProfileBase srcProfile = ProfileManager.getProfileByName("Local File System");
            FileListParser.validateFile(listFile, srcProfile, "", "/test/temp");
        }
        catch (FileListParserException e) {
            System.out.println("Got FileListParserException: " + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        DM_MAX_CHAR_LIMIT_FOR_FILE = 4095;
    }
}

