/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.utils;

import java.io.File;
import javax.swing.filechooser.FileSystemView;

public class FileUtil {
    public static synchronized boolean mkdirs(String dirName) {
        File dirPath = new File(dirName);
        return dirPath.exists() || dirPath.mkdirs();
    }

    public static String[] splitFilenameFromPath(String pathPlusName) {
        String[] retval = new String[2];
        Character fileSeparator = Character.valueOf('/');
        retval[0] = pathPlusName.substring(0, pathPlusName.lastIndexOf(fileSeparator.charValue()));
        retval[1] = pathPlusName.substring(pathPlusName.lastIndexOf(fileSeparator.charValue()) + 1);
        return retval;
    }

    public static String getPath(String pathPlusName) {
        Character fileSeperator = null;
        String retval = pathPlusName;
        if (pathPlusName.lastIndexOf(File.separatorChar) >= 0) {
            fileSeperator = Character.valueOf(File.separatorChar);
        } else if (pathPlusName.lastIndexOf(47) >= 0) {
            fileSeperator = Character.valueOf('/');
        } else if (pathPlusName.lastIndexOf(92) >= 0) {
            fileSeperator = Character.valueOf('\\');
        }
        if (fileSeperator != null) {
            retval = pathPlusName.substring(0, pathPlusName.lastIndexOf(fileSeperator.charValue()));
        }
        return retval;
    }

    public static String getFilename(String pathPlusName, String pathSeparator) {
        return pathPlusName.substring(pathPlusName.lastIndexOf(pathSeparator) + 1);
    }

    public static String getStartPath() {
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        File startDirectory = fileSystemView.getDefaultDirectory();
        if (startDirectory == null || !startDirectory.exists()) {
            startDirectory = fileSystemView.getHomeDirectory();
        }
        if (startDirectory == null || !startDirectory.exists()) {
            startDirectory = new File(File.pathSeparator);
        }
        return startDirectory.getPath();
    }

    public static String resolvePath(String basePath, String filename, String fileSeparator) {
        String firstPart = basePath;
        String secondPart = filename;
        assert (filename.indexOf(":\\") < 0);
        if (basePath == null) {
            return filename;
        }
        if (!firstPart.endsWith(fileSeparator)) {
            firstPart = firstPart + fileSeparator;
        }
        if (secondPart.indexOf(fileSeparator) == 0) {
            secondPart = secondPart.substring(1);
        }
        return firstPart + secondPart;
    }

    public static String trimTrailingSlash(String filename) {
        if (FileUtil.hasTrailingSlash(filename)) {
            filename = filename.substring(0, filename.length() - 1);
        }
        return filename;
    }

    public static boolean hasTrailingSlash(String filename) {
        boolean result = false;
        if (filename != null && !filename.equals("")) {
            int size = filename.length();
            if (filename.lastIndexOf("/") == size - 1 || filename.lastIndexOf("\\") == size - 1) {
                result = true;
            }
        }
        return result;
    }

    public static String converWindowsPathToUnix(String path, String fileSeparator) {
        if (fileSeparator.equals("\\") && path.indexOf(92) >= 0) {
            path = path.replaceAll("\\\\", "/");
        }
        return path;
    }
}

