/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.utils;

import java.io.UnsupportedEncodingException;

public class RFC2396Encoder {
    private static final String PATH_STRING = "/";
    private static final String UNRESERVED_STRING = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'()";
    private static final String UNRESERVED_STRING_FOR_PATHS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'()/";
    private static final String HEX_CHARS = "0123456789abcdefABCDEF";

    public static String encode(String unencoded) throws UnsupportedEncodingException {
        return RFC2396Encoder.encode(unencoded, true);
    }

    private static String encode(String unencoded, boolean path) throws UnsupportedEncodingException {
        String ignore = path ? UNRESERVED_STRING_FOR_PATHS : UNRESERVED_STRING;
        return RFC2396Encoder.encode(unencoded, ignore, false);
    }

    private static String encode(String unencoded, String ignore, boolean isPartiallyEncodedAlready) throws UnsupportedEncodingException {
        if (unencoded == null) {
            return null;
        }
        char[] chars = unencoded.toCharArray();
        StringBuilder builder = new StringBuilder(chars.length);
        int expectedHexCharCnt = 0;
        for (char c : chars) {
            byte[] bytes;
            if (expectedHexCharCnt > 0) {
                if (HEX_CHARS.indexOf(c) == -1) {
                    throw new IllegalArgumentException(unencoded + " contains a % that is not followed by two hex chars");
                }
                --expectedHexCharCnt;
                builder.append(c);
                continue;
            }
            if (isPartiallyEncodedAlready && c == '%') {
                expectedHexCharCnt = 2;
                builder.append(c);
                continue;
            }
            if (ignore.indexOf(c) != -1) {
                builder.append(c);
                continue;
            }
            for (byte b : bytes = RFC2396Encoder.getBytes(c)) {
                builder.append(String.format("%%%02x", b));
            }
        }
        if (expectedHexCharCnt > 0) {
            throw new IllegalArgumentException(unencoded + " contains a % that is not followed by two hex chars");
        }
        return builder.toString();
    }

    private static byte[] getBytes(char c) throws UnsupportedEncodingException {
        String s = String.valueOf(c);
        return s.getBytes("UTF-8");
    }

    public static String fixEncoding(String partiallyEncoded) throws UnsupportedEncodingException, IllegalArgumentException {
        return RFC2396Encoder.encode(partiallyEncoded, UNRESERVED_STRING_FOR_PATHS, true);
    }
}

