/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.utils;

import java.text.DecimalFormat;
import java.util.Collection;

public class StringUtils {
    private static DecimalFormat decimalFormat = new DecimalFormat("0.00");
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String EMPTYSTR = "";
    private static final long KILOBYTE = 1024L;
    private static final long MEGABYTE = 0x100000L;
    private static final long GIGABYTE = 0x40000000L;
    private static final long TERABYTE = 0x10000000000L;
    private static final long PETABYTE = 0x4000000000000L;
    private static final long MINUTE = 60L;
    private static final long HOUR = 3600L;
    private static final long DAY = 86400L;
    private static final long WEEK = 604800L;
    private static final int LINE_WRAP_CHARS = 100;

    public static int[] toIntArray(String value) {
        int[] intArray = null;
        if (value != null) {
            String[] splitValueArray = value.split(",");
            intArray = new int[splitValueArray.length];
            for (int index = 0; index < splitValueArray.length; ++index) {
                intArray[index] = Integer.parseInt(splitValueArray[index].trim());
            }
        }
        return intArray;
    }

    public static String bytesToStringWithUnit(long value) {
        return StringUtils.bytesToStringWithUnit(value, decimalFormat);
    }

    public static String bytesToStringWithUnit(long value, DecimalFormat decimalFormat) {
        String units;
        double capacity;
        DecimalFormat format = decimalFormat;
        if (value > 0x4000000000000L) {
            capacity = (double)value / 1.125899906842624E15;
            units = " PB";
        } else if (value > 0x10000000000L) {
            capacity = (double)value / 1.099511627776E12;
            units = " TB";
        } else if (value > 0x40000000L) {
            capacity = (double)value / 1.073741824E9;
            units = " GB";
        } else if (value > 0x100000L) {
            capacity = (double)value / 1048576.0;
            units = " MB";
        } else if (value > 1024L) {
            capacity = (double)value / 1024.0;
            units = " KB";
        } else {
            capacity = value;
            units = capacity == 1.0 ? " byte" : " bytes";
            format = new DecimalFormat("0");
        }
        return format.format(capacity) + units;
    }

    public static String secondsToStringWithUnits(double value) {
        long numUnits;
        String result = value > 0.0 ? EMPTYSTR : "0 secs";
        double secondsRemaining = value;
        if (secondsRemaining > 604800.0) {
            numUnits = (long)(secondsRemaining / 604800.0);
            secondsRemaining %= 604800.0;
            result = result + numUnits;
            result = result + (numUnits > 1L ? " wks " : " wk ");
        }
        if (secondsRemaining > 86400.0) {
            numUnits = (long)(secondsRemaining / 86400.0);
            secondsRemaining %= 86400.0;
            result = result + numUnits;
            result = result + (numUnits > 1L ? " days " : " day ");
        }
        if (secondsRemaining > 3600.0) {
            numUnits = (long)(secondsRemaining / 3600.0);
            secondsRemaining %= 3600.0;
            result = result + numUnits;
            result = result + (numUnits > 1L ? " hrs " : " hr ");
        }
        if (secondsRemaining > 60.0) {
            numUnits = (long)(secondsRemaining / 60.0);
            secondsRemaining %= 60.0;
            result = result + numUnits;
            result = result + (numUnits > 1L ? " mins " : " min ");
        }
        if (secondsRemaining > 0.0) {
            result = result + (long)secondsRemaining;
            result = result + (secondsRemaining > 1.0 ? " secs" : " sec");
        }
        return result;
    }

    public static String millsecondsToMinutesAndSeconds(long milliseconds) {
        String result = milliseconds > 0L ? EMPTYSTR : "0:00";
        long totalSeconds = milliseconds / 1000L;
        long minutes = totalSeconds / 60L;
        long seconds = totalSeconds % 60L;
        result = result + minutes;
        result = result + ":";
        if (seconds < 10L) {
            result = result + "0";
        }
        result = result + seconds;
        return result;
    }

    public static String trimCharacters(String value, String charValues, boolean fromFront, boolean fromBack) {
        String result = value;
        if (value != null) {
            int lengthBeforeProcessing = -1;
            while (lengthBeforeProcessing != result.length()) {
                lengthBeforeProcessing = result.length();
                for (int index = 0; index < charValues.length(); ++index) {
                    char nextChar = charValues.charAt(index);
                    while (fromFront && result.length() > 0 && result.charAt(0) == nextChar) {
                        result = result.substring(1);
                    }
                    while (fromBack && result.length() > 0 && result.charAt(result.length() - 1) == nextChar) {
                        result = result.substring(0, result.length() - 1);
                    }
                }
            }
        }
        return result;
    }

    public static String lineWrap(String line) {
        if (line != null) {
            String newline = new String(line);
            for (int i = 100; i < line.length(); i += 100) {
                String subline = newline.substring(i);
                int j = i + subline.indexOf(" ");
                newline = newline.substring(0, j) + '\n' + newline.substring(j);
            }
            return newline;
        }
        return EMPTYSTR;
    }

    public static String createCSV(Collection list) {
        return StringUtils.createCSV(list, null);
    }

    public static String createCSV(Collection list, String sep) {
        if (list == null) {
            return null;
        }
        if (sep == null) {
            sep = ", ";
        }
        StringBuilder sb = new StringBuilder();
        for (Object addr : list) {
            sb.append(EMPTYSTR + addr);
            sb.append(sep);
        }
        String s = sb.toString();
        if (s.endsWith(sep)) {
            s = s.substring(0, s.length() - sep.length());
        }
        return s;
    }
}

