/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.utils.database;

import com.archivas.clienttools.arcutils.utils.database.CachedTableIterator;
import com.archivas.clienttools.arcutils.utils.database.DBUtils;
import com.archivas.clienttools.arcutils.utils.database.DatabaseResourceManager;
import com.archivas.clienttools.arcutils.utils.database.DbConnectionPool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractCachedTableIterator<E>
implements CachedTableIterator<E> {
    private Logger log = Logger.getLogger(this.getClass().getName());
    private LinkedList<E> cache = new LinkedList();
    private long nextIdToFetch = -1L;
    private boolean restartAtEnd;
    private PreparedStatement selectMaxIdStmt;
    private PreparedStatement selectMinIdStmt;
    private PreparedStatement selectNextBatchStmt;
    private Connection conn;
    private int batchSize;
    private String sqlConditions;
    private String tableName;

    public AbstractCachedTableIterator(String tablename, String sqlConditions, int batchSize) throws SQLException {
        this(tablename, "*", sqlConditions, batchSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractCachedTableIterator(String tablename, String selectCols, String sqlConditions, int batchSize) throws SQLException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            this.batchSize = batchSize;
            this.sqlConditions = sqlConditions;
            this.tableName = tablename;
            this.conn = DbConnectionPool.getDefaultPool().getConnection();
            String selectMaxIdSql = "SELECT MAX(RECORD_ID) FROM " + tablename;
            String selectMinIdSql = "SELECT MIN(RECORD_ID) FROM " + tablename;
            String selectNextBatchSql = "SELECT " + selectCols + " FROM " + tablename + " WHERE RECORD_ID >= ? AND RECORD_ID < ? ";
            if (sqlConditions != null && sqlConditions.trim().length() > 0) {
                selectNextBatchSql = selectNextBatchSql + " AND (" + sqlConditions.trim() + ")";
            }
            this.selectMaxIdStmt = this.conn.prepareStatement(selectMaxIdSql);
            this.selectMinIdStmt = this.conn.prepareStatement(selectMinIdSql);
            this.selectNextBatchStmt = this.conn.prepareStatement(selectNextBatchSql);
        }
    }

    @Override
    public synchronized void tableChanged(int rowsChanged) {
        this.restartAtEnd = true;
    }

    @Override
    public synchronized E next() throws SQLException {
        if (this.conn == null) {
            throw new IllegalStateException("Iterator is closed");
        }
        if (this.cache.isEmpty()) {
            this.refreshCache();
        }
        return this.cache.poll();
    }

    @Override
    public synchronized List<E> getCachedObjects() {
        return new ArrayList<E>(this.cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshCache() throws SQLException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            boolean startedFromBeginning = false;
            long minIdToFetch = this.nextIdToFetch;
            if (minIdToFetch < 0L) {
                minIdToFetch = DBUtils.executeNumberQuery(this.selectMinIdStmt);
                startedFromBeginning = true;
            }
            long maxIdInTable = DBUtils.executeNumberQuery(this.selectMaxIdStmt);
            long maxIdToFetch = Math.min(maxIdInTable, minIdToFetch + (long)this.batchSize) + 1L;
            if (minIdToFetch > maxIdInTable) {
                if (this.restartAtEnd) {
                    startedFromBeginning = true;
                    this.restartAtEnd = false;
                    minIdToFetch = DBUtils.executeNumberQuery(this.selectMinIdStmt);
                    maxIdToFetch = Math.min(maxIdInTable, minIdToFetch + (long)this.batchSize) + 1L;
                } else {
                    this.nextIdToFetch = minIdToFetch;
                    return;
                }
            }
            while (true) {
                ResultSet rs = null;
                boolean errors = true;
                boolean foundRow = false;
                try {
                    this.selectNextBatchStmt.clearParameters();
                    this.selectNextBatchStmt.setLong(1, minIdToFetch);
                    this.selectNextBatchStmt.setLong(2, maxIdToFetch);
                    rs = this.selectNextBatchStmt.executeQuery();
                    while (rs.next()) {
                        foundRow = true;
                        this.cache.addLast(this.readRow(rs));
                    }
                    errors = false;
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (errors) {
                        this.cache.clear();
                    }
                }
                this.log.log(Level.FINE, Thread.currentThread().getName() + ": Iterator selected rows from " + this.tableName + "  where id between " + minIdToFetch + " and " + maxIdToFetch + " and " + this.sqlConditions + " and " + (foundRow ? "DID" : " did NOT") + " find data");
                if (foundRow) {
                    this.nextIdToFetch = maxIdToFetch;
                    break;
                }
                minIdToFetch = maxIdToFetch;
                maxIdInTable = DBUtils.executeNumberQuery(this.selectMaxIdStmt);
                if (minIdToFetch < (maxIdToFetch = Math.min(maxIdInTable, minIdToFetch + (long)this.batchSize) + 1L)) continue;
                if (!this.restartAtEnd || startedFromBeginning) {
                    this.nextIdToFetch = minIdToFetch;
                    break;
                }
                startedFromBeginning = true;
                this.restartAtEnd = false;
                minIdToFetch = DBUtils.executeNumberQuery(this.selectMinIdStmt);
                maxIdToFetch = Math.min(maxIdInTable, minIdToFetch + (long)this.batchSize) + 1L;
            }
        }
    }

    @Override
    public synchronized void reset() {
        this.nextIdToFetch = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            DbConnectionPool.getDefaultPool().returnConnection(this.conn);
            this.conn = null;
        }
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    protected abstract E readRow(ResultSet var1) throws SQLException;
}

