/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.utils.database;

import com.archivas.clienttools.arcutils.model.FileType;
import com.archivas.clienttools.arcutils.utils.database.DBUtils;
import com.archivas.clienttools.arcutils.utils.database.DatabaseResourceManager;
import com.archivas.clienttools.arcutils.utils.database.DbConnectionPool;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobFilesTableColumn;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobSchema;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobsSchema;
import com.archivas.clienttools.arcutils.utils.database.PooledDbConnection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BatchTableUpdater {
    private static Logger LOG = Logger.getLogger(BatchTableUpdater.class.getName());
    private long nextIdToFetch = 0L;
    private long maxIdInTable;
    private PreparedStatement updateNextBatchStmt;
    private PreparedStatement reducedCntStmt;
    private PooledDbConnection conn;
    private int batchSize;
    private String sqlConditions;
    private String tableName;
    private long jobId;
    private boolean reduceTotalCnt;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BatchTableUpdater(long jobId, String tableName, String updateColsString, String sqlConditions, int batchSize, boolean reduceTotalCount, boolean includeDirsInReducedCount) throws Exception {
        this.jobId = jobId;
        this.reduceTotalCnt = reduceTotalCount;
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            this.batchSize = batchSize;
            this.tableName = tableName;
            this.sqlConditions = sqlConditions;
            this.conn = DbConnectionPool.getDefaultPool().getConnection();
            try {
                this.conn.setAutoCommit(false);
                String selectMaxIdSql = "SELECT MAX(RECORD_ID) FROM " + tableName;
                String updateNextBatchSql = "UPDATE " + tableName + " SET " + updateColsString + " WHERE RECORD_ID >= ? AND RECORD_ID < ?  AND (" + sqlConditions.trim() + ")";
                Statement stmt = this.conn.createStatement();
                try {
                    this.maxIdInTable = DBUtils.executeNumberQuery(stmt, selectMaxIdSql);
                    this.updateNextBatchStmt = this.conn.prepareStatement(updateNextBatchSql);
                }
                finally {
                    try {
                        stmt.close();
                    }
                    catch (Exception e) {
                        LOG.log(Level.WARNING, "An error occurred closing SQL Statement: " + e.getMessage(), e);
                    }
                }
                String getReducedCntSql = "SELECT count(*) FROM " + tableName + " WHERE RECORD_ID >= ? AND RECORD_ID < ?  AND (" + sqlConditions.trim() + ")";
                if (!includeDirsInReducedCount) {
                    getReducedCntSql = getReducedCntSql + " AND " + ManagedJobFilesTableColumn.RECORD_TYPE.toString() + " <> " + FileType.DIRECTORY.ordinal();
                }
                this.reducedCntStmt = this.conn.prepareStatement(getReducedCntSql);
            }
            catch (Exception e) {
                DbConnectionPool.getDefaultPool().returnConnection(this.conn);
            }
        }
    }

    public synchronized boolean updateNextBatch() throws Exception {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            if (this.conn == null) {
                throw new IllegalStateException("BatchTableUpdater is closed");
            }
            long minIdToFetch = this.nextIdToFetch;
            long maxIdToFetch = Math.min(this.maxIdInTable, minIdToFetch + (long)this.batchSize) + 1L;
            if (minIdToFetch > this.maxIdInTable) {
                this.close();
                return false;
            }
            try {
                long startTime = System.currentTimeMillis();
                this.reducedCntStmt.clearParameters();
                this.reducedCntStmt.setLong(1, minIdToFetch);
                this.reducedCntStmt.setLong(2, maxIdToFetch);
                int reduceCnt = DBUtils.executeNumberQuery(this.reducedCntStmt);
                if (reduceCnt > 0) {
                    ManagedJobsSchema.getInstance().decrementTotalAndFailedObjectCnt(this.conn, this.jobId, this.reduceTotalCnt ? reduceCnt : 0, reduceCnt);
                }
                this.updateNextBatchStmt.clearParameters();
                this.updateNextBatchStmt.setLong(1, minIdToFetch);
                this.updateNextBatchStmt.setLong(2, maxIdToFetch);
                int updateCnt = this.updateNextBatchStmt.executeUpdate();
                this.nextIdToFetch = maxIdToFetch;
                ManagedJobSchema.DB_PERFORMANCE_LOG.log(Level.FINE, "Updated " + updateCnt + " rows in " + this.tableName + " between " + minIdToFetch + " and " + maxIdToFetch + " where " + this.sqlConditions + " in " + (System.currentTimeMillis() - startTime) + " ms");
                this.conn.commit();
                return true;
            }
            catch (Exception e) {
                try {
                    this.conn.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.close();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            DbConnectionPool.getDefaultPool().returnConnection(this.conn);
            this.conn = null;
        }
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

