/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.utils.database;

import com.archivas.clienttools.arcutils.impl.jobs.FileStatus;
import com.archivas.clienttools.arcutils.model.ACLMetadata;
import com.archivas.clienttools.arcutils.model.ArcCopyFile;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.model.ArcProcessFile;
import com.archivas.clienttools.arcutils.model.CustomMetadata;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.FileType;
import com.archivas.clienttools.arcutils.model.Owner;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.utils.UidGidUtil;
import com.archivas.clienttools.arcutils.utils.database.CopyJobFilesTableColumn;
import com.archivas.clienttools.arcutils.utils.database.DatabaseResourceManager;
import com.archivas.clienttools.arcutils.utils.database.FileLifeCycle;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobFilesTableColumn;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobSchema;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CopyJobSchema
extends ManagedJobSchema {
    private AbstractProfileBase targetProfile;
    private static final String INSERT_FILES_TO_DISCOVER_COLS = "( " + (Object)((Object)ManagedJobFilesTableColumn.LIFE_CYCLE) + ", " + (Object)((Object)ManagedJobFilesTableColumn.STATUS) + ", " + (Object)((Object)ManagedJobFilesTableColumn.INITIAL_LIST) + ", " + (Object)((Object)ManagedJobFilesTableColumn.RECORD_ID) + ", " + (Object)((Object)ManagedJobFilesTableColumn.RECORD_TYPE) + ", " + (Object)((Object)ManagedJobFilesTableColumn.SOURCE_PATH) + ", " + (Object)((Object)ManagedJobFilesTableColumn.SOURCE_VERSION) + ", " + (Object)((Object)CopyJobFilesTableColumn.TARGET_PATH) + ", " + (Object)((Object)ManagedJobFilesTableColumn.PARENT_RECORD_ID) + ", " + (Object)((Object)CopyJobFilesTableColumn.SOURCE_SYMLINK_TARGET) + " ) values ( " + FileLifeCycle.READY_TO_FIND.ordinal() + ", " + FileStatus.NONE.ordinal() + ", ?, ?, ?, ?, ?, ?, ?, ?)";

    public CopyJobSchema(long jobId) {
        super(jobId);
    }

    public void setTargetProfile(AbstractProfileBase targetProfile) {
        this.targetProfile = targetProfile;
    }

    public AbstractProfileBase getTargetProfile() {
        return this.targetProfile;
    }

    @Override
    protected String getExtraFileDataColumns() {
        return CopyJobFilesTableColumn.getColumnDefinitions();
    }

    @Override
    protected String getInsertFilesToDiscoverSqlCols() {
        return INSERT_FILES_TO_DISCOVER_COLS;
    }

    @Override
    protected void setInsertFilesToDiscoverySqlParams(ArcProcessFile fileToProcess, PreparedStatement preparedStatement, boolean isInitialList, long id, int pathDepth) throws SQLException {
        ArcCopyFile file = (ArcCopyFile)fileToProcess;
        preparedStatement.setInt(1, DatabaseResourceManager.boolToDbValue(isInitialList));
        preparedStatement.setLong(2, id);
        int fileObjectType = FileType.UNKNOWN.ordinal();
        if (file.isDirectory()) {
            fileObjectType = FileType.DIRECTORY.ordinal();
        } else if (file.isFile()) {
            fileObjectType = FileType.FILE.ordinal();
        } else if (file.isSymlink()) {
            fileObjectType = FileType.SYMLINK.ordinal();
        }
        Long version = file.getSourceVersion();
        if (version == null) {
            version = 0L;
        }
        preparedStatement.setInt(3, fileObjectType);
        preparedStatement.setString(4, file.getSourcePath());
        preparedStatement.setLong(5, version);
        preparedStatement.setString(6, file.getTargetPath());
        preparedStatement.setLong(7, file.getParentDatabaseRecordId());
        preparedStatement.setString(8, file.getSymlinkTarget());
    }

    @Override
    protected ArcProcessFile readArcProcessFile(ResultSet rs) throws SQLException {
        ArcMoverFile sourceFile = this.readSourceFile(this.getSourceProfile(), rs);
        String targetPath = rs.getString(CopyJobFilesTableColumn.TARGET_PATH.toString());
        ArcCopyFile copyFile = new ArcCopyFile(sourceFile, this.targetProfile, targetPath);
        int recordId = rs.getInt(ManagedJobFilesTableColumn.RECORD_ID.toString());
        copyFile.setDatabaseRecordId(recordId);
        int parentRecordId = rs.getInt(ManagedJobFilesTableColumn.PARENT_RECORD_ID.toString());
        copyFile.setParentDatabaseRecordId(parentRecordId);
        Boolean isInInitialList = DatabaseResourceManager.dbValToBoolean((Integer)rs.getObject(ManagedJobFilesTableColumn.INITIAL_LIST.toString()));
        if (isInInitialList != null && isInInitialList.booleanValue()) {
            copyFile.setIsPartOfInitList();
        }
        return copyFile;
    }

    private ArcMoverFile readSourceFile(AbstractProfileBase sourceProfile, ResultSet rs) throws SQLException {
        String sourcePath = rs.getString(ManagedJobFilesTableColumn.SOURCE_PATH.toString());
        Long version = rs.getLong(ManagedJobFilesTableColumn.SOURCE_VERSION.toString());
        int recordTypeOrdinalValue = rs.getInt(ManagedJobFilesTableColumn.RECORD_TYPE.toString());
        Boolean shred = DatabaseResourceManager.dbValToBoolean((Integer)rs.getObject(CopyJobFilesTableColumn.SOURCE_INDEX.toString()));
        Boolean hold = DatabaseResourceManager.dbValToBoolean((Integer)rs.getObject(CopyJobFilesTableColumn.SOURCE_HOLD.toString()));
        Integer gid = (Integer)rs.getObject(CopyJobFilesTableColumn.SOURCE_GID.toString());
        Integer uid = (Integer)rs.getObject(CopyJobFilesTableColumn.SOURCE_UID.toString());
        Integer fileMode = (Integer)rs.getObject(CopyJobFilesTableColumn.SOURCE_FILE_MODE.toString());
        Integer dirMode = (Integer)rs.getObject(CopyJobFilesTableColumn.SOURCE_DIR_MODE.toString());
        String cmdValue = rs.getString(CopyJobFilesTableColumn.SOURCE_CUSTOM_METADATA.toString());
        String cmdForm = rs.getString(CopyJobFilesTableColumn.SOURCE_CUSTOM_METADATA_FORM.toString());
        String ownerValue = rs.getString(CopyJobFilesTableColumn.SOURCE_OWNER.toString());
        String aclValue = rs.getString(CopyJobFilesTableColumn.SOURCE_ACL.toString());
        String aclForm = rs.getString(CopyJobFilesTableColumn.SOURCE_ACL_FORM.toString());
        Long size = (Long)rs.getObject(ManagedJobFilesTableColumn.SIZE.toString());
        String symlinkTarget = rs.getString(CopyJobFilesTableColumn.SOURCE_SYMLINK_TARGET.toString());
        FileMetadata metadata = new FileMetadata(FileType.values()[recordTypeOrdinalValue]);
        if (version != null && version > 0L) {
            metadata.setIsVersion(true);
            metadata.setVersionNumber(version);
        }
        metadata.setShred(shred);
        metadata.setRetentionHold(hold);
        metadata.setGid(UidGidUtil.convertIntToLong(gid));
        metadata.setUid(UidGidUtil.convertIntToLong(uid));
        metadata.setFileMode(fileMode);
        metadata.setDirMode(dirMode);
        if (cmdForm != null) {
            metadata.setCustomMetadata(new CustomMetadata(cmdForm, cmdValue));
        }
        if (ownerValue != null) {
            metadata.setOwner(Owner.createFromStringRepresentation(ownerValue));
        }
        if (aclForm != null) {
            metadata.setACL(new ACLMetadata(aclForm, aclValue));
        }
        metadata.setSize(size);
        if (symlinkTarget != null) {
            metadata.setSymlinkTarget(symlinkTarget);
        }
        return ArcMoverFile.getFileInstance(sourceProfile, sourcePath, metadata);
    }
}

