/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.utils.database;

import com.archivas.clienttools.arcutils.utils.database.DatabaseResourceManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBUtils {
    private static final Logger LOG = Logger.getLogger(DBUtils.class.getName());
    private static final Set<String> USER_RELEVANT_SQLSTATES = new HashSet<String>();

    public static ResultSet executeQuery(Statement stmt, String sql) throws SQLException {
        LOG.log(Level.INFO, "Executing query: " + sql);
        return stmt.executeQuery(sql);
    }

    public static int executeUpdate(Statement stmt, String sql) throws SQLException {
        LOG.log(Level.INFO, "Executing sql: " + sql);
        return stmt.executeUpdate(sql);
    }

    public static PreparedStatement prepareStatement(Connection conn, String sql) throws SQLException {
        LOG.log(Level.INFO, "Preparing statement: " + sql);
        return conn.prepareStatement(sql);
    }

    public static PreparedStatement prepareStatement(Connection conn, String name, String sql) throws SQLException {
        LOG.log(Level.INFO, "Preparing statement " + name + ": " + sql);
        return conn.prepareStatement(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeNumberQuery(PreparedStatement stmt) throws SQLException {
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery();
            rs.next();
            int n = rs.getInt(1);
            return n;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeNumberQuery(Statement stmt, String sql) throws SQLException {
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(sql);
            rs.next();
            int n = rs.getInt(1);
            return n;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static String getErrorMessage(String msgPrefix, Exception e) {
        String msg = msgPrefix;
        if (e instanceof SQLException) {
            String sqlState = ((SQLException)e).getSQLState();
            if (sqlState == null) {
                if (e.getMessage() != null) {
                    msg = msg + ": " + e.getMessage();
                }
            } else {
                if (USER_RELEVANT_SQLSTATES.contains(sqlState)) {
                    msg = msg + ": " + e.getMessage();
                } else if ("XSDB6".equals(sqlState) || "XSDB7".equals(sqlState) || "XSDB8".equals(sqlState)) {
                    msg = msg + ": The database in " + DatabaseResourceManager.ROOT_DB_DIR + " is unavailable and may already be in use by another application";
                } else if ("XSDG0".equals(sqlState)) {
                    msg = msg + ": The database in " + DatabaseResourceManager.ROOT_DB_DIR + " could not be read from disk";
                } else if ("XSDG1".equals(sqlState)) {
                    msg = msg + ": The database in " + DatabaseResourceManager.ROOT_DB_DIR + " could not be written to disk; please check if disk is full";
                } else if ("XSTB2".equals(sqlState)) {
                    msg = msg + ": A database error occurred.  Make sure the database in " + DatabaseResourceManager.ROOT_DB_DIR + " is not read-only";
                }
                msg = msg + "  (" + sqlState + ")";
            }
        } else if (e.getMessage() != null) {
            msg = msg + ": " + e.getMessage();
        }
        return msg;
    }

    public static void rollback(Connection conn) {
        try {
            conn.rollback();
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, DBUtils.getErrorMessage("Error rolling back transaction", ex), ex);
        }
    }

    public static void closeConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, DBUtils.getErrorMessage("Error closing DB connection", ex), ex);
            }
        }
    }

    static {
        USER_RELEVANT_SQLSTATES.add("04501");
        USER_RELEVANT_SQLSTATES.add("XBM0H");
        USER_RELEVANT_SQLSTATES.add("XBM0I");
        USER_RELEVANT_SQLSTATES.add("XBM0J");
        USER_RELEVANT_SQLSTATES.add("XBMOR");
        USER_RELEVANT_SQLSTATES.add("XBMOS");
        USER_RELEVANT_SQLSTATES.add("XBM0Z");
        USER_RELEVANT_SQLSTATES.add("XJ004");
        USER_RELEVANT_SQLSTATES.add("XSDF0");
        USER_RELEVANT_SQLSTATES.add("XSDF1");
        USER_RELEVANT_SQLSTATES.add("XSDF2");
        USER_RELEVANT_SQLSTATES.add("XSDG7");
        USER_RELEVANT_SQLSTATES.add("XSDG8");
        USER_RELEVANT_SQLSTATES.add("XSLA4");
        USER_RELEVANT_SQLSTATES.add("XSLAQ");
        USER_RELEVANT_SQLSTATES.add("XSLAR");
        USER_RELEVANT_SQLSTATES.add("XSRS4");
        USER_RELEVANT_SQLSTATES.add("XSRS5");
        USER_RELEVANT_SQLSTATES.add("XSRS6");
    }
}

