/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.utils.database;

import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJobSummary;
import com.archivas.clienttools.arcutils.config.ConfigurationHelper;
import com.archivas.clienttools.arcutils.config.HCPMoverProperties;
import com.archivas.clienttools.arcutils.utils.database.CopyJobFilesTableColumn;
import com.archivas.clienttools.arcutils.utils.database.CopyJobTableColumn;
import com.archivas.clienttools.arcutils.utils.database.DBUtils;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import com.archivas.clienttools.arcutils.utils.database.DeleteJobFilesTableColumn;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobFilesTableColumn;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobSchema;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobTableColumn;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobsSchema;
import com.archivas.clienttools.arcutils.utils.database.NonFatalDatabaseException;
import com.archivas.clienttools.arcutils.utils.database.VersionTableColumn;
import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DatabaseResourceManager {
    protected static final Logger LOG = Logger.getLogger(DatabaseResourceManager.class.getName());
    private static final String DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String PROTOCOL = "jdbc:derby:";
    public static final String ROOT_DB_DIR = MessageFormat.format(ConfigurationHelper.HCPDM_HOME_DIRECTORY, HCPMoverProperties.ROOT_DB_DIR.get(), File.separator);
    private static final String DB_NAME = "database";
    public static final String DB_DIR = ROOT_DB_DIR + File.separator + "database";
    private static final String DB_NOT_FOUND_SQLSTATE = "XJ004";
    private static final String TABLE_DOES_NOT_EXIST_SQLSTATE = "42X05";
    private static final String TABLE_ALREADY_EXISTS_SQLSTATE = "X0Y32";
    private static final String UNABLE_TO_ALTER_NONEXISTENT_TABLE_SQLSTATE = "42Y55";
    private static final List<ManagedJobSummary> corruptJobs = new ArrayList<ManagedJobSummary>();
    protected static final Object DB_LOCK = new Object();
    public static final String VERSION_TABLE_NAME = "dm_version_info";
    private static final int CURRENT_SCHEMA_VERSION = 4;
    private static final int INITIAL_SCHEMA_VERSION = 1;

    private DatabaseResourceManager() {
    }

    public static synchronized Connection createConnection() throws SQLException {
        return DatabaseResourceManager.createConnection(false);
    }

    public static synchronized void openOrCreateDatabase() throws SQLException {
        try (Connection conn = DatabaseResourceManager.createConnection(true);){
            DatabaseResourceManager.initializeDerbyProperties(conn);
        }
    }

    private static void initializeDerbyProperties(Connection conn) throws SQLException {
        CallableStatement cs = conn.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)");
        cs.setString(1, "derby.language.logStatementText");
        cs.setString(2, HCPMoverProperties.DERBY_LOG_STATEMENTS.get());
        cs.execute();
        cs.setString(1, "derby.language.logQueryPlan");
        cs.setString(2, HCPMoverProperties.DERBY_LOG_QUERY_PLAN.get());
        cs.execute();
        cs.close();
    }

    private static synchronized Connection createConnection(boolean createDbIfNecessary) throws SQLException {
        Connection conn;
        ReflectiveOperationException exception = null;
        try {
            Class.forName(DRIVER).newInstance();
        }
        catch (InstantiationException e) {
            exception = e;
        }
        catch (IllegalAccessException e) {
            exception = e;
        }
        catch (ClassNotFoundException e) {
            exception = e;
        }
        if (exception != null) {
            throw new SQLException(exception.getMessage(), exception);
        }
        File rootDBDir = new File(ROOT_DB_DIR);
        if (createDbIfNecessary && !rootDBDir.exists()) {
            File parent = new File(rootDBDir.getParent());
            if (!parent.exists() && !parent.mkdir()) {
                throw new SQLException("Unable to create database directory " + parent.getAbsolutePath() + ".  Please be sure that directory " + new File(parent.getParent()).getAbsolutePath() + " exists and that you have permissions to it.");
            }
            if (!rootDBDir.mkdir()) {
                throw new SQLException("Unable to create database directory " + rootDBDir.getAbsolutePath() + ".  Please be sure that directory " + new File(rootDBDir.getParent()).getAbsolutePath() + " exists and that you have permissions to it.");
            }
        }
        String connectString = PROTOCOL + new File(DB_DIR).getAbsolutePath();
        try {
            conn = DriverManager.getConnection(connectString + ";create=false");
            LOG.log(Level.FINE, "Connected to DB with connection string: " + connectString + ";create=false");
        }
        catch (SQLException sqle) {
            String sqlState = sqle.getSQLState();
            if (DB_NOT_FOUND_SQLSTATE.equalsIgnoreCase(sqlState) && createDbIfNecessary) {
                LOG.log(Level.INFO, "Database does not exist; creating database");
                conn = DriverManager.getConnection(connectString + ";create=true");
                DatabaseResourceManager.createDatabase(conn);
            }
            throw sqle;
        }
        conn.setTransactionIsolation(1);
        return conn;
    }

    private static void createDatabase(Connection conn) throws SQLException {
        DatabaseResourceManager.createVersionTable(conn, 4);
        ManagedJobsSchema.getInstance().createSchema(conn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int compareCurrentVersionToDbVersion() throws DatabaseException {
        Object object = DB_LOCK;
        synchronized (object) {
            Connection conn = null;
            try {
                DatabaseResourceManager.openOrCreateDatabase();
                conn = DatabaseResourceManager.createConnection();
                int dbSchemaVersion = DatabaseResourceManager.getDbSchemaVersion(conn);
                int n = 4 == dbSchemaVersion ? 0 : (4 < dbSchemaVersion ? -1 : 1);
                return n;
            }
            catch (Exception e) {
                throw new DatabaseException(DBUtils.getErrorMessage("An error occurred determining if database upgrade is required", e), e);
            }
            finally {
                DBUtils.closeConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upgradeDatabase() throws DatabaseException, NonFatalDatabaseException {
        Object object = DB_LOCK;
        synchronized (object) {
            Connection conn = null;
            try {
                conn = DatabaseResourceManager.createConnection();
                conn.setAutoCommit(false);
                NonFatalDatabaseException exception = null;
                int dbSchemaVersion = DatabaseResourceManager.getDbSchemaVersion(conn);
                while (dbSchemaVersion < 4) {
                    switch (dbSchemaVersion) {
                        case 1: {
                            try {
                                DatabaseResourceManager.upgradeToSchema2(conn);
                            }
                            catch (NonFatalDatabaseException e) {
                                if (exception != null) break;
                                exception = e;
                            }
                            break;
                        }
                        case 2: {
                            try {
                                DatabaseResourceManager.upgradeToSchema3(conn);
                            }
                            catch (NonFatalDatabaseException e) {
                                if (exception != null) break;
                                exception = e;
                            }
                            break;
                        }
                        case 3: {
                            try {
                                DatabaseResourceManager.upgradeToSchema4(conn);
                            }
                            catch (NonFatalDatabaseException e) {
                                if (exception != null) break;
                                exception = e;
                            }
                            break;
                        }
                    }
                    DatabaseResourceManager.saveDbSchemaVersion(conn, ++dbSchemaVersion);
                    conn.commit();
                }
                if (exception != null) {
                    throw exception;
                }
            }
            catch (NonFatalDatabaseException e) {
                throw e;
            }
            catch (Exception e) {
                DBUtils.rollback(conn);
                throw new DatabaseException(DBUtils.getErrorMessage("An error occurred upgrading the database", e), e);
            }
            finally {
                DBUtils.closeConnection(conn);
            }
        }
    }

    private static int getDbSchemaVersion(Connection conn) throws SQLException {
        String sql = "SELECT " + (Object)((Object)VersionTableColumn.SCHEMA_VERSION) + " FROM " + VERSION_TABLE_NAME;
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            try {
                int n = DBUtils.executeNumberQuery(stmt, sql);
                return n;
            }
            catch (SQLException sqle) {
                block14: {
                    int n;
                    block15: {
                        if (!TABLE_DOES_NOT_EXIST_SQLSTATE.equalsIgnoreCase(sqle.getSQLState())) break block14;
                        n = 1;
                        if (stmt == null) break block15;
                        try {
                            stmt.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return n;
                }
                throw new SQLException(DBUtils.getErrorMessage("**** Error getting schema version", sqle), sqle);
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveDbSchemaVersion(Connection conn, int version) throws SQLException {
        String sql = "UPDATE dm_version_info SET " + (Object)((Object)VersionTableColumn.SCHEMA_VERSION) + " = " + version;
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            DBUtils.executeUpdate(stmt, sql);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void upgradeToSchema2(Connection conn) throws SQLException, NonFatalDatabaseException {
        NonFatalDatabaseException exception;
        block6: {
            exception = null;
            if (DatabaseResourceManager.createVersionTable(conn, 1)) {
                DatabaseResourceManager.addColumn(conn, "managed_jobs", ManagedJobTableColumn.FAIL_DIR_CNT.getColumnName(), ManagedJobTableColumn.FAIL_DIR_CNT.getDataTypeString());
                try {
                    DatabaseResourceManager.addColumnToJobFilesSchema(conn, "JOB_FILES", ManagedJobFilesTableColumn.DIR_LISTING_IN_PROGRESS.getColumnName(), ManagedJobFilesTableColumn.DIR_LISTING_IN_PROGRESS.getDataTypeString(), null);
                }
                catch (NonFatalDatabaseException e) {
                    exception = e;
                }
                try {
                    DatabaseResourceManager.addColumnToJobFilesSchema(conn, "JOB_FILES", ManagedJobFilesTableColumn.PARENT_RECORD_ID.getColumnName(), ManagedJobFilesTableColumn.PARENT_RECORD_ID.getDataTypeString(), null);
                }
                catch (NonFatalDatabaseException e) {
                    if (exception != null) break block6;
                    exception = e;
                }
            }
        }
        conn.commit();
        if (exception != null) {
            throw exception;
        }
    }

    private static void upgradeToSchema3(Connection conn) throws SQLException, NonFatalDatabaseException {
        NonFatalDatabaseException exception;
        block11: {
            block10: {
                block9: {
                    exception = null;
                    DatabaseResourceManager.addColumn(conn, "copy_job_details", CopyJobTableColumn.OWNER.getColumnName(), CopyJobTableColumn.OWNER.getDataTypeString());
                    DatabaseResourceManager.addColumn(conn, "copy_job_details", CopyJobTableColumn.ACL.getColumnName(), CopyJobTableColumn.ACL.getDataTypeString());
                    DatabaseResourceManager.addColumn(conn, "copy_job_details", CopyJobTableColumn.ACL_FORM.getColumnName(), CopyJobTableColumn.ACL_FORM.getDataTypeString());
                    DatabaseResourceManager.addColumn(conn, "copy_job_details", CopyJobTableColumn.IGNORE_CONFLICTS.getColumnName(), CopyJobTableColumn.IGNORE_CONFLICTS.getDataTypeString());
                    try {
                        DatabaseResourceManager.addColumnToJobFilesSchema(conn, "JOB_FILES", CopyJobFilesTableColumn.SOURCE_OWNER.getColumnName(), CopyJobFilesTableColumn.SOURCE_OWNER.getDataTypeString(), ManagedJob.Type.COPY);
                    }
                    catch (NonFatalDatabaseException e) {
                        exception = e;
                    }
                    try {
                        DatabaseResourceManager.addColumnToJobFilesSchema(conn, "JOB_FILES", CopyJobFilesTableColumn.SOURCE_ACL.getColumnName(), CopyJobFilesTableColumn.SOURCE_ACL.getDataTypeString(), ManagedJob.Type.COPY);
                    }
                    catch (NonFatalDatabaseException e) {
                        if (exception != null) break block9;
                        exception = e;
                    }
                }
                try {
                    DatabaseResourceManager.addColumnToJobFilesSchema(conn, "JOB_FILES", CopyJobFilesTableColumn.SOURCE_ACL_FORM.getColumnName(), CopyJobFilesTableColumn.SOURCE_ACL_FORM.getDataTypeString(), ManagedJob.Type.COPY);
                }
                catch (NonFatalDatabaseException e) {
                    if (exception != null) break block10;
                    exception = e;
                }
            }
            try {
                DatabaseResourceManager.addColumnToJobFilesSchema(conn, "JOB_FILES", ManagedJobFilesTableColumn.STATUS_CODE.getColumnName(), ManagedJobFilesTableColumn.STATUS_CODE.getDataTypeString(), null);
            }
            catch (NonFatalDatabaseException e) {
                if (exception != null) break block11;
                exception = e;
            }
        }
        conn.commit();
        if (exception != null) {
            throw exception;
        }
    }

    private static void upgradeToSchema4(Connection conn) throws SQLException, NonFatalDatabaseException {
        NonFatalDatabaseException exception;
        block8: {
            exception = null;
            DatabaseResourceManager.createMetadataJobDetailsTable(conn);
            DatabaseResourceManager.addColumn(conn, "managed_jobs", ManagedJobTableColumn.MAX_PATH_DEPTH.getColumnName(), ManagedJobTableColumn.MAX_PATH_DEPTH.getDataTypeString(), new Integer(-1));
            try {
                DatabaseResourceManager.addColumnToJobFilesSchema(conn, "JOB_FILES", DeleteJobFilesTableColumn.PATH_DEPTH.getColumnName(), DeleteJobFilesTableColumn.PATH_DEPTH.getDataTypeString(), ManagedJob.Type.DELETE);
            }
            catch (NonFatalDatabaseException e) {
                exception = e;
            }
            try {
                DatabaseResourceManager.addColumnToJobFilesSchema(conn, "JOB_FILES", CopyJobFilesTableColumn.SOURCE_SYMLINK_TARGET.getColumnName(), CopyJobFilesTableColumn.SOURCE_SYMLINK_TARGET.getDataTypeString(), ManagedJob.Type.COPY);
            }
            catch (NonFatalDatabaseException e) {
                if (exception != null) break block8;
                exception = e;
            }
        }
        conn.commit();
        for (ManagedJobSummary job : corruptJobs) {
            try {
                ManagedJobsSchema.getInstance().deleteJob(job.getJobId(), job.getJobType());
            }
            catch (DatabaseException dbe) {
                LOG.severe("Error removing corrupt job " + dbe.toString());
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean createVersionTable(Connection conn, int schemaVersion) throws SQLException {
        Statement stmt = null;
        stmt = conn.createStatement();
        String createSql = "CREATE TABLE dm_version_info (" + VersionTableColumn.getColumnDefinitions() + ")";
        try {
            DBUtils.executeUpdate(stmt, createSql);
        }
        catch (SQLException sqle) {
            if (TABLE_ALREADY_EXISTS_SQLSTATE.equalsIgnoreCase(sqle.getSQLState())) {
                boolean bl = false;
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return bl;
            }
            throw sqle;
        }
        String insertSql = "INSERT INTO dm_version_info( " + (Object)((Object)VersionTableColumn.SCHEMA_VERSION) + ") VALUES ( " + schemaVersion + " )";
        DBUtils.executeUpdate(stmt, insertSql);
        boolean bl = true;
        return bl;
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void createMetadataJobDetailsTable(Connection conn) throws SQLException {
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            ManagedJobsSchema.createMetadataJobDetailsTable(stmt);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void addColumn(Connection conn, String table, String colName, String dataType) throws SQLException {
        DatabaseResourceManager.addColumn(conn, table, colName, dataType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addColumn(Connection conn, String table, String colName, String dataType, Object defaultValue) throws SQLException {
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            String sql = "ALTER TABLE " + table + "  ADD COLUMN " + colName + " " + dataType;
            if (defaultValue != null) {
                sql = sql + " DEFAULT " + defaultValue;
            }
            DBUtils.executeUpdate(stmt, sql);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void addColumnToJobFilesSchema(Connection conn, String table, String colName, String dataType, ManagedJob.Type jobType) throws SQLException, NonFatalDatabaseException {
        NonFatalDatabaseException exception = null;
        List<ManagedJobSummary> allJobs = ManagedJobsSchema.getInstance().getAllJobs(conn);
        for (ManagedJobSummary job : allJobs) {
            if (jobType != null && job.getJobType() != jobType) continue;
            String tableName = ManagedJobSchema.getJobSchemaName(job.getJobId().getId()) + "." + table;
            try {
                DatabaseResourceManager.addColumn(conn, tableName, colName, dataType);
            }
            catch (SQLException e) {
                if (UNABLE_TO_ALTER_NONEXISTENT_TABLE_SQLSTATE.equalsIgnoreCase(e.getSQLState())) {
                    LOG.warning("Marking corrupt job " + job.getJobName() + " for removal");
                    corruptJobs.add(job);
                    continue;
                }
                String errMsg = "An error occurred adding column " + colName + " to table " + tableName;
                errMsg = DBUtils.getErrorMessage(errMsg, e);
                LOG.log(Level.WARNING, errMsg, e);
                if (exception != null) continue;
                exception = new NonFatalDatabaseException(errMsg, e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static synchronized void shutdownDB() {
        if (DRIVER.equals(DRIVER)) {
            boolean gotSQLExc;
            block5: {
                gotSQLExc = false;
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException se) {
                    if (!se.getSQLState().equals("XJ015")) break block5;
                    gotSQLExc = true;
                }
            }
            if (!gotSQLExc) {
                LOG.log(Level.WARNING, "Database did not shut down normally");
            } else {
                LOG.log(Level.INFO, "Database shut down normally");
            }
        }
    }

    public static int boolToDbValue(boolean val) {
        return val ? 1 : 0;
    }

    public static Boolean dbValToBoolean(Integer dbVal) {
        if (dbVal == null) {
            return null;
        }
        return dbVal != 0;
    }
}

