/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.utils.database;

import com.archivas.clienttools.arcutils.config.HCPMoverProperties;
import com.archivas.clienttools.arcutils.utils.database.DatabaseResourceManager;
import com.archivas.clienttools.arcutils.utils.database.PooledDbConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DbConnectionPool {
    private static Logger LOG = Logger.getLogger(DbConnectionPool.class.getName());
    private static final DbConnectionPool DEFAULT_POOL = new DbConnectionPool("Default Connection Pool");
    private final Queue<PooledDbConnection> connections = new LinkedList<PooledDbConnection>();
    private String name;
    private boolean trackConnections = HCPMoverProperties.DB_CONNECTION_TRACKING.getAsBoolean();

    public DbConnectionPool(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static DbConnectionPool getDefaultPool() {
        return DEFAULT_POOL;
    }

    public PooledDbConnection getConnection() throws SQLException {
        String connName = "unknown";
        if (this.trackConnections) {
            Exception e = new Exception();
            StackTraceElement[] elements = e.getStackTrace();
            connName = elements[1].toString();
        }
        return this.getConnection(connName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PooledDbConnection getConnection(String connName) throws SQLException {
        PooledDbConnection conn = null;
        Queue<PooledDbConnection> queue = this.connections;
        synchronized (queue) {
            do {
                if (conn == null) continue;
                try {
                    conn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LOG.log(Level.WARNING, "Connection pool \"" + this.getName() + "\" contained invalid connection: " + conn.getName());
            } while ((conn = this.connections.poll()) != null && !conn.isValid(1000));
            if (conn == null) {
                conn = new PooledDbConnection(DatabaseResourceManager.createConnection());
            }
            conn.setName(connName);
        }
        return conn;
    }

    public void returnConnection(Connection dbConn) {
        this.returnConnection(dbConn, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnConnection(Connection dbConn, boolean closeNamedPreparedStatements) {
        if (dbConn == null) {
            return;
        }
        if (!(dbConn instanceof PooledDbConnection)) {
            throw new RuntimeException("only PooledDbConnections can be returned to pool");
        }
        PooledDbConnection conn = (PooledDbConnection)dbConn;
        try {
            conn.cleanupConnection(closeNamedPreparedStatements);
            Queue<PooledDbConnection> queue = this.connections;
            synchronized (queue) {
                this.connections.add(conn);
            }
        }
        catch (Exception e) {
            try {
                conn.closeConnection();
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "An error occurred closing a connection", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        Queue<PooledDbConnection> queue = this.connections;
        synchronized (queue) {
            for (PooledDbConnection conn : this.connections) {
                try {
                    conn.closeConnection();
                }
                catch (Exception exception) {}
            }
            this.connections.clear();
        }
    }
}

