/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.utils.database;

import com.archivas.clienttools.arcutils.impl.jobs.FileStatus;
import com.archivas.clienttools.arcutils.model.ArcDeleteFile;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.model.ArcProcessFile;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.FileType;
import com.archivas.clienttools.arcutils.utils.database.DBUtils;
import com.archivas.clienttools.arcutils.utils.database.DatabaseResourceManager;
import com.archivas.clienttools.arcutils.utils.database.DeleteJobFilesTableColumn;
import com.archivas.clienttools.arcutils.utils.database.FileLifeCycle;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobFilesTableColumn;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobSchema;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DeleteJobSchema
extends ManagedJobSchema {
    private static final String INSERT_FILES_TO_DISCOVER_COLS = "( " + (Object)((Object)ManagedJobFilesTableColumn.LIFE_CYCLE) + ", " + (Object)((Object)ManagedJobFilesTableColumn.STATUS) + ", " + (Object)((Object)ManagedJobFilesTableColumn.INITIAL_LIST) + ", " + (Object)((Object)ManagedJobFilesTableColumn.RECORD_ID) + ", " + (Object)((Object)ManagedJobFilesTableColumn.RECORD_TYPE) + ", " + (Object)((Object)ManagedJobFilesTableColumn.SOURCE_PATH) + ", " + (Object)((Object)ManagedJobFilesTableColumn.PARENT_RECORD_ID) + ", " + (Object)((Object)DeleteJobFilesTableColumn.PATH_DEPTH) + " ) values ( " + FileLifeCycle.READY_TO_FIND.ordinal() + ", " + FileStatus.NONE.ordinal() + ", ?, ?, ?, ?, ?, ?)";

    public DeleteJobSchema(long jobId) {
        super(jobId);
    }

    @Override
    protected String getExtraFileDataColumns() {
        return DeleteJobFilesTableColumn.getColumnDefinitions();
    }

    @Override
    protected String getInsertFilesToDiscoverSqlCols() {
        return INSERT_FILES_TO_DISCOVER_COLS;
    }

    @Override
    protected void setInsertFilesToDiscoverySqlParams(ArcProcessFile file, PreparedStatement preparedStatement, boolean isInitialList, long id, int pathDepth) throws SQLException {
        preparedStatement.setInt(1, DatabaseResourceManager.boolToDbValue(isInitialList));
        preparedStatement.setLong(2, id);
        int fileObjectType = FileType.UNKNOWN.ordinal();
        if (file.isDirectory()) {
            fileObjectType = FileType.DIRECTORY.ordinal();
        } else if (file.isFile()) {
            fileObjectType = FileType.FILE.ordinal();
        } else if (file.isSymlink()) {
            fileObjectType = FileType.SYMLINK.ordinal();
        }
        preparedStatement.setInt(3, fileObjectType);
        preparedStatement.setString(4, file.getSourcePath());
        preparedStatement.setLong(5, file.getParentDatabaseRecordId());
        preparedStatement.setInt(6, pathDepth);
    }

    @Override
    public ArcProcessFile readArcProcessFile(ResultSet rs) throws SQLException {
        ArcMoverFile sourceFile = this.readSourceFile(rs);
        ArcDeleteFile deleteFile = new ArcDeleteFile(sourceFile);
        int recordId = rs.getInt(ManagedJobFilesTableColumn.RECORD_ID.toString());
        deleteFile.setDatabaseRecordId(recordId);
        int parentRecordId = rs.getInt(ManagedJobFilesTableColumn.PARENT_RECORD_ID.toString());
        deleteFile.setParentDatabaseRecordId(parentRecordId);
        Boolean isInInitialList = DatabaseResourceManager.dbValToBoolean((Integer)rs.getObject(ManagedJobFilesTableColumn.INITIAL_LIST.toString()));
        if (isInInitialList != null && isInInitialList.booleanValue()) {
            deleteFile.setIsPartOfInitList();
        }
        return deleteFile;
    }

    private ArcMoverFile readSourceFile(ResultSet rs) throws SQLException {
        String sourcePath = rs.getString(ManagedJobFilesTableColumn.SOURCE_PATH.toString());
        int recordTypeOrdinalValue = rs.getInt(ManagedJobFilesTableColumn.RECORD_TYPE.toString());
        FileMetadata metadata = new FileMetadata(FileType.values()[recordTypeOrdinalValue]);
        return ArcMoverFile.getFileInstance(this.getSourceProfile(), sourcePath, metadata);
    }

    @Override
    protected void createFilesTable(Statement stmt) throws SQLException {
        super.createFilesTable(stmt);
        String dirDepthIndexSql = "CREATE INDEX LIFE_CYCLE_STATUS_PATH_DEPTH_INDEX ON " + this.qualifiedFilesTableName + " (" + ManagedJobFilesTableColumn.LIFE_CYCLE.toString() + ", " + (Object)((Object)ManagedJobFilesTableColumn.STATUS) + ", " + (Object)((Object)DeleteJobFilesTableColumn.PATH_DEPTH) + ")";
        DBUtils.executeUpdate(stmt, dirDepthIndexSql);
    }
}

