/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.utils.database;

import com.archivas.clienttools.arcutils.utils.database.DatabaseDataType;

public enum DirListingTempTableColumn {
    PATH(DatabaseDataType.VARCHAR, 4096);

    private final String dataTypeString;
    private DatabaseDataType dataTypeEnum;

    private DirListingTempTableColumn(DatabaseDataType dataType) {
        this(dataType, null);
    }

    private DirListingTempTableColumn(DatabaseDataType dataType, Integer colSize) {
        this.dataTypeEnum = dataType;
        StringBuilder sb = new StringBuilder(dataType.toString());
        if (colSize != null) {
            sb.append("(").append(colSize).append(")");
        }
        this.dataTypeString = sb.toString();
    }

    public String getColumnName() {
        return this.toString();
    }

    public String getDataTypeString() {
        return this.dataTypeString;
    }

    public DatabaseDataType getDataTypeEnum() {
        return this.dataTypeEnum;
    }

    public static String getPrimaryKeyString() {
        return "primary key(" + PATH.toString() + ")";
    }

    public static String getColumnDefinitions() {
        StringBuilder sb = new StringBuilder();
        for (DirListingTempTableColumn column : DirListingTempTableColumn.values()) {
            sb.append(column.getColumnName());
            sb.append(" ");
            sb.append(column.getDataTypeString());
            sb.append(", ");
        }
        return sb.toString();
    }
}

