/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.utils.database;

import com.archivas.clienttools.arcutils.config.HCPMoverProperties;
import com.archivas.clienttools.arcutils.impl.jobs.FileStatus;
import com.archivas.clienttools.arcutils.utils.database.CachedTableIterator;
import com.archivas.clienttools.arcutils.utils.database.DBUtils;
import com.archivas.clienttools.arcutils.utils.database.DatabaseResourceManager;
import com.archivas.clienttools.arcutils.utils.database.DbConnectionPool;
import com.archivas.clienttools.arcutils.utils.database.FileLifeCycle;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobFilesTableColumn;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobSchema;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

public abstract class LifeCycleBasedCachedTableIterator<E>
implements CachedTableIterator<E> {
    protected UpdateMethod updateMethod;
    protected String selectSql;
    protected String updateSql;
    private final int batchSize;
    private final int earlyRefreshSize;
    private final Object dbLock = new Object();
    private final LinkedList<E> cache = new LinkedList();
    private boolean earlyRefreshActive;
    private Connection conn;
    private long rowsChangedSinceRefresh;
    private boolean lastRefreshFoundNothing;

    public LifeCycleBasedCachedTableIterator(String tablename, String selectCols, FileLifeCycle lifeCycleToFetch, FileLifeCycle lifeCycleToSet, int batchSize) throws SQLException {
        this(batchSize);
        String indexName;
        boolean useSimpleIndex = HCPMoverProperties.DB_LIFE_CYCLE_USE_SIMPLE_INDEX.getAsBoolean();
        String string = indexName = useSimpleIndex ? "LIFE_CYCLE_INDEX" : "LIFE_CYCLE_STATUS_RECORD_ID_INDEX";
        if (this.updateMethod.updateViaCursor()) {
            this.selectSql = "SELECT " + selectCols + " FROM " + tablename + " --DERBY-PROPERTIES index=" + indexName + "\n WHERE " + ManagedJobFilesTableColumn.LIFE_CYCLE.toString() + " = " + lifeCycleToFetch.ordinal() + (useSimpleIndex ? "" : " AND " + ManagedJobFilesTableColumn.STATUS.toString() + " = " + FileStatus.NONE.ordinal()) + " FOR UPDATE OF LIFE_CYCLE";
            this.updateSql = "UPDATE " + tablename + " SET " + ManagedJobFilesTableColumn.LIFE_CYCLE.toString() + " = " + lifeCycleToSet.ordinal() + " WHERE CURRENT OF ";
        } else {
            this.selectSql = "SELECT " + selectCols + " FROM " + tablename + " --DERBY-PROPERTIES index=" + indexName + "\n WHERE " + ManagedJobFilesTableColumn.LIFE_CYCLE.toString() + " = " + lifeCycleToFetch.ordinal() + (useSimpleIndex ? "" : " AND " + ManagedJobFilesTableColumn.STATUS.toString() + " = " + FileStatus.NONE.ordinal());
            this.updateSql = "UPDATE " + tablename + " SET " + ManagedJobFilesTableColumn.LIFE_CYCLE.toString() + " = " + lifeCycleToSet.ordinal() + " WHERE " + (this.updateMethod == UpdateMethod.INDEX_COLS ? ManagedJobFilesTableColumn.LIFE_CYCLE.toString() + " = " + lifeCycleToFetch.ordinal() + " AND " + ManagedJobFilesTableColumn.STATUS.toString() + " = " + FileStatus.NONE.ordinal() + " AND " : "") + "RECORD_ID = ?";
        }
    }

    protected LifeCycleBasedCachedTableIterator(int batchSize) throws SQLException {
        this.batchSize = batchSize;
        this.earlyRefreshSize = (int)((double)batchSize * 0.2);
        this.conn = DbConnectionPool.getDefaultPool().getConnection();
        this.conn.setAutoCommit(false);
        this.updateMethod = LifeCycleBasedCachedTableIterator.getUpdateMethod();
    }

    private static UpdateMethod getUpdateMethod() {
        String updateMethodStr = HCPMoverProperties.DB_LIFE_CYCLE_UPDATE_METHOD.get();
        UpdateMethod method = UpdateMethod.valueOf(updateMethodStr);
        if (method == null) {
            method = UpdateMethod.INDEX_COLS;
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableChanged(int rowsChanged) {
        Object object = this.dbLock;
        synchronized (object) {
            this.rowsChangedSinceRefresh += (long)rowsChanged;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E next() throws SQLException {
        List<E> nextBatch = null;
        boolean doEarlyRefresh = false;
        try {
            E ret;
            LinkedList<E> linkedList = this.cache;
            synchronized (linkedList) {
                ret = this.cache.pollFirst();
                if (ret == null) {
                    this.cache.addAll(this.getBatch(false));
                    ret = this.cache.pollFirst();
                } else if (!this.earlyRefreshActive && this.cache.size() <= this.earlyRefreshSize) {
                    doEarlyRefresh = true;
                    this.earlyRefreshActive = true;
                }
            }
            if (doEarlyRefresh) {
                nextBatch = this.getBatch(true);
            }
            linkedList = ret;
            return (E)linkedList;
        }
        finally {
            if (doEarlyRefresh) {
                LinkedList<E> linkedList = this.cache;
                synchronized (linkedList) {
                    this.earlyRefreshActive = false;
                    if (nextBatch != null) {
                        this.cache.addAll(nextBatch);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<E> getCachedObjects() {
        LinkedList<E> linkedList = this.cache;
        synchronized (linkedList) {
            return new ArrayList<E>(this.cache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<E> getBatch(boolean isEarlyRefresh) throws SQLException {
        ArrayList<E> ret = new ArrayList<E>();
        Object object = this.dbLock;
        synchronized (object) {
            Object object2 = DatabaseResourceManager.DB_LOCK;
            synchronized (object2) {
                if (this.conn == null) {
                    throw new IllegalStateException("Iterator is closed");
                }
                if (this.rowsChangedSinceRefresh == 0L && this.lastRefreshFoundNothing || isEarlyRefresh && this.rowsChangedSinceRefresh < (long)this.earlyRefreshSize) {
                    return ret;
                }
                boolean errors = true;
                Statement selectStmt = null;
                Statement updateStmt = null;
                try {
                    selectStmt = this.conn.createStatement();
                    selectStmt.setMaxRows(this.batchSize + 1);
                    long start = System.currentTimeMillis();
                    ResultSet rs = selectStmt.executeQuery(this.selectSql);
                    long selectEndTime = System.currentTimeMillis();
                    if (this.updateMethod.updateViaCursor()) {
                        updateStmt = this.conn.prepareStatement(this.updateSql + rs.getCursorName());
                    }
                    for (int i = 0; i < this.batchSize && rs.next(); ++i) {
                        int updateCnt;
                        ret.add(this.readRow(rs));
                        if (!this.updateMethod.updateViaCursor() || (updateCnt = updateStmt.executeUpdate()) == 1) continue;
                        throw new SQLException("Failed to update life cycle of object");
                    }
                    if (this.updateMethod.updateViaCursor()) {
                        this.conn.commit();
                        ManagedJobSchema.DB_PERFORMANCE_LOG.log(Level.FINE, "It took " + (selectEndTime - start) + " ms to executy query and " + (System.currentTimeMillis() - selectEndTime) + " ms to update " + ret.size() + " rows (first record_id = " + (ret.isEmpty() ? "null" : Long.valueOf(this.getDatabaseRecordId(ret.get(0)))) + ") for query: " + this.selectSql);
                    } else {
                        ManagedJobSchema.DB_PERFORMANCE_LOG.log(Level.FINE, "It took " + (System.currentTimeMillis() - start) + " ms to executy query and select " + ret.size() + " rows (first record_id = " + (ret.isEmpty() ? "null" : Long.valueOf(this.getDatabaseRecordId(ret.get(0)))) + ") for query: " + this.selectSql);
                    }
                    this.lastRefreshFoundNothing = ret.isEmpty();
                    errors = false;
                }
                finally {
                    if (selectStmt != null) {
                        try {
                            selectStmt.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (updateStmt != null) {
                        try {
                            updateStmt.close();
                        }
                        catch (Exception exception) {}
                        if (errors) {
                            try {
                                this.conn.rollback();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (errors) {
                        ret.clear();
                    }
                }
                if (!this.updateMethod.updateViaCursor() && !ret.isEmpty()) {
                    this.updateStatusOfRows(ret);
                }
                this.rowsChangedSinceRefresh = 0L;
            }
        }
        return ret;
    }

    private void updateStatusOfRows(List<E> rows) throws SQLException {
        Statement updateStmt = null;
        try {
            long startTime = System.currentTimeMillis();
            updateStmt = this.conn.prepareStatement(this.updateSql);
            for (E obj : rows) {
                updateStmt.setLong(1, this.getDatabaseRecordId(obj));
                updateStmt.addBatch();
            }
            updateStmt.executeBatch();
            this.conn.commit();
            ManagedJobSchema.DB_PERFORMANCE_LOG.log(Level.FINE, "Updated " + rows.size() + " rows in " + (System.currentTimeMillis() - startTime) + " ms via query: " + this.updateSql);
        }
        catch (Exception e) {
            rows.clear();
            try {
                this.conn.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new SQLException(DBUtils.getErrorMessage("Error updating rows in the database", e));
        }
        finally {
            if (updateStmt != null) {
                try {
                    updateStmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        LinkedList<E> linkedList = this.cache;
        synchronized (linkedList) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.dbLock;
        synchronized (object) {
            if (this.conn != null) {
                DbConnectionPool.getDefaultPool().returnConnection(this.conn);
                this.conn = null;
            }
        }
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    protected abstract E readRow(ResultSet var1) throws SQLException;

    protected abstract long getDatabaseRecordId(E var1);

    public static enum UpdateMethod {
        CURSOR(true),
        RECORD_ID_ONLY(false),
        INDEX_COLS(false);

        private boolean useCursor;

        private UpdateMethod(boolean useCursor) {
            this.useCursor = useCursor;
        }

        public boolean updateViaCursor() {
            return this.useCursor;
        }
    }
}

