/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.utils.database;

import com.archivas.clienttools.arcutils.config.HCPMoverProperties;
import com.archivas.clienttools.arcutils.impl.jobs.FileStats;
import com.archivas.clienttools.arcutils.impl.jobs.FileStatus;
import com.archivas.clienttools.arcutils.model.ArcProcessFile;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.utils.database.CachedTableIterator;
import com.archivas.clienttools.arcutils.utils.database.DBUtils;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import com.archivas.clienttools.arcutils.utils.database.DatabaseResourceManager;
import com.archivas.clienttools.arcutils.utils.database.DbConnectionPool;
import com.archivas.clienttools.arcutils.utils.database.DirListingTempTableColumn;
import com.archivas.clienttools.arcutils.utils.database.FileLifeCycle;
import com.archivas.clienttools.arcutils.utils.database.LifeCycleBasedCachedTableIterator;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobFilesTableColumn;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobsSchema;
import com.archivas.clienttools.arcutils.utils.database.PathDepthLifeCycleBasedCachedTableIterator;
import com.archivas.clienttools.arcutils.utils.database.PooledDbConnection;
import com.archivas.clienttools.arcutils.utils.database.ResetJobTableIterator;
import com.archivas.clienttools.arcutils.utils.database.ReverseOrderLifeCycleBasedCachedTableIterator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ManagedJobSchema {
    private static final Logger LOG = Logger.getLogger(ManagedJobSchema.class.getName());
    public static final Logger DB_PERFORMANCE_LOG = Logger.getLogger(ManagedJobSchema.class.getName() + ".dbPerformance");
    public static final String JOB_FILES_TABLE_NAME = "JOB_FILES";
    private static final String JOB_SCHEMA_PREFIX = "JOB_";
    public static final String LIFE_CYCLE_INDEX_NAME = "LIFE_CYCLE_INDEX";
    public static final String LIFE_CYCLE_STATUS_RECORD_ID_INDEX_NAME = "LIFE_CYCLE_STATUS_RECORD_ID_INDEX";
    public static final String LIFE_CYCLE_STATUS_PATH_DEPTH_INDEX_NAME = "LIFE_CYCLE_STATUS_PATH_DEPTH_INDEX";
    private static final String INVENTORY_INDEX_NAME = "INVENTORY_INDEX";
    private static final String INITIAL_LIST_INDEX_NAME = "INITIAL_LIST_INDEX";
    private static final String DIR_LISTING_IN_PROGRESS_INDEX_NAME = "DIR_LISTING_INDEX";
    private static final String INSERT_FILES_TO_DISCOVER_STMT_NAME = "insertToDiscovery";
    private static final String UPDATE_LIFE_CYCLE_STMT_NAME = "updateLifeCycle";
    private static final String MARK_FILES_READY_TO_PROCESS_STMT_NAME = "markFilesReadyToProcess";
    private static final String MARK_FILE_PROCESSED_STMT_NAME = "markFileProcessed";
    private static final String MARK_DIR_PROCESSED_STMT_NAME = "markDirProcessed";
    private static final String MARK_DIR_LISTING_IN_PROGRESS_STMT_NAME = "dirListingInProgress";
    private static final String GET_FILES_IN_DIR_IN_PROGRESS_STMT_NAME = "filesInDirInProgress";
    private static final String INSERT_INTO_TEMP_TABLE_STMT_NAME = "insertIntoTempTable";
    private static final String GET_FILE_IN_TEMP_TABLE_STMT_NAME = "fileInTempTable";
    private static final String TEMP_DIR_LISTING_TABLE_NAME = "TEMP_DIR_LISTING";
    private AbstractProfileBase sourceProfile;
    private String insertFilesToDiscoverySql;
    private String updateLifeCycleSql;
    private String markFilesReadyToProcessSql;
    private String getInitialDiscoveryListSql;
    private String markFileProcessedSql;
    private String prepareFilesForResumeSql;
    private String markDirectoryProcessedSql;
    private String markDirListingInProgressSql;
    private String getDirsInProgressSql;
    private String getFilesInDirInProgressSql;
    private String insertIntoTempTableSql;
    private String getFileInTempTableSql;
    protected String qualifiedFilesTableName;
    private String qualifiedTempTableName;
    private String schemaName;
    private long jobId;
    private long lastDbRecordId = 0L;
    private DbConnectionPool connPool;

    public ManagedJobSchema(long jobId) {
        this.jobId = jobId;
        this.schemaName = ManagedJobSchema.getJobSchemaName(jobId);
        this.qualifiedFilesTableName = this.schemaName + "." + JOB_FILES_TABLE_NAME;
        this.qualifiedTempTableName = this.schemaName + "." + TEMP_DIR_LISTING_TABLE_NAME;
        this.connPool = new DbConnectionPool(this.schemaName);
    }

    public void setSourceProfile(AbstractProfileBase sourceProfile) {
        this.sourceProfile = sourceProfile;
    }

    public AbstractProfileBase getSourceProfile() {
        return this.sourceProfile;
    }

    public long getLastDbRecordId() {
        return this.lastDbRecordId;
    }

    private synchronized void initLastDbRecordId(long lastDbRecordId) throws DatabaseException {
        this.lastDbRecordId = lastDbRecordId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(long lastDbRecordId) throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            try {
                this.initializeSqlStrings();
                this.initLastDbRecordId(lastDbRecordId);
            }
            catch (Exception e) {
                throw new DatabaseException("Unexpected error loading database", e);
            }
        }
    }

    protected long create(PooledDbConnection conn, List<ArcProcessFile> initialDiscoveryList) throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            try {
                this.initializeSqlStrings();
                return this.createSchema(conn, initialDiscoveryList);
            }
            catch (DatabaseException dbe) {
                throw dbe;
            }
            catch (Exception e) {
                throw new DatabaseException("Unexpected error creating database schema", e);
            }
        }
    }

    private long createSchema(PooledDbConnection conn, List<ArcProcessFile> initialDiscoveryList) throws DatabaseException, SQLException {
        Statement stmt = conn.createStatement();
        DBUtils.executeUpdate(stmt, "CREATE SCHEMA " + this.schemaName);
        this.createFilesTable(stmt);
        return this.insertFilesToDiscover(conn, initialDiscoveryList, true);
    }

    private void initializeSqlStrings() {
        this.insertFilesToDiscoverySql = "INSERT INTO " + this.qualifiedFilesTableName + this.getInsertFilesToDiscoverSqlCols();
        this.updateLifeCycleSql = "UPDATE " + this.qualifiedFilesTableName + " SET " + ManagedJobFilesTableColumn.LIFE_CYCLE.toString() + " = ? WHERE " + (Object)((Object)ManagedJobFilesTableColumn.RECORD_ID) + " = ?";
        this.markFilesReadyToProcessSql = "UPDATE " + this.qualifiedFilesTableName + " SET " + ManagedJobFilesTableColumn.LIFE_CYCLE.toString() + " = " + FileLifeCycle.READY_TO_PROCESS.ordinal() + ", " + ManagedJobFilesTableColumn.INCLUDE_IN_INVENTORY.toString() + " = 1, " + ManagedJobFilesTableColumn.SIZE.toString() + " = ? WHERE " + (Object)((Object)ManagedJobFilesTableColumn.RECORD_ID) + " = ?";
        this.getInitialDiscoveryListSql = "SELECT * FROM " + this.qualifiedFilesTableName + " WHERE " + (Object)((Object)ManagedJobFilesTableColumn.INITIAL_LIST) + " = " + DatabaseResourceManager.boolToDbValue(true);
        this.markFileProcessedSql = "UPDATE " + this.qualifiedFilesTableName + " SET " + ManagedJobFilesTableColumn.STATUS.toString() + " = ?, " + ManagedJobFilesTableColumn.RETRIES.toString() + " = ?, " + ManagedJobFilesTableColumn.START_TIME.toString() + " = ?, " + ManagedJobFilesTableColumn.END_TIME.toString() + " = ?, " + ManagedJobFilesTableColumn.RUN_TIME_MS.toString() + " = ?, " + ManagedJobFilesTableColumn.EXCEPTION_MSG.toString() + " = ?, " + ManagedJobFilesTableColumn.STATUS_CODE.toString() + " = ?  WHERE " + (Object)((Object)ManagedJobFilesTableColumn.RECORD_ID) + " = ?";
        this.markDirectoryProcessedSql = "UPDATE " + this.qualifiedFilesTableName + " SET " + ManagedJobFilesTableColumn.LIFE_CYCLE.toString() + " = ? , " + ManagedJobFilesTableColumn.STATUS.toString() + " = ? , " + ManagedJobFilesTableColumn.INCLUDE_IN_INVENTORY.toString() + " = ? , " + ManagedJobFilesTableColumn.EXCEPTION_MSG.toString() + " = ? , " + ManagedJobFilesTableColumn.DIR_LISTING_IN_PROGRESS.toString() + " = ?  WHERE " + (Object)((Object)ManagedJobFilesTableColumn.RECORD_ID) + " = ?";
        this.prepareFilesForResumeSql = "UPDATE " + this.qualifiedFilesTableName + " SET " + ManagedJobFilesTableColumn.LIFE_CYCLE.toString() + " = ? WHERE " + ManagedJobFilesTableColumn.LIFE_CYCLE.toString() + " = ? AND " + (Object)((Object)ManagedJobFilesTableColumn.STATUS) + " = " + FileStatus.NONE.ordinal();
        this.markDirListingInProgressSql = "UPDATE " + this.qualifiedFilesTableName + " SET " + ManagedJobFilesTableColumn.DIR_LISTING_IN_PROGRESS.toString() + " = 1 WHERE " + (Object)((Object)ManagedJobFilesTableColumn.RECORD_ID) + " = ?";
        this.getDirsInProgressSql = "SELECT " + (Object)((Object)ManagedJobFilesTableColumn.RECORD_ID) + ", " + (Object)((Object)ManagedJobFilesTableColumn.SOURCE_PATH) + " FROM " + this.qualifiedFilesTableName + " WHERE " + (Object)((Object)ManagedJobFilesTableColumn.DIR_LISTING_IN_PROGRESS) + " = 1 AND " + (Object)((Object)ManagedJobFilesTableColumn.STATUS) + " = " + FileStatus.NONE.ordinal();
        this.getFilesInDirInProgressSql = "SELECT " + (Object)((Object)ManagedJobFilesTableColumn.SOURCE_PATH) + " FROM " + this.qualifiedFilesTableName + " WHERE " + (Object)((Object)ManagedJobFilesTableColumn.PARENT_RECORD_ID) + " = ?";
        this.insertIntoTempTableSql = "INSERT INTO " + this.qualifiedTempTableName + "( " + (Object)((Object)DirListingTempTableColumn.PATH) + " ) values ( ? )";
        this.getFileInTempTableSql = "SELECT *  FROM " + this.qualifiedTempTableName + " WHERE " + (Object)((Object)DirListingTempTableColumn.PATH) + " = ?";
    }

    protected void createFilesTable(Statement stmt) throws SQLException {
        String sql = "CREATE TABLE " + this.qualifiedFilesTableName + " (" + ManagedJobFilesTableColumn.getColumnDefinitions() + this.getExtraFileDataColumns() + ManagedJobFilesTableColumn.getPrimaryKeyString() + ")";
        DBUtils.executeUpdate(stmt, sql);
        String index2Sql = "CREATE INDEX INVENTORY_INDEX ON " + this.qualifiedFilesTableName + " (" + ManagedJobFilesTableColumn.INCLUDE_IN_INVENTORY.toString() + ", " + (Object)((Object)ManagedJobFilesTableColumn.STATUS) + ")";
        DBUtils.executeUpdate(stmt, index2Sql);
        String index3Sql = "CREATE INDEX INITIAL_LIST_INDEX ON " + this.qualifiedFilesTableName + " (" + ManagedJobFilesTableColumn.INITIAL_LIST.toString() + ")";
        DBUtils.executeUpdate(stmt, index3Sql);
        boolean useSimpleIndex = HCPMoverProperties.DB_LIFE_CYCLE_USE_SIMPLE_INDEX.getAsBoolean();
        String index4Sql = "CREATE INDEX LIFE_CYCLE_INDEX ON " + this.qualifiedFilesTableName + " (" + ManagedJobFilesTableColumn.LIFE_CYCLE.toString() + ")";
        if (useSimpleIndex) {
            DBUtils.executeUpdate(stmt, index4Sql);
        } else {
            DB_PERFORMANCE_LOG.log(Level.WARNING, "Per configuration setting " + HCPMoverProperties.DB_LIFE_CYCLE_USE_SIMPLE_INDEX.getKey() + ", skipping creation of simple life cycle index.  If you set the parameter to true, you must manually create the index via the following SQL: " + index4Sql);
        }
        String index5Sql = "CREATE INDEX LIFE_CYCLE_STATUS_RECORD_ID_INDEX ON " + this.qualifiedFilesTableName + " (" + ManagedJobFilesTableColumn.LIFE_CYCLE.toString() + ", " + (Object)((Object)ManagedJobFilesTableColumn.STATUS) + ", " + (Object)((Object)ManagedJobFilesTableColumn.RECORD_ID) + " DESC)";
        DBUtils.executeUpdate(stmt, index5Sql);
        String dirListingIndexSql = "CREATE INDEX DIR_LISTING_INDEX ON " + this.qualifiedFilesTableName + " (" + (Object)((Object)ManagedJobFilesTableColumn.DIR_LISTING_IN_PROGRESS) + ", " + (Object)((Object)ManagedJobFilesTableColumn.STATUS) + ")";
        DBUtils.executeUpdate(stmt, dirListingIndexSql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropSchema() throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            PooledDbConnection conn = null;
            try {
                conn = this.connPool.getConnection();
                this.dropTempTable(conn);
                this.dropTable(conn, this.qualifiedFilesTableName);
                Statement stmt = conn.createStatement();
                DBUtils.executeUpdate(stmt, "DROP SCHEMA " + this.schemaName + " RESTRICT");
                conn.commit();
            }
            catch (Exception e) {
                throw new DatabaseException(DBUtils.getErrorMessage("An error occurred dropping schema " + this.schemaName, e), e);
            }
            finally {
                this.connPool.returnConnection(conn);
            }
        }
    }

    private void createTempTable(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        String sql = "CREATE TABLE " + this.qualifiedTempTableName + " (" + DirListingTempTableColumn.getColumnDefinitions() + DirListingTempTableColumn.getPrimaryKeyString() + ")";
        DBUtils.executeUpdate(stmt, sql);
    }

    private void dropTempTable(Connection conn) {
        this.dropTable(conn, this.qualifiedTempTableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTable(Connection conn, String tableName) {
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            DBUtils.executeUpdate(stmt, "DROP TABLE " + tableName);
        }
        catch (SQLException sqle) {
            if ("42Y55".equalsIgnoreCase(sqle.getSQLState())) {
            } else {
                LOG.log(Level.WARNING, DBUtils.getErrorMessage("Failed to drop table " + tableName, sqle));
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, DBUtils.getErrorMessage("Failed to drop table " + tableName, e));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception sqle) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertDirListingBatch(Collection<ArcProcessFile> dirFiles, ArcProcessFile dir, boolean firstBatch) throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            PooledDbConnection conn = null;
            try {
                conn = this.connPool.getConnection();
                conn.setAutoCommit(false);
                if (firstBatch) {
                    PreparedStatement stmt = conn.prepareStatement(MARK_DIR_LISTING_IN_PROGRESS_STMT_NAME, this.markDirListingInProgressSql);
                    stmt.clearParameters();
                    stmt.setLong(1, dir.getDatabaseRecordId());
                    stmt.executeUpdate();
                }
                this.insertFilesToDiscover(conn, dirFiles, false);
                conn.commit();
            }
            catch (Exception e) {
                this.rollback(conn);
                throw new DatabaseException(DBUtils.getErrorMessage("An error occurred inserting rows into the database", e), e);
            }
            finally {
                this.connPool.returnConnection(conn);
            }
        }
    }

    public void insertFilesToDiscover(Collection<ArcProcessFile> filesToDiscover) throws DatabaseException {
        this.insertFilesToDiscover(filesToDiscover, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertFilesToDiscover(Collection<ArcProcessFile> filesToDiscover, boolean isInitialList) throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            PooledDbConnection conn = null;
            try {
                conn = this.connPool.getConnection();
                conn.setAutoCommit(false);
                this.insertFilesToDiscover(conn, filesToDiscover, isInitialList);
                conn.commit();
            }
            catch (Exception e) {
                this.rollback(conn);
                throw new DatabaseException(DBUtils.getErrorMessage("An error occurred inserting rows into the database", e), e);
            }
            finally {
                this.connPool.returnConnection(conn);
            }
        }
    }

    private long insertFilesToDiscover(PooledDbConnection conn, Collection<ArcProcessFile> filesToDiscover, boolean isInitialList) throws DatabaseException, SQLException {
        PreparedStatement preparedStatement = conn.prepareStatement(INSERT_FILES_TO_DISCOVER_STMT_NAME, this.insertFilesToDiscoverySql);
        long recordId = this.getNextBlockOfDbRecordIds(filesToDiscover.size());
        int maxPathDepth = 0;
        for (ArcProcessFile file : filesToDiscover) {
            int pathDepth = file.getPathDepth();
            maxPathDepth = Math.max(maxPathDepth, pathDepth);
            this.setInsertFilesToDiscoverySqlParams(file, preparedStatement, isInitialList, ++recordId, pathDepth);
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        if (!isInitialList) {
            ManagedJobsSchema.getInstance().updateDiscoveredObjCnt(conn, this.jobId, filesToDiscover.size(), recordId, maxPathDepth);
        }
        return recordId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getMaxPathDepth() throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            PooledDbConnection conn = null;
            try {
                conn = this.connPool.getConnection();
                int n = this.getMaxPathDepth(conn);
                return n;
            }
            catch (Exception e) {
                throw new DatabaseException(DBUtils.getErrorMessage("An error occurred selecting the max path depth from the database", e), e);
            }
            finally {
                this.connPool.returnConnection(conn);
            }
        }
    }

    private int getMaxPathDepth(PooledDbConnection conn) throws DatabaseException, SQLException {
        return ManagedJobsSchema.getInstance().getMaxPathDepth(conn, this.jobId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ArcProcessFile> getInitialDiscoveryList() throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            PooledDbConnection conn = null;
            try {
                conn = this.connPool.getConnection();
                Statement stmt = conn.createStatement();
                long start = System.currentTimeMillis();
                ResultSet rs = DBUtils.executeQuery(stmt, this.getInitialDiscoveryListSql);
                ArrayList<ArcProcessFile> initialDiscoveryList = new ArrayList<ArcProcessFile>();
                while (rs.next()) {
                    ArcProcessFile file = this.readArcProcessFile(rs);
                    initialDiscoveryList.add(file);
                }
                DB_PERFORMANCE_LOG.log(Level.FINE, "Fetched the initial discovery list in " + (System.currentTimeMillis() - start) + " ms ");
                ArrayList<ArcProcessFile> arrayList = initialDiscoveryList;
                return arrayList;
            }
            catch (Exception e) {
                throw new DatabaseException(DBUtils.getErrorMessage("An error occurred reading the initial discovery list from the database", e), e);
            }
            finally {
                this.connPool.returnConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markFileComplete(ArcProcessFile file) throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            PooledDbConnection conn = null;
            try {
                conn = this.connPool.getConnection();
                PreparedStatement stmt = conn.prepareStatement(UPDATE_LIFE_CYCLE_STMT_NAME, this.updateLifeCycleSql);
                stmt.clearParameters();
                stmt.setInt(1, FileLifeCycle.COMPLETE.ordinal());
                stmt.setLong(2, file.getDatabaseRecordId());
                stmt.executeUpdate();
            }
            catch (Exception e) {
                throw new DatabaseException(DBUtils.getErrorMessage("An error occurred updating the life cycle of a file to complete", e), e);
            }
            finally {
                this.connPool.returnConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markFilesReadyToProcess(Collection<ArcProcessFile> filesReadyToProcess) throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            PooledDbConnection conn = null;
            try {
                conn = this.connPool.getConnection();
                conn.setAutoCommit(false);
                PreparedStatement stmt = conn.prepareStatement(MARK_FILES_READY_TO_PROCESS_STMT_NAME, this.markFilesReadyToProcessSql);
                long sizeToAdd = 0L;
                for (ArcProcessFile file : filesReadyToProcess) {
                    long fileSize = file.getSourceFile().getSize();
                    sizeToAdd += fileSize;
                    stmt.clearParameters();
                    stmt.setLong(1, fileSize);
                    stmt.setLong(2, file.getDatabaseRecordId());
                    stmt.addBatch();
                }
                stmt.executeBatch();
                ManagedJobsSchema.getInstance().updateTotalFilesStats(conn, this.jobId, filesReadyToProcess.size(), sizeToAdd);
                conn.commit();
            }
            catch (Exception e) {
                this.rollback(conn);
                throw new DatabaseException(DBUtils.getErrorMessage("An error occurred marking files ready to process", e), e);
            }
            finally {
                this.connPool.returnConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markFilesProcessed(Collection<FileStats> files) throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            PooledDbConnection conn = null;
            try {
                conn = this.connPool.getConnection();
                PreparedStatement stmt = conn.prepareStatement(MARK_FILE_PROCESSED_STMT_NAME, this.markFileProcessedSql);
                conn.setAutoCommit(false);
                long totalCnt = 0L;
                long totalSize = 0L;
                long successCnt = 0L;
                long successSize = 0L;
                long failCnt = 0L;
                long failSize = 0L;
                long failDirCnt = 0L;
                for (FileStats file : files) {
                    FileStatus status = file.getStatus();
                    switch (status) {
                        case SUCCEEDED: {
                            if (!file.includeInStats()) break;
                            ++successCnt;
                            successSize += file.getSize();
                            break;
                        }
                        case FAILED: {
                            if (file.includeInStats()) {
                                ++failCnt;
                                failSize += file.getSize();
                                if (file.failedDuringFind()) {
                                    ++totalCnt;
                                    totalSize += file.getSize();
                                }
                            }
                            if (!file.getArcProcssFile().isDirectory()) break;
                            ++failDirCnt;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unsupported file status: " + (Object)((Object)status));
                        }
                    }
                    stmt.clearParameters();
                    stmt.setInt(1, file.getStatus().ordinal());
                    stmt.setInt(2, file.getRetries());
                    Date startTime = file.getStartTime();
                    if (startTime != null) {
                        stmt.setLong(3, startTime.getTime());
                    } else {
                        stmt.setNull(3, -5);
                    }
                    Date endTime = file.getEndTime();
                    if (endTime != null) {
                        stmt.setLong(4, endTime.getTime());
                    } else {
                        stmt.setNull(4, -5);
                    }
                    stmt.setLong(5, file.getRunTimeMs());
                    if (file.getException() == null) {
                        stmt.setNull(6, 12);
                    } else {
                        stmt.setString(6, file.getException().getMessage());
                    }
                    if (file.getStatusCode() == null) {
                        stmt.setNull(7, 4);
                    } else {
                        stmt.setInt(7, file.getStatusCode());
                    }
                    stmt.setLong(8, file.getDatabaseRecordId());
                    stmt.addBatch();
                }
                stmt.executeBatch();
                ManagedJobsSchema.getInstance().updateProcessedFilesStats(conn, this.jobId, totalCnt, totalSize, successCnt, successSize, failCnt, failSize, failDirCnt);
                conn.commit();
            }
            catch (Exception e) {
                this.rollback(conn);
                throw new DatabaseException(DBUtils.getErrorMessage("An error occurred updating file stats on table " + this.qualifiedFilesTableName, e), e);
            }
            finally {
                this.connPool.returnConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDirProcessed(ArcProcessFile dir, Collection<ArcProcessFile> dirFiles, Exception dirFailureException, boolean processingRequired, boolean postProcessingRequired) throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            PooledDbConnection conn = null;
            try {
                int failDirCntToAdd;
                int dirListingInProgress;
                FileStatus status;
                FileLifeCycle lifeCycle;
                conn = this.connPool.getConnection();
                conn.setAutoCommit(false);
                if (!dirFiles.isEmpty()) {
                    this.insertFilesToDiscover(conn, dirFiles, false);
                }
                if (dirFailureException != null) {
                    lifeCycle = FileLifeCycle.FINDING;
                    status = FileStatus.FAILED;
                    dirListingInProgress = 1;
                } else if (processingRequired) {
                    lifeCycle = FileLifeCycle.READY_TO_PROCESS;
                    status = FileStatus.NONE;
                    dirListingInProgress = 0;
                } else if (postProcessingRequired) {
                    lifeCycle = FileLifeCycle.READY_TO_POSTPROCESS;
                    status = FileStatus.NONE;
                    dirListingInProgress = 0;
                } else {
                    lifeCycle = FileLifeCycle.COMPLETE;
                    status = FileStatus.SUCCEEDED;
                    dirListingInProgress = 0;
                }
                int includeInInventory = postProcessingRequired ? 1 : 0;
                PreparedStatement stmt = conn.prepareStatement(MARK_DIR_PROCESSED_STMT_NAME, this.markDirectoryProcessedSql);
                stmt.clearParameters();
                stmt.setInt(1, lifeCycle.ordinal());
                stmt.setInt(2, status.ordinal());
                stmt.setInt(3, includeInInventory);
                if (dirFailureException == null) {
                    stmt.setNull(4, 12);
                } else {
                    stmt.setString(4, dirFailureException.getMessage());
                }
                stmt.setInt(5, dirListingInProgress);
                stmt.setLong(6, dir.getDatabaseRecordId());
                stmt.executeUpdate();
                int totalCntToAdd = postProcessingRequired ? 1 : 0;
                int failCntToAdd = postProcessingRequired && dirFailureException != null ? 1 : 0;
                int n = failDirCntToAdd = dirFailureException != null ? 1 : 0;
                if (totalCntToAdd + failCntToAdd + failDirCntToAdd > 0) {
                    ManagedJobsSchema.getInstance().updateDirStats(conn, this.jobId, totalCntToAdd, failCntToAdd, failDirCntToAdd);
                }
                conn.commit();
            }
            catch (Exception e) {
                this.rollback(conn);
                throw new DatabaseException(DBUtils.getErrorMessage("An error occurred marking directory processing complete in " + this.qualifiedFilesTableName, e), e);
            }
            finally {
                this.connPool.returnConnection(conn);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<String> prepareFilesForResume() throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            PooledDbConnection conn = null;
            try {
                conn = this.connPool.getConnection();
                PreparedStatement stmt = conn.prepareStatement(this.prepareFilesForResumeSql);
                long startTime = System.currentTimeMillis();
                stmt.setInt(1, FileLifeCycle.READY_TO_FIND.ordinal());
                stmt.setInt(2, FileLifeCycle.FINDING.ordinal());
                int cnt = stmt.executeUpdate();
                long now = System.currentTimeMillis();
                DB_PERFORMANCE_LOG.log(Level.FINE, "Updated " + cnt + " rows with life cycle FINDING to life cycle READY_TO_FIND in " + (now - startTime) + " ms");
                startTime = now;
                stmt.setInt(1, FileLifeCycle.READY_TO_PROCESS.ordinal());
                stmt.setInt(2, FileLifeCycle.PROCESSING.ordinal());
                cnt = stmt.executeUpdate();
                now = System.currentTimeMillis();
                DB_PERFORMANCE_LOG.log(Level.FINE, "Updated " + cnt + " rows with life cycle PROCESSING to life cycle READY_TO_PROCESS in " + (now - startTime) + " ms");
                startTime = now;
                stmt.setInt(1, FileLifeCycle.READY_TO_POSTPROCESS.ordinal());
                stmt.setInt(2, FileLifeCycle.POSTPROCESSING.ordinal());
                cnt = stmt.executeUpdate();
                now = System.currentTimeMillis();
                DB_PERFORMANCE_LOG.log(Level.FINE, "Updated " + cnt + " rows with life cycle POSTPROCESSING to life cycle READY_TO_POSTPROCESS in" + (now - startTime) + " ms");
                Set<String> set = this.prepareDirsForResume(conn);
                return set;
            }
            catch (Exception e) {
                this.rollback(conn);
                throw new DatabaseException(DBUtils.getErrorMessage("An error occurred preparing files for resume", e), e);
            }
            finally {
                this.connPool.returnConnection(conn);
            }
        }
    }

    private Set<String> prepareDirsForResume(PooledDbConnection conn) throws SQLException {
        conn.setAutoCommit(false);
        long startTime = System.currentTimeMillis();
        this.dropTempTable(conn);
        this.createTempTable(conn);
        conn.commit();
        HashSet<String> dirsInProgress = new HashSet<String>();
        Statement stmt = conn.createStatement();
        ResultSet rs = DBUtils.executeQuery(stmt, this.getDirsInProgressSql);
        while (rs.next()) {
            String dirPath = rs.getString(ManagedJobFilesTableColumn.SOURCE_PATH.toString());
            dirsInProgress.add(dirPath);
            long dirRecordId = rs.getLong(ManagedJobFilesTableColumn.RECORD_ID.toString());
            this.getFilesInDirInProgress(conn, dirRecordId);
        }
        long now = System.currentTimeMillis();
        DB_PERFORMANCE_LOG.log(Level.FINE, String.format("It took %d ms to prepare directories in progress for resume", now - startTime));
        return dirsInProgress;
    }

    private void getFilesInDirInProgress(PooledDbConnection conn, long dirRecordId) throws SQLException {
        PreparedStatement filesInDirStmt = conn.prepareStatement(GET_FILES_IN_DIR_IN_PROGRESS_STMT_NAME, this.getFilesInDirInProgressSql);
        filesInDirStmt.clearParameters();
        filesInDirStmt.setLong(1, dirRecordId);
        HashSet<String> paths = new HashSet<String>();
        ResultSet rs = filesInDirStmt.executeQuery();
        while (rs.next()) {
            String path = rs.getString(ManagedJobFilesTableColumn.SOURCE_PATH.toString());
            paths.add(path);
            if (paths.size() < HCPMoverProperties.PREPROCESS_FILES_BATCH_SIZE.getAsInt()) continue;
            this.insertIntoTempTable(conn, paths);
            paths.clear();
        }
        if (paths.size() > 0) {
            this.insertIntoTempTable(conn, paths);
        }
        rs.close();
    }

    private void insertIntoTempTable(PooledDbConnection conn, Set<String> paths) throws SQLException {
        PreparedStatement insertStmt = conn.prepareStatement(INSERT_INTO_TEMP_TABLE_STMT_NAME, this.insertIntoTempTableSql);
        for (String path : paths) {
            insertStmt.clearParameters();
            insertStmt.setString(1, path);
            insertStmt.addBatch();
        }
        insertStmt.executeBatch();
        conn.commit();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isFileAlreadyDiscovered(String path) throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            PooledDbConnection conn = null;
            try {
                conn = this.connPool.getConnection();
                PreparedStatement stmt = conn.prepareStatement(GET_FILE_IN_TEMP_TABLE_STMT_NAME, this.getFileInTempTableSql);
                stmt.clearParameters();
                stmt.setString(1, path);
                ResultSet rs = stmt.executeQuery();
                boolean ret = rs.next();
                rs.close();
                boolean bl = ret;
                return bl;
            }
            catch (Exception e) {
                throw new DatabaseException(DBUtils.getErrorMessage("An error occurred selecting from temp table", e), e);
            }
            finally {
                this.connPool.returnConnection(conn);
            }
        }
    }

    protected FileStats readFileStats(ResultSet rs) throws SQLException {
        ArcProcessFile processFile = this.readArcProcessFile(rs);
        int retries = rs.getInt(ManagedJobFilesTableColumn.RETRIES.toString());
        long startTime = rs.getLong(ManagedJobFilesTableColumn.START_TIME.toString());
        long endTime = rs.getLong(ManagedJobFilesTableColumn.END_TIME.toString());
        long runTimeMs = rs.getLong(ManagedJobFilesTableColumn.RUN_TIME_MS.toString());
        String errMsg = rs.getString(ManagedJobFilesTableColumn.EXCEPTION_MSG.toString());
        FileStats stats = new FileStats(processFile);
        stats.setRetries(retries);
        stats.setStartTime(new Date(startTime));
        stats.setEndTime(new Date(endTime));
        stats.setRunTimeMs(runTimeMs);
        stats.setException(new Exception(errMsg));
        return stats;
    }

    public void resetJobStats() throws DatabaseException {
        ManagedJobsSchema.getInstance().resetJobStats(this.jobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResetJobTableIterator getResetJobTableIterator(boolean dirsIncludedInTotalCnt) throws Exception {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            return new ResetJobTableIterator(this.jobId, this.qualifiedFilesTableName, dirsIncludedInTotalCnt);
        }
    }

    public void updateFindFilesStatus(boolean isComplete) throws DatabaseException {
        ManagedJobsSchema.getInstance().updateFindFilesStatus(this.jobId, isComplete);
    }

    public void updateRunStats(long startTime, long endTime, long runTime) throws DatabaseException {
        ManagedJobsSchema.getInstance().updateRunStats(this.jobId, startTime, endTime, runTime);
    }

    public FindFileIterator<ArcProcessFile> getFindFileIterator() throws SQLException {
        return new FindFileIterator<ArcProcessFile>();
    }

    public CachedTableIterator<FileStats> getProcessFileIterator() throws SQLException {
        return new ProcessFileIterator<FileStats>();
    }

    public CachedTableIterator<FileStats> getPostProcessReverseOrderFileIterator() throws SQLException {
        return new PostProcessReverseOrderFileIterator<FileStats>();
    }

    public CachedTableIterator<FileStats> getPostProcessPathDepthFileIterator(int pathDepth) throws SQLException {
        return new PostProcessPathDepthFileIterator<FileStats>(pathDepth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpTotalList(File dumpFile, AbstractProfileBase sourceProfile) throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            try {
                this.outputResults(false, null, null, dumpFile, sourceProfile);
            }
            catch (Exception e) {
                throw new DatabaseException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpFailedList(File dumpFile, AbstractProfileBase sourceProfile) throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            try {
                this.outputResults(true, null, FileStatus.FAILED, dumpFile, sourceProfile);
            }
            catch (Exception e) {
                throw new DatabaseException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpSuccessList(File dumpFile, AbstractProfileBase sourceProfile) throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            try {
                this.outputResults(false, null, FileStatus.SUCCEEDED, dumpFile, sourceProfile);
            }
            catch (Exception e) {
                throw new DatabaseException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpConflictsList(File dumpFile, AbstractProfileBase sourceProfile) throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            try {
                this.outputResults(false, 409, null, dumpFile, sourceProfile);
            }
            catch (Exception e) {
                throw new DatabaseException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputResults(boolean includeErrMsg, Integer includeOnlyRowsWithStatusCode, FileStatus status, File outFile, AbstractProfileBase sourceProfile) throws IOException, SQLException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            PooledDbConnection conn = null;
            FileWriter fstream = new FileWriter(outFile);
            BufferedWriter out = new BufferedWriter(fstream);
            try {
                conn = this.connPool.getConnection();
                String sql = "SELECT " + ManagedJobFilesTableColumn.SOURCE_PATH.toString() + (includeErrMsg ? ", " + ManagedJobFilesTableColumn.EXCEPTION_MSG.toString() : "") + " FROM " + this.qualifiedFilesTableName + " WHERE " + ManagedJobFilesTableColumn.INCLUDE_IN_INVENTORY.toString() + " = 1";
                if (status != null) {
                    sql = sql + " AND " + ManagedJobFilesTableColumn.STATUS.toString() + " = " + status.ordinal();
                }
                if (includeOnlyRowsWithStatusCode != null) {
                    sql = sql + " AND " + ManagedJobFilesTableColumn.STATUS_CODE.toString() + " = " + includeOnlyRowsWithStatusCode;
                }
                Statement stmt = conn.createStatement();
                long startTime = System.currentTimeMillis();
                DB_PERFORMANCE_LOG.log(Level.FINE, "Executing export results query: " + sql);
                ResultSet rs = stmt.executeQuery(sql);
                DB_PERFORMANCE_LOG.log(Level.FINE, "Executed export results query in " + (System.currentTimeMillis() - startTime) + " ms");
                long cnt = 0L;
                while (rs.next()) {
                    out.write(sourceProfile.decode(rs.getString(ManagedJobFilesTableColumn.SOURCE_PATH.toString())));
                    if (includeErrMsg) {
                        out.write("," + rs.getString(ManagedJobFilesTableColumn.EXCEPTION_MSG.toString()));
                    }
                    out.newLine();
                    ++cnt;
                }
                DB_PERFORMANCE_LOG.log(Level.FINE, "Exported " + cnt + " files in " + (System.currentTimeMillis() - startTime) + " ms");
            }
            finally {
                this.connPool.returnConnection(conn);
                out.close();
            }
        }
    }

    protected abstract String getExtraFileDataColumns();

    protected abstract String getInsertFilesToDiscoverSqlCols();

    protected abstract void setInsertFilesToDiscoverySqlParams(ArcProcessFile var1, PreparedStatement var2, boolean var3, long var4, int var6) throws SQLException;

    protected abstract ArcProcessFile readArcProcessFile(ResultSet var1) throws SQLException;

    private void rollback(Connection conn) {
        try {
            conn.rollback();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getJobSchemaName(long jobId) {
        return JOB_SCHEMA_PREFIX + jobId;
    }

    private synchronized long getNextBlockOfDbRecordIds(int size) {
        if (size < 0) {
            throw new RuntimeException("size (" + size + ") can not be less than zero");
        }
        long ret = this.lastDbRecordId;
        this.lastDbRecordId += (long)size;
        return ret;
    }

    public void finalize() throws Throwable {
        this.connPool.closeAll();
        super.finalize();
    }

    class PostProcessPathDepthFileIterator<FileStats>
    extends PathDepthLifeCycleBasedCachedTableIterator<FileStats> {
        private PostProcessPathDepthFileIterator(int pathDepth) throws SQLException {
            super(ManagedJobSchema.this.qualifiedFilesTableName, "*", FileLifeCycle.READY_TO_POSTPROCESS, FileLifeCycle.POSTPROCESSING, HCPMoverProperties.POSTPROCESS_FILES_BATCH_SIZE.getAsInt(), pathDepth);
        }

        @Override
        protected FileStats readRow(ResultSet rs) throws SQLException {
            return (FileStats)ManagedJobSchema.this.readFileStats(rs);
        }

        @Override
        protected long getDatabaseRecordId(FileStats file) {
            return ((FileStats)file).getDatabaseRecordId();
        }
    }

    class PostProcessReverseOrderFileIterator<FileStats>
    extends ReverseOrderLifeCycleBasedCachedTableIterator<FileStats> {
        private PostProcessReverseOrderFileIterator() throws SQLException {
            super(ManagedJobSchema.this.qualifiedFilesTableName, "*", FileLifeCycle.READY_TO_POSTPROCESS, FileLifeCycle.POSTPROCESSING, HCPMoverProperties.POSTPROCESS_FILES_BATCH_SIZE.getAsInt());
        }

        @Override
        protected FileStats readRow(ResultSet rs) throws SQLException {
            return (FileStats)ManagedJobSchema.this.readFileStats(rs);
        }

        @Override
        protected long getDatabaseRecordId(FileStats file) {
            return ((FileStats)file).getDatabaseRecordId();
        }
    }

    class ProcessFileIterator<FileStats>
    extends LifeCycleBasedCachedTableIterator<FileStats> {
        private ProcessFileIterator() throws SQLException {
            super(ManagedJobSchema.this.qualifiedFilesTableName, "*", FileLifeCycle.READY_TO_PROCESS, FileLifeCycle.PROCESSING, HCPMoverProperties.PROCESS_FILES_BATCH_SIZE.getAsInt());
        }

        @Override
        protected FileStats readRow(ResultSet rs) throws SQLException {
            return (FileStats)ManagedJobSchema.this.readFileStats(rs);
        }

        @Override
        protected long getDatabaseRecordId(FileStats file) {
            return ((FileStats)file).getDatabaseRecordId();
        }
    }

    class FindFileIterator<ArcProcessFile>
    extends LifeCycleBasedCachedTableIterator<ArcProcessFile> {
        private FindFileIterator() throws SQLException {
            super(ManagedJobSchema.this.qualifiedFilesTableName, "*", FileLifeCycle.READY_TO_FIND, FileLifeCycle.FINDING, HCPMoverProperties.FIND_FILES_BATCH_SIZE.getAsInt());
        }

        @Override
        protected ArcProcessFile readRow(ResultSet rs) throws SQLException {
            return (ArcProcessFile)ManagedJobSchema.this.readArcProcessFile(rs);
        }

        @Override
        protected long getDatabaseRecordId(ArcProcessFile file) {
            return ((ArcProcessFile)file).getDatabaseRecordId();
        }
    }
}

