/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.utils.database;

import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.utils.database.DatabaseDataType;

public enum ManagedJobTableColumn {
    JOB_ID(DatabaseDataType.BIGINT),
    JOB_NAME(DatabaseDataType.VARCHAR, ManagedJob.MAXIMUM_JOB_NAME_LENGTH, true),
    JOB_TYPE(DatabaseDataType.SMALLINT),
    IS_NAME_USER_DEFINED(DatabaseDataType.SMALLINT),
    JOB_STATUS(DatabaseDataType.SMALLINT),
    SOURCE_PROFILE_NAME(DatabaseDataType.VARCHAR, 100),
    SOURCE_PATH(DatabaseDataType.VARCHAR, 4096),
    IMPORT_FILE(DatabaseDataType.VARCHAR, 4096),
    LOW_LOAD_ENABLED(DatabaseDataType.SMALLINT),
    LOW_LOAD_END_TIME(DatabaseDataType.BIGINT),
    LOW_LOAD_MAX_CONN(DatabaseDataType.INT),
    LOW_LOAD_MAX_CONN_PER_NODE(DatabaseDataType.INT),
    LOW_LOAD_START_TIME(DatabaseDataType.BIGINT),
    MAX_CONN_FILE_SYSTEM(DatabaseDataType.INT),
    NORM_LOAD_MAX_CONN(DatabaseDataType.INT),
    NORM_LOAD_MAX_CONN_PER_NODE(DatabaseDataType.INT),
    START_TIME(DatabaseDataType.BIGINT),
    END_TIME(DatabaseDataType.BIGINT),
    RUN_TIME(DatabaseDataType.BIGINT),
    MAX_RECORD_ID(DatabaseDataType.BIGINT),
    DISCOVERED_OBJ_CNT(DatabaseDataType.BIGINT),
    TOTAL_OBJ_CNT(DatabaseDataType.BIGINT),
    TOTAL_OBJ_SIZE(DatabaseDataType.BIGINT),
    SUCCESS_OBJ_CNT(DatabaseDataType.BIGINT),
    SUCCESS_OBJ_SIZE(DatabaseDataType.BIGINT),
    FAIL_OBJ_CNT(DatabaseDataType.BIGINT),
    FAIL_OBJ_SIZE(DatabaseDataType.BIGINT),
    FAIL_DIR_CNT(DatabaseDataType.BIGINT),
    IS_FIND_COMPLETE(DatabaseDataType.SMALLINT),
    MAX_PATH_DEPTH(DatabaseDataType.INT);

    private final String dataTypeString;
    private DatabaseDataType dataTypeEnum;
    private boolean isColumnUnique;

    private ManagedJobTableColumn(DatabaseDataType dataType) {
        this(dataType, null);
    }

    private ManagedJobTableColumn(DatabaseDataType dataType, Integer colSize) {
        this(dataType, colSize, false);
    }

    private ManagedJobTableColumn(DatabaseDataType dataType, Integer colSize, boolean isColumnUnique) {
        this.isColumnUnique = isColumnUnique;
        this.dataTypeEnum = dataType;
        StringBuilder sb = new StringBuilder(dataType.toString());
        if (colSize != null) {
            sb.append("(").append(colSize).append(")");
        }
        this.dataTypeString = sb.toString();
    }

    public String getColumnName() {
        return this.toString();
    }

    public String getDataTypeString() {
        return this.dataTypeString;
    }

    public DatabaseDataType getDataTypeEnum() {
        return this.dataTypeEnum;
    }

    public boolean isUnique() {
        return this.isColumnUnique;
    }

    public static String getPrimaryKeyString() {
        return "primary key(" + JOB_ID.toString() + ")";
    }

    public static String getColumnDefinitions() {
        StringBuilder sb = new StringBuilder();
        for (ManagedJobTableColumn column : ManagedJobTableColumn.values()) {
            sb.append(column.getColumnName());
            sb.append(" ");
            sb.append(column.getDataTypeString());
            if (column.isUnique()) {
                sb.append(" unique");
            }
            sb.append(", ");
        }
        return sb.toString();
    }
}

