/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.utils.database;

import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.api.JobId;
import com.archivas.clienttools.arcutils.api.JobStatus;
import com.archivas.clienttools.arcutils.api.ManagedJobStats;
import com.archivas.clienttools.arcutils.api.jobs.CopyJob;
import com.archivas.clienttools.arcutils.api.jobs.DeleteJob;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJobSummary;
import com.archivas.clienttools.arcutils.api.jobs.SetMetadataJob;
import com.archivas.clienttools.arcutils.impl.jobs.CopyJobImpl;
import com.archivas.clienttools.arcutils.impl.jobs.DeleteJobImpl;
import com.archivas.clienttools.arcutils.impl.jobs.ManagedJobImpl;
import com.archivas.clienttools.arcutils.impl.jobs.SetMetadataJobImpl;
import com.archivas.clienttools.arcutils.model.ACLMetadata;
import com.archivas.clienttools.arcutils.model.ArcProcessFile;
import com.archivas.clienttools.arcutils.model.CustomMetadata;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.LoadSchedule;
import com.archivas.clienttools.arcutils.model.Owner;
import com.archivas.clienttools.arcutils.model.Retention;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.ProfileManager;
import com.archivas.clienttools.arcutils.utils.UidGidUtil;
import com.archivas.clienttools.arcutils.utils.database.CopyJobSchema;
import com.archivas.clienttools.arcutils.utils.database.CopyJobTableColumn;
import com.archivas.clienttools.arcutils.utils.database.DBUtils;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import com.archivas.clienttools.arcutils.utils.database.DatabaseResourceManager;
import com.archivas.clienttools.arcutils.utils.database.DbConnectionPool;
import com.archivas.clienttools.arcutils.utils.database.DeleteJobSchema;
import com.archivas.clienttools.arcutils.utils.database.DeleteJobTableColumn;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobSchema;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobTableColumn;
import com.archivas.clienttools.arcutils.utils.database.PooledDbConnection;
import com.archivas.clienttools.arcutils.utils.database.SetMetadataJobSchema;
import com.archivas.clienttools.arcutils.utils.database.SetMetadataJobTableColumn;
import java.io.File;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ManagedJobsSchema {
    private static final Logger LOG = Logger.getLogger(ManagedJobsSchema.class.getName());
    public static final String JOBS_TABLE_NAME = "managed_jobs";
    public static final String COPY_JOB_DETAILS_TABLE_NAME = "copy_job_details";
    private static final String DELETE_JOB_DETAILS_TABLE_NAME = "delete_job_details";
    public static final String SET_METADATA_JOB_DETAILS_TABLE_NAME = "metadata_job_details";
    public static final int MAX_PROFILE_NAME_LEN = 100;
    private static final String INSERT_JOB_COLS = " ( " + (Object)((Object)ManagedJobTableColumn.JOB_ID) + ", " + (Object)((Object)ManagedJobTableColumn.JOB_NAME) + ", " + (Object)((Object)ManagedJobTableColumn.JOB_TYPE) + ", " + (Object)((Object)ManagedJobTableColumn.IS_NAME_USER_DEFINED) + ", " + (Object)((Object)ManagedJobTableColumn.JOB_STATUS) + ", " + (Object)((Object)ManagedJobTableColumn.SOURCE_PROFILE_NAME) + ", " + (Object)((Object)ManagedJobTableColumn.SOURCE_PATH) + ", " + (Object)((Object)ManagedJobTableColumn.IMPORT_FILE) + ", " + (Object)((Object)ManagedJobTableColumn.LOW_LOAD_ENABLED) + ", " + (Object)((Object)ManagedJobTableColumn.LOW_LOAD_END_TIME) + ", " + (Object)((Object)ManagedJobTableColumn.LOW_LOAD_MAX_CONN) + ", " + (Object)((Object)ManagedJobTableColumn.LOW_LOAD_MAX_CONN_PER_NODE) + ", " + (Object)((Object)ManagedJobTableColumn.LOW_LOAD_START_TIME) + ", " + (Object)((Object)ManagedJobTableColumn.MAX_CONN_FILE_SYSTEM) + ", " + (Object)((Object)ManagedJobTableColumn.NORM_LOAD_MAX_CONN) + ", " + (Object)((Object)ManagedJobTableColumn.NORM_LOAD_MAX_CONN_PER_NODE) + ", " + (Object)((Object)ManagedJobTableColumn.DISCOVERED_OBJ_CNT) + ", " + (Object)((Object)ManagedJobTableColumn.MAX_RECORD_ID) + ", " + (Object)((Object)ManagedJobTableColumn.MAX_PATH_DEPTH) + ", " + (Object)((Object)ManagedJobTableColumn.IS_FIND_COMPLETE) + " ) values ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,0, 0)";
    private static final String INSERT_COPY_JOB_DETAILS_COLS = " ( " + (Object)((Object)CopyJobTableColumn.JOB_ID) + ", " + (Object)((Object)CopyJobTableColumn.TARGET_PROFILE_NAME) + ", " + (Object)((Object)CopyJobTableColumn.TARGET_PATH) + ", " + (Object)((Object)CopyJobTableColumn.INDEX) + ", " + (Object)((Object)CopyJobTableColumn.SHRED) + ", " + (Object)((Object)CopyJobTableColumn.HOLD) + ", " + (Object)((Object)CopyJobTableColumn.RETENTION) + ", " + (Object)((Object)CopyJobTableColumn.UID) + ", " + (Object)((Object)CopyJobTableColumn.GID) + ", " + (Object)((Object)CopyJobTableColumn.FILE_MODE) + ", " + (Object)((Object)CopyJobTableColumn.DIR_MODE) + ", " + (Object)((Object)CopyJobTableColumn.CUSTOM_METADATA) + ", " + (Object)((Object)CopyJobTableColumn.CUSTOM_METADATA_FORM) + ", " + (Object)((Object)CopyJobTableColumn.OWNER) + ", " + (Object)((Object)CopyJobTableColumn.ACL) + ", " + (Object)((Object)CopyJobTableColumn.ACL_FORM) + ", " + (Object)((Object)CopyJobTableColumn.IGNORE_CONFLICTS) + " ) values ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String INSERT_DELETE_JOB_DETAILS_COLS = " ( " + (Object)((Object)DeleteJobTableColumn.JOB_ID) + ", " + (Object)((Object)DeleteJobTableColumn.OPERATION) + ", " + (Object)((Object)DeleteJobTableColumn.REASON) + " ) values ( ?, ?, ?)";
    private static final String INSERT_SET_METADATA_JOB_DETAILS_COLS = " ( " + (Object)((Object)SetMetadataJobTableColumn.JOB_ID) + ", " + (Object)((Object)SetMetadataJobTableColumn.INDEX) + ", " + (Object)((Object)SetMetadataJobTableColumn.SHRED) + ", " + (Object)((Object)SetMetadataJobTableColumn.HOLD) + ", " + (Object)((Object)SetMetadataJobTableColumn.RETENTION) + ", " + (Object)((Object)SetMetadataJobTableColumn.CUSTOM_METADATA) + ", " + (Object)((Object)SetMetadataJobTableColumn.CUSTOM_METADATA_FORM) + ", " + (Object)((Object)SetMetadataJobTableColumn.OWNER) + ", " + (Object)((Object)SetMetadataJobTableColumn.ACL) + ", " + (Object)((Object)SetMetadataJobTableColumn.ACL_FORM) + " ) values ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String INSERT_JOB_SQL = "INSERT INTO managed_jobs" + INSERT_JOB_COLS;
    private static final String INSERT_COPY_JOB_DETAILS_SQL = "INSERT INTO copy_job_details" + INSERT_COPY_JOB_DETAILS_COLS;
    private static final String INSERT_DELETE_JOB_DETAILS_SQL = "INSERT INTO delete_job_details" + INSERT_DELETE_JOB_DETAILS_COLS;
    private static final String INSERT_SET_METADATA_JOB_DETAILS_SQL = "INSERT INTO metadata_job_details" + INSERT_SET_METADATA_JOB_DETAILS_COLS;
    private static final String UPDATE_JOB_SQL = "UPDATE managed_jobs SET " + (Object)((Object)ManagedJobTableColumn.JOB_NAME) + " = ?, " + (Object)((Object)ManagedJobTableColumn.JOB_TYPE) + " = ?, " + (Object)((Object)ManagedJobTableColumn.IS_NAME_USER_DEFINED) + " = ?, " + (Object)((Object)ManagedJobTableColumn.SOURCE_PROFILE_NAME) + " = ?, " + (Object)((Object)ManagedJobTableColumn.SOURCE_PATH) + " = ?, " + (Object)((Object)ManagedJobTableColumn.IMPORT_FILE) + " = ?, " + (Object)((Object)ManagedJobTableColumn.LOW_LOAD_ENABLED) + " = ?, " + (Object)((Object)ManagedJobTableColumn.LOW_LOAD_END_TIME) + " = ?, " + (Object)((Object)ManagedJobTableColumn.LOW_LOAD_MAX_CONN) + " = ?, " + (Object)((Object)ManagedJobTableColumn.LOW_LOAD_MAX_CONN_PER_NODE) + " = ?, " + (Object)((Object)ManagedJobTableColumn.LOW_LOAD_START_TIME) + " = ?, " + (Object)((Object)ManagedJobTableColumn.MAX_CONN_FILE_SYSTEM) + " = ?, " + (Object)((Object)ManagedJobTableColumn.NORM_LOAD_MAX_CONN) + " = ?, " + (Object)((Object)ManagedJobTableColumn.NORM_LOAD_MAX_CONN_PER_NODE) + " = ?  WHERE " + (Object)((Object)ManagedJobTableColumn.JOB_ID) + " = ?";
    private static final String UPDATE_JOB_NAME_SQL = "UPDATE managed_jobs SET " + (Object)((Object)ManagedJobTableColumn.JOB_NAME) + " = ?, " + (Object)((Object)ManagedJobTableColumn.IS_NAME_USER_DEFINED) + " = 1  WHERE " + (Object)((Object)ManagedJobTableColumn.JOB_ID) + " = ?";
    private static final String GET_JOB_SQL = "SELECT " + (Object)((Object)ManagedJobTableColumn.JOB_NAME) + ", " + (Object)((Object)ManagedJobTableColumn.JOB_TYPE) + ", " + (Object)((Object)ManagedJobTableColumn.IS_NAME_USER_DEFINED) + ", " + (Object)((Object)ManagedJobTableColumn.JOB_STATUS) + ", " + (Object)((Object)ManagedJobTableColumn.SOURCE_PROFILE_NAME) + ", " + (Object)((Object)ManagedJobTableColumn.SOURCE_PATH) + ", " + (Object)((Object)ManagedJobTableColumn.IMPORT_FILE) + ", " + (Object)((Object)ManagedJobTableColumn.LOW_LOAD_ENABLED) + ", " + (Object)((Object)ManagedJobTableColumn.LOW_LOAD_END_TIME) + ", " + (Object)((Object)ManagedJobTableColumn.LOW_LOAD_MAX_CONN) + ", " + (Object)((Object)ManagedJobTableColumn.LOW_LOAD_MAX_CONN_PER_NODE) + ", " + (Object)((Object)ManagedJobTableColumn.LOW_LOAD_START_TIME) + ", " + (Object)((Object)ManagedJobTableColumn.MAX_CONN_FILE_SYSTEM) + ", " + (Object)((Object)ManagedJobTableColumn.NORM_LOAD_MAX_CONN) + ", " + (Object)((Object)ManagedJobTableColumn.NORM_LOAD_MAX_CONN_PER_NODE) + ", " + (Object)((Object)ManagedJobTableColumn.START_TIME) + ", " + (Object)((Object)ManagedJobTableColumn.END_TIME) + ", " + (Object)((Object)ManagedJobTableColumn.RUN_TIME) + ", " + (Object)((Object)ManagedJobTableColumn.MAX_RECORD_ID) + ", " + (Object)((Object)ManagedJobTableColumn.DISCOVERED_OBJ_CNT) + ", " + (Object)((Object)ManagedJobTableColumn.TOTAL_OBJ_CNT) + ", " + (Object)((Object)ManagedJobTableColumn.TOTAL_OBJ_SIZE) + ", " + (Object)((Object)ManagedJobTableColumn.SUCCESS_OBJ_CNT) + ", " + (Object)((Object)ManagedJobTableColumn.SUCCESS_OBJ_SIZE) + ", " + (Object)((Object)ManagedJobTableColumn.FAIL_OBJ_CNT) + ", " + (Object)((Object)ManagedJobTableColumn.FAIL_DIR_CNT) + ", " + (Object)((Object)ManagedJobTableColumn.FAIL_OBJ_SIZE) + ", " + (Object)((Object)ManagedJobTableColumn.IS_FIND_COMPLETE) + " FROM " + "managed_jobs" + " WHERE " + (Object)((Object)ManagedJobTableColumn.JOB_ID) + " = ?";
    private static final String GET_JOB_STATS_SQL = "SELECT " + (Object)((Object)ManagedJobTableColumn.START_TIME) + ", " + (Object)((Object)ManagedJobTableColumn.END_TIME) + ", " + (Object)((Object)ManagedJobTableColumn.RUN_TIME) + ", " + (Object)((Object)ManagedJobTableColumn.DISCOVERED_OBJ_CNT) + ", " + (Object)((Object)ManagedJobTableColumn.TOTAL_OBJ_CNT) + ", " + (Object)((Object)ManagedJobTableColumn.TOTAL_OBJ_SIZE) + ", " + (Object)((Object)ManagedJobTableColumn.SUCCESS_OBJ_CNT) + ", " + (Object)((Object)ManagedJobTableColumn.SUCCESS_OBJ_SIZE) + ", " + (Object)((Object)ManagedJobTableColumn.FAIL_OBJ_CNT) + ", " + (Object)((Object)ManagedJobTableColumn.FAIL_DIR_CNT) + ", " + (Object)((Object)ManagedJobTableColumn.FAIL_OBJ_SIZE) + " FROM " + "managed_jobs" + " WHERE " + (Object)((Object)ManagedJobTableColumn.JOB_ID) + " = ?";
    private static final String UPDATE_LOAD_SCHEDULE_SQL = "UPDATE managed_jobs SET " + (Object)((Object)ManagedJobTableColumn.LOW_LOAD_ENABLED) + " = ?, " + (Object)((Object)ManagedJobTableColumn.LOW_LOAD_END_TIME) + " = ?, " + (Object)((Object)ManagedJobTableColumn.LOW_LOAD_MAX_CONN) + " = ?, " + (Object)((Object)ManagedJobTableColumn.LOW_LOAD_MAX_CONN_PER_NODE) + " = ?, " + (Object)((Object)ManagedJobTableColumn.LOW_LOAD_START_TIME) + " = ?, " + (Object)((Object)ManagedJobTableColumn.MAX_CONN_FILE_SYSTEM) + " = ?, " + (Object)((Object)ManagedJobTableColumn.NORM_LOAD_MAX_CONN) + " = ?, " + (Object)((Object)ManagedJobTableColumn.NORM_LOAD_MAX_CONN_PER_NODE) + " = ?  WHERE " + (Object)((Object)ManagedJobTableColumn.JOB_ID) + " = ?";
    private static final String UPDATE_JOB_STATUS_SQL = "UPDATE managed_jobs SET " + (Object)((Object)ManagedJobTableColumn.JOB_STATUS) + " = ?  WHERE " + (Object)((Object)ManagedJobTableColumn.JOB_ID) + " = ?";
    private static final String UPDATE_RUN_STATS_SQL = "UPDATE managed_jobs SET " + (Object)((Object)ManagedJobTableColumn.START_TIME) + " = ?, " + (Object)((Object)ManagedJobTableColumn.END_TIME) + " = ?, " + (Object)((Object)ManagedJobTableColumn.RUN_TIME) + " = ?  WHERE " + (Object)((Object)ManagedJobTableColumn.JOB_ID) + " = ?";
    private static final String UPDATE_IS_FIND_COMPLETE_SQL = "UPDATE managed_jobs SET " + (Object)((Object)ManagedJobTableColumn.IS_FIND_COMPLETE) + " = ?  WHERE " + (Object)((Object)ManagedJobTableColumn.JOB_ID) + " = ?";
    private static final String GET_PROCESSED_FILES_STATS_STMT_NAME = "getProcessedFilesStats";
    private static final String GET_PROCESSED_FILES_STATS = "SELECT " + (Object)((Object)ManagedJobTableColumn.TOTAL_OBJ_CNT) + ", " + (Object)((Object)ManagedJobTableColumn.TOTAL_OBJ_SIZE) + ", " + (Object)((Object)ManagedJobTableColumn.SUCCESS_OBJ_CNT) + ", " + (Object)((Object)ManagedJobTableColumn.SUCCESS_OBJ_SIZE) + ", " + (Object)((Object)ManagedJobTableColumn.FAIL_OBJ_CNT) + "," + (Object)((Object)ManagedJobTableColumn.FAIL_DIR_CNT) + "," + (Object)((Object)ManagedJobTableColumn.FAIL_OBJ_SIZE) + " FROM " + "managed_jobs" + " WHERE " + (Object)((Object)ManagedJobTableColumn.JOB_ID) + " = ?";
    private static final String UPDATE_PROCESSED_FILES_STATS_STMT_NAME = "updateProcessedFilesStats";
    private static final String UPDATE_PROCESSED_FILES_STATS = "UPDATE managed_jobs SET " + (Object)((Object)ManagedJobTableColumn.TOTAL_OBJ_CNT) + " = ?, " + (Object)((Object)ManagedJobTableColumn.TOTAL_OBJ_SIZE) + " = ?, " + (Object)((Object)ManagedJobTableColumn.SUCCESS_OBJ_CNT) + " = ?, " + (Object)((Object)ManagedJobTableColumn.SUCCESS_OBJ_SIZE) + " = ?, " + (Object)((Object)ManagedJobTableColumn.FAIL_OBJ_CNT) + " = ?, " + (Object)((Object)ManagedJobTableColumn.FAIL_OBJ_SIZE) + " = ?, " + (Object)((Object)ManagedJobTableColumn.FAIL_DIR_CNT) + " = ?  WHERE " + (Object)((Object)ManagedJobTableColumn.JOB_ID) + " = ?";
    private static final String GET_DISCOVERED_OBJ_CNT_STMT_NAME = "getDiscoveredObjCnt";
    private static final String GET_DISCOVERED_OBJ_CNT = "SELECT " + (Object)((Object)ManagedJobTableColumn.DISCOVERED_OBJ_CNT) + ", " + (Object)((Object)ManagedJobTableColumn.MAX_PATH_DEPTH) + ", " + (Object)((Object)ManagedJobTableColumn.MAX_RECORD_ID) + " FROM " + "managed_jobs" + " WHERE " + (Object)((Object)ManagedJobTableColumn.JOB_ID) + " = ?";
    private static final String UPDATE_DISCOVERED_OBJ_CNT_STMT_NAME = "updateDiscoveredObjCnt";
    private static final String UPDATE_DISCOVERED_OJB_CNT = "UPDATE managed_jobs SET " + (Object)((Object)ManagedJobTableColumn.DISCOVERED_OBJ_CNT) + " = ?, " + (Object)((Object)ManagedJobTableColumn.MAX_PATH_DEPTH) + " = ?, " + (Object)((Object)ManagedJobTableColumn.MAX_RECORD_ID) + " = ?  WHERE " + (Object)((Object)ManagedJobTableColumn.JOB_ID) + " = ?";
    private static final String GET_TOTAL_FILES_STATS_STMT_NAME = "getTotalFilesStats";
    private static final String GET_TOTAL_FILES_STATS = "SELECT " + (Object)((Object)ManagedJobTableColumn.TOTAL_OBJ_CNT) + ", " + (Object)((Object)ManagedJobTableColumn.TOTAL_OBJ_SIZE) + " FROM " + "managed_jobs" + " WHERE " + (Object)((Object)ManagedJobTableColumn.JOB_ID) + " = ?";
    private static final String UPDATE_TOTAL_FILES_STATS_STMT_NAME = "updateTotalFilesStats";
    private static final String UPDATE_TOTAL_FILES_STATS = "UPDATE managed_jobs SET " + (Object)((Object)ManagedJobTableColumn.TOTAL_OBJ_CNT) + " = ?, " + (Object)((Object)ManagedJobTableColumn.TOTAL_OBJ_SIZE) + " = ?  WHERE " + (Object)((Object)ManagedJobTableColumn.JOB_ID) + " = ?";
    private static final String GET_TOTAL_AND_FAILED_STATS_STMT_NAME = "getTotalAndFailedStats";
    private static final String GET_TOTAL_AND_FAILED_STATS = "SELECT " + (Object)((Object)ManagedJobTableColumn.TOTAL_OBJ_CNT) + ", " + (Object)((Object)ManagedJobTableColumn.FAIL_OBJ_CNT) + ", " + (Object)((Object)ManagedJobTableColumn.FAIL_DIR_CNT) + " FROM " + "managed_jobs" + " WHERE " + (Object)((Object)ManagedJobTableColumn.JOB_ID) + " = ?";
    private static final String UPDATE_TOTAL_AND_FAILED_STMT_NAME = "updateTotalAndFailedStats";
    private static final String UPDATE_TOTAL_AND_FAILED_STATS = "UPDATE managed_jobs SET " + (Object)((Object)ManagedJobTableColumn.TOTAL_OBJ_CNT) + " = ?, " + (Object)((Object)ManagedJobTableColumn.FAIL_OBJ_CNT) + " = ?, " + (Object)((Object)ManagedJobTableColumn.FAIL_DIR_CNT) + " = ?  WHERE " + (Object)((Object)ManagedJobTableColumn.JOB_ID) + " = ?";
    private static final String RESET_JOB_STATS_SQL = "UPDATE managed_jobs SET " + (Object)((Object)ManagedJobTableColumn.FAIL_OBJ_CNT) + " = 0, " + (Object)((Object)ManagedJobTableColumn.FAIL_DIR_CNT) + " = 0, " + (Object)((Object)ManagedJobTableColumn.FAIL_OBJ_SIZE) + " = 0  WHERE " + (Object)((Object)ManagedJobTableColumn.JOB_ID) + " = ?";
    private static final String GET_COPY_JOB_DETAILS_SQL = "SELECT " + (Object)((Object)CopyJobTableColumn.TARGET_PROFILE_NAME) + ", " + (Object)((Object)CopyJobTableColumn.TARGET_PATH) + ", " + (Object)((Object)CopyJobTableColumn.INDEX) + ", " + (Object)((Object)CopyJobTableColumn.SHRED) + ", " + (Object)((Object)CopyJobTableColumn.HOLD) + ", " + (Object)((Object)CopyJobTableColumn.RETENTION) + ", " + (Object)((Object)CopyJobTableColumn.UID) + ", " + (Object)((Object)CopyJobTableColumn.GID) + ", " + (Object)((Object)CopyJobTableColumn.FILE_MODE) + ", " + (Object)((Object)CopyJobTableColumn.DIR_MODE) + ", " + (Object)((Object)CopyJobTableColumn.CUSTOM_METADATA) + ", " + (Object)((Object)CopyJobTableColumn.CUSTOM_METADATA_FORM) + ", " + (Object)((Object)CopyJobTableColumn.OWNER) + ", " + (Object)((Object)CopyJobTableColumn.ACL) + ", " + (Object)((Object)CopyJobTableColumn.ACL_FORM) + ", " + (Object)((Object)CopyJobTableColumn.IGNORE_CONFLICTS) + " FROM " + "copy_job_details" + " WHERE " + (Object)((Object)CopyJobTableColumn.JOB_ID) + " = ?";
    private static final String UPDATE_COPY_JOB_DETAILS_SQL = "UPDATE copy_job_details SET " + (Object)((Object)CopyJobTableColumn.TARGET_PROFILE_NAME) + " = ?, " + (Object)((Object)CopyJobTableColumn.TARGET_PATH) + " = ?, " + (Object)((Object)CopyJobTableColumn.INDEX) + " = ?, " + (Object)((Object)CopyJobTableColumn.SHRED) + " = ?, " + (Object)((Object)CopyJobTableColumn.HOLD) + " = ?, " + (Object)((Object)CopyJobTableColumn.RETENTION) + " = ?, " + (Object)((Object)CopyJobTableColumn.UID) + " = ?, " + (Object)((Object)CopyJobTableColumn.GID) + " = ?, " + (Object)((Object)CopyJobTableColumn.FILE_MODE) + " = ?, " + (Object)((Object)CopyJobTableColumn.DIR_MODE) + " = ?, " + (Object)((Object)CopyJobTableColumn.CUSTOM_METADATA) + " = ?, " + (Object)((Object)CopyJobTableColumn.CUSTOM_METADATA_FORM) + " = ?, " + (Object)((Object)CopyJobTableColumn.OWNER) + " = ?, " + (Object)((Object)CopyJobTableColumn.ACL) + " = ?, " + (Object)((Object)CopyJobTableColumn.ACL_FORM) + " = ?, " + (Object)((Object)CopyJobTableColumn.IGNORE_CONFLICTS) + " = ?  WHERE " + (Object)((Object)CopyJobTableColumn.JOB_ID) + " = ?";
    private static final String GET_DELETE_JOB_DETAILS_SQL = "SELECT " + (Object)((Object)DeleteJobTableColumn.OPERATION) + ", " + (Object)((Object)DeleteJobTableColumn.REASON) + " FROM " + "delete_job_details" + " WHERE " + (Object)((Object)DeleteJobTableColumn.JOB_ID) + " = ?";
    private static final String UPDATE_DELETE_JOB_DETAILS_SQL = "UPDATE delete_job_details SET " + (Object)((Object)DeleteJobTableColumn.OPERATION) + " = ?, " + (Object)((Object)DeleteJobTableColumn.REASON) + " = ?  WHERE " + (Object)((Object)DeleteJobTableColumn.JOB_ID) + " = ?";
    private static final String GET_SET_METADATA_JOB_DETAILS_SQL = "SELECT " + (Object)((Object)SetMetadataJobTableColumn.INDEX) + ", " + (Object)((Object)SetMetadataJobTableColumn.SHRED) + ", " + (Object)((Object)SetMetadataJobTableColumn.HOLD) + ", " + (Object)((Object)SetMetadataJobTableColumn.RETENTION) + ", " + (Object)((Object)SetMetadataJobTableColumn.CUSTOM_METADATA) + ", " + (Object)((Object)SetMetadataJobTableColumn.CUSTOM_METADATA_FORM) + ", " + (Object)((Object)SetMetadataJobTableColumn.OWNER) + ", " + (Object)((Object)SetMetadataJobTableColumn.ACL) + ", " + (Object)((Object)SetMetadataJobTableColumn.ACL_FORM) + " FROM " + "metadata_job_details" + " WHERE " + (Object)((Object)SetMetadataJobTableColumn.JOB_ID) + " = ?";
    private static final String UPDATE_SET_METADATA_JOB_DETAILS_SQL = "UPDATE metadata_job_details SET " + (Object)((Object)SetMetadataJobTableColumn.INDEX) + " = ?, " + (Object)((Object)SetMetadataJobTableColumn.SHRED) + " = ?, " + (Object)((Object)SetMetadataJobTableColumn.HOLD) + " = ?, " + (Object)((Object)SetMetadataJobTableColumn.RETENTION) + " = ?, " + (Object)((Object)SetMetadataJobTableColumn.CUSTOM_METADATA) + " = ?, " + (Object)((Object)SetMetadataJobTableColumn.CUSTOM_METADATA_FORM) + " = ?, " + (Object)((Object)SetMetadataJobTableColumn.OWNER) + " = ?, " + (Object)((Object)SetMetadataJobTableColumn.ACL) + " = ?, " + (Object)((Object)SetMetadataJobTableColumn.ACL_FORM) + " = ?  WHERE " + (Object)((Object)SetMetadataJobTableColumn.JOB_ID) + " = ?";
    private static final String DELETE_FROM_JOBS_SQL = "DELETE FROM managed_jobs WHERE " + (Object)((Object)ManagedJobTableColumn.JOB_ID) + " = ?";
    private static final String DELETE_FROM_COPY_JOB_DETAILS_SQL = "DELETE FROM copy_job_details WHERE " + (Object)((Object)CopyJobTableColumn.JOB_ID) + " = ?";
    private static final String DELETE_FROM_DELETE_JOB_DETAILS_SQL = "DELETE FROM delete_job_details WHERE " + (Object)((Object)DeleteJobTableColumn.JOB_ID) + " = ?";
    private static final String DELETE_FROM_METADATA_JOB_DETAILS_SQL = "DELETE FROM metadata_job_details WHERE " + (Object)((Object)SetMetadataJobTableColumn.JOB_ID) + " = ?";
    private static final String GET_ALL_JOBS_SQL = "SELECT " + (Object)((Object)ManagedJobTableColumn.JOB_ID) + ", " + (Object)((Object)ManagedJobTableColumn.JOB_NAME) + ", " + (Object)((Object)ManagedJobTableColumn.JOB_TYPE) + ", " + (Object)((Object)ManagedJobTableColumn.JOB_STATUS) + " FROM " + "managed_jobs";
    private static final String GET_ALL_JOBS_AND_PROFILES_SQL = "SELECT " + (Object)((Object)ManagedJobTableColumn.JOB_NAME) + ", " + (Object)((Object)ManagedJobTableColumn.SOURCE_PROFILE_NAME) + ", " + (Object)((Object)CopyJobTableColumn.TARGET_PROFILE_NAME) + " FROM " + "managed_jobs" + " LEFT OUTER JOIN " + "copy_job_details" + " ON " + "managed_jobs" + "." + (Object)((Object)ManagedJobTableColumn.JOB_ID) + " = " + "copy_job_details" + "." + (Object)((Object)CopyJobTableColumn.JOB_ID);
    private static final String CHANGE_SOURCE_PROFILE_NAME_SQL = "UPDATE managed_jobs SET " + (Object)((Object)ManagedJobTableColumn.SOURCE_PROFILE_NAME) + " = ?  WHERE " + (Object)((Object)ManagedJobTableColumn.SOURCE_PROFILE_NAME) + " = ?";
    private static final String CHANGE_TARGET_PROFILE_NAME_SQL = "UPDATE copy_job_details SET " + (Object)((Object)CopyJobTableColumn.TARGET_PROFILE_NAME) + " = ?  WHERE " + (Object)((Object)CopyJobTableColumn.TARGET_PROFILE_NAME) + " = ?";
    private int nextDbRecordId = -1;
    private static ManagedJobsSchema instance;
    private DbConnectionPool connPool = new DbConnectionPool("ManagedJobsSchema");

    public static synchronized ManagedJobsSchema getInstance() {
        if (instance == null) {
            instance = new ManagedJobsSchema();
        }
        return instance;
    }

    private ManagedJobsSchema() {
    }

    private long getNextDbRecordId() throws SQLException {
        if (this.nextDbRecordId < 0) {
            PooledDbConnection conn = null;
            try {
                conn = this.connPool.getConnection();
                Statement stmt = conn.createStatement();
                String sqlQuery = "select max(" + ManagedJobTableColumn.JOB_ID.toString() + ") from " + JOBS_TABLE_NAME;
                ResultSet rs = DBUtils.executeQuery(stmt, sqlQuery);
                this.nextDbRecordId = rs.next() ? rs.getInt(1) + 1 : 1;
            }
            catch (Exception e) {
                this.rollback(conn);
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw new SQLException(DBUtils.getErrorMessage("An error occurred determining next record id for job files table", e), e);
            }
            finally {
                this.connPool.returnConnection(conn);
            }
        }
        return this.nextDbRecordId++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createSchema(Connection conn) throws SQLException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            boolean oldAutoCommit = false;
            try {
                oldAutoCommit = conn.getAutoCommit();
                if (oldAutoCommit) {
                    conn.setAutoCommit(false);
                }
                Statement stmt = conn.createStatement();
                this.createJobsTable(stmt);
                this.createCopyJobDetailsTable(stmt);
                this.createDeleteJobDetailsTable(stmt);
                ManagedJobsSchema.createMetadataJobDetailsTable(stmt);
                conn.commit();
            }
            catch (Exception e) {
                this.rollback(conn);
                throw new SQLException(DBUtils.getErrorMessage("An error occurred creating the jobs tables", e), e);
            }
            finally {
                if (oldAutoCommit) {
                    conn.setAutoCommit(oldAutoCommit);
                }
            }
        }
    }

    private void createJobsTable(Statement stmt) throws SQLException {
        String sql = "CREATE TABLE managed_jobs (" + ManagedJobTableColumn.getColumnDefinitions() + ManagedJobTableColumn.getPrimaryKeyString() + ")";
        DBUtils.executeUpdate(stmt, sql);
    }

    private void createCopyJobDetailsTable(Statement stmt) throws SQLException {
        String sql = "CREATE TABLE copy_job_details (" + CopyJobTableColumn.getColumnDefinitions() + CopyJobTableColumn.getPrimaryKeyString() + ")";
        DBUtils.executeUpdate(stmt, sql);
    }

    private void createDeleteJobDetailsTable(Statement stmt) throws SQLException {
        String sql = "CREATE TABLE delete_job_details (" + DeleteJobTableColumn.getColumnDefinitions() + DeleteJobTableColumn.getPrimaryKeyString() + ")";
        DBUtils.executeUpdate(stmt, sql);
    }

    protected static void createMetadataJobDetailsTable(Statement stmt) throws SQLException {
        String sql = "CREATE TABLE metadata_job_details (" + SetMetadataJobTableColumn.getColumnDefinitions() + SetMetadataJobTableColumn.getPrimaryKeyString() + ")";
        DBUtils.executeUpdate(stmt, sql);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ManagedJobSummary> getAllJobs() throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            PooledDbConnection conn = null;
            try {
                conn = this.connPool.getConnection();
                List<ManagedJobSummary> list = this.getAllJobs(conn);
                return list;
            }
            catch (Exception e) {
                throw new DatabaseException(DBUtils.getErrorMessage("An error occurred selecting all jobs", e), e);
            }
            finally {
                this.connPool.returnConnection(conn);
            }
        }
    }

    public List<ManagedJobSummary> getAllJobs(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        ResultSet rs = DBUtils.executeQuery(stmt, GET_ALL_JOBS_SQL);
        ArrayList<ManagedJobSummary> ret = new ArrayList<ManagedJobSummary>();
        while (rs.next()) {
            long jobId = rs.getLong(ManagedJobTableColumn.JOB_ID.toString());
            String jobName = rs.getString(ManagedJobTableColumn.JOB_NAME.toString());
            int jobTypeOrdinalValue = rs.getInt(ManagedJobTableColumn.JOB_TYPE.toString());
            ManagedJob.Type jobType = ManagedJob.Type.values()[jobTypeOrdinalValue];
            int jobStatusOrdinalValue = rs.getInt(ManagedJobTableColumn.JOB_STATUS.toString());
            JobStatus jobStatus = JobStatus.values()[jobStatusOrdinalValue];
            jobStatus = this.getAdjustedJobStatus(jobStatus);
            ManagedJobSummary summary = new ManagedJobSummary(new JobId(jobId), jobName, jobStatus, jobType);
            ret.add(summary);
        }
        return ret;
    }

    public ManagedJobImpl getManagedJob(JobId jobId, ManagedJob.Type type) throws DatabaseException, JobException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            ManagedJobImpl managedJobImpl;
            PooledDbConnection conn = null;
            try {
                ManagedJobImpl jobImpl;
                ManagedJob managedJob;
                ManagedJobSchema jobSchema;
                switch (type) {
                    case COPY: {
                        jobSchema = new CopyJobSchema(jobId.getId());
                        managedJob = new CopyJob();
                        jobImpl = new CopyJobImpl(jobId, (CopyJob)managedJob, jobSchema);
                        break;
                    }
                    case DELETE: {
                        jobSchema = new DeleteJobSchema(jobId.getId());
                        managedJob = new DeleteJob();
                        jobImpl = new DeleteJobImpl(jobId, (DeleteJob)managedJob, jobSchema);
                        break;
                    }
                    case SET_METADATA: {
                        jobSchema = new SetMetadataJobSchema(jobId.getId());
                        managedJob = new SetMetadataJob();
                        jobImpl = new SetMetadataJobImpl(jobId, (SetMetadataJob)managedJob, jobSchema);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported job type: " + (Object)((Object)type));
                    }
                }
                conn = this.connPool.getConnection();
                long lastDbRecordId = this.getManagedJob(jobImpl, conn, jobId.getId());
                jobSchema.setSourceProfile(managedJob.getSourceProfile());
                switch (managedJob.getJobType()) {
                    case COPY: {
                        this.getCopyJobDetails((CopyJob)managedJob, conn, jobId.getId());
                        ((CopyJobSchema)jobSchema).setTargetProfile(managedJob.getTargetProfile());
                        break;
                    }
                    case DELETE: {
                        this.getDeleteJobDetails((DeleteJob)managedJob, conn, jobId.getId());
                        break;
                    }
                    case SET_METADATA: {
                        this.getSetMetadataJobDetails((SetMetadataJob)managedJob, conn, jobId.getId());
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported job type: " + (Object)((Object)managedJob.getJobType()));
                    }
                }
                jobSchema.load(lastDbRecordId);
                managedJob.setInitialDiscoveryList(jobSchema.getInitialDiscoveryList());
                managedJobImpl = jobImpl;
                this.connPool.returnConnection(conn);
            }
            catch (Exception e) {
                try {
                    this.rollback(conn);
                    throw new DatabaseException(DBUtils.getErrorMessage("An error occurred reading an existing job from the database", e), e);
                }
                catch (Throwable throwable) {
                    this.connPool.returnConnection(conn);
                    throw throwable;
                }
            }
            return managedJobImpl;
        }
    }

    private JobStatus getAdjustedJobStatus(JobStatus status) {
        if (JobStatus.RUNNING == status) {
            status = JobStatus.PAUSED;
        } else if (JobStatus.PREPARING_FOR_RESTART == status) {
            status = JobStatus.FAILED;
        }
        return status;
    }

    private long getManagedJob(ManagedJobImpl jobImpl, Connection conn, long jobId) throws SQLException, JobException {
        Long failDirCnt;
        Long failObjSize;
        Long failObjCnt;
        Long successObjSize;
        Long successObjCnt;
        Long totalObjSize;
        Long totalObjCnt;
        Long discoveredObjCnt;
        Long runTime;
        Long endTime;
        ManagedJob managedJob = jobImpl.getJob();
        PreparedStatement stmt = conn.prepareStatement(GET_JOB_SQL);
        stmt.setLong(1, jobId);
        ResultSet rs = stmt.executeQuery();
        rs.next();
        String jobName = rs.getString(ManagedJobTableColumn.JOB_NAME.toString());
        boolean isNameUserDefined = this.readBoolean(rs, ManagedJobTableColumn.IS_NAME_USER_DEFINED.toString());
        if (isNameUserDefined) {
            managedJob.setUserDefinedJobName(jobName);
        } else {
            managedJob.setInternalJobName(jobName);
        }
        int jobStatusOrdinal = rs.getInt(ManagedJobTableColumn.JOB_STATUS.toString());
        JobStatus status = JobStatus.values()[jobStatusOrdinal];
        status = this.getAdjustedJobStatus(status);
        jobImpl.setStatus(status, false);
        String srcProfileName = rs.getString(ManagedJobTableColumn.SOURCE_PROFILE_NAME.toString());
        AbstractProfileBase srcProfile = ProfileManager.getProfileByName(srcProfileName);
        if (srcProfile == null) {
            throw new JobException("The job's source profile \"" + srcProfileName + "\" not found.");
        }
        managedJob.setSourceProfile(srcProfile);
        String srcPath = rs.getString(ManagedJobTableColumn.SOURCE_PATH.toString());
        managedJob.setSourcePath(srcPath);
        String importFile = rs.getString(ManagedJobTableColumn.IMPORT_FILE.toString());
        if (importFile != null) {
            managedJob.setListFile(new File(importFile));
        }
        LoadSchedule loadSched = new LoadSchedule();
        boolean isLowLoadEnabled = this.readBoolean(rs, ManagedJobTableColumn.LOW_LOAD_ENABLED.toString());
        loadSched.setLowLoadEnabled(isLowLoadEnabled);
        Date lowLoadEndTime = new Date(rs.getLong(ManagedJobTableColumn.LOW_LOAD_END_TIME.toString()));
        loadSched.setLowLoadEndTime(lowLoadEndTime);
        int lowLoadMaxConn = rs.getInt(ManagedJobTableColumn.LOW_LOAD_MAX_CONN.toString());
        loadSched.setLowLoadMaxConnCount(lowLoadMaxConn);
        int lowLoadMaxConnPerMode = rs.getInt(ManagedJobTableColumn.LOW_LOAD_MAX_CONN_PER_NODE.toString());
        loadSched.setLowLoadMaxConnPerNodeCount(lowLoadMaxConnPerMode);
        Date lowLoadStartTime = new Date(rs.getLong(ManagedJobTableColumn.LOW_LOAD_START_TIME.toString()));
        loadSched.setLowLoadStartTime(lowLoadStartTime);
        int maxConnFileSystem = rs.getInt(ManagedJobTableColumn.MAX_CONN_FILE_SYSTEM.toString());
        loadSched.setMaxConnFilesystem(maxConnFileSystem);
        int normalLoadMaxConn = rs.getInt(ManagedJobTableColumn.NORM_LOAD_MAX_CONN.toString());
        loadSched.setNormalLoadMaxConnCount(normalLoadMaxConn);
        int normalLoadMaxConnPerNode = rs.getInt(ManagedJobTableColumn.NORM_LOAD_MAX_CONN_PER_NODE.toString());
        loadSched.setNormalLoadMaxConnPerNodeCount(normalLoadMaxConnPerNode);
        managedJob.setLoadSchedule(loadSched);
        Long startTime = (Long)rs.getObject(ManagedJobTableColumn.START_TIME.toString());
        if (startTime != null) {
            jobImpl.setStartTime(new Date(startTime));
        }
        if ((endTime = (Long)rs.getObject(ManagedJobTableColumn.END_TIME.toString())) != null) {
            jobImpl.setEndTime(new Date(endTime));
        }
        if ((runTime = (Long)rs.getObject(ManagedJobTableColumn.RUN_TIME.toString())) != null) {
            jobImpl.setPreviousRunTime(runTime);
        }
        if ((discoveredObjCnt = (Long)rs.getObject(ManagedJobTableColumn.DISCOVERED_OBJ_CNT.toString())) != null) {
            jobImpl.setDiscoveredObjectCount(discoveredObjCnt);
        }
        if ((totalObjCnt = (Long)rs.getObject(ManagedJobTableColumn.TOTAL_OBJ_CNT.toString())) != null) {
            jobImpl.setTotalObjectCount(totalObjCnt);
        }
        if ((totalObjSize = (Long)rs.getObject(ManagedJobTableColumn.TOTAL_OBJ_SIZE.toString())) != null) {
            jobImpl.setTotalBytes(totalObjSize);
        }
        if ((successObjCnt = (Long)rs.getObject(ManagedJobTableColumn.SUCCESS_OBJ_CNT.toString())) != null) {
            jobImpl.setCompletedObjectCount(successObjCnt);
        }
        if ((successObjSize = (Long)rs.getObject(ManagedJobTableColumn.SUCCESS_OBJ_SIZE.toString())) != null) {
            jobImpl.setCompletedBytes(successObjSize);
        }
        if ((failObjCnt = (Long)rs.getObject(ManagedJobTableColumn.FAIL_OBJ_CNT.toString())) != null) {
            jobImpl.setFailedObjectCount(failObjCnt);
        }
        if ((failObjSize = (Long)rs.getObject(ManagedJobTableColumn.FAIL_OBJ_SIZE.toString())) != null) {
            jobImpl.setFailedBytes(failObjSize);
        }
        if ((failDirCnt = (Long)rs.getObject(ManagedJobTableColumn.FAIL_DIR_CNT.toString())) != null) {
            jobImpl.setFailedDirCount(failDirCnt);
        }
        int isFindComplete = rs.getInt(ManagedJobTableColumn.IS_FIND_COMPLETE.toString());
        try {
            jobImpl.setFindFilesComplete(isFindComplete == 1, false);
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
        Long maxRecordId = (Long)rs.getObject(ManagedJobTableColumn.MAX_RECORD_ID.toString());
        if (maxRecordId == null) {
            maxRecordId = 0L;
        }
        return maxRecordId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ManagedJobStats loadManagedJobStats(long jobId) throws DatabaseException, JobException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            PooledDbConnection conn = null;
            try {
                conn = this.connPool.getConnection();
                ManagedJobStats managedJobStats = this.loadManagedJobStats(jobId, conn);
                return managedJobStats;
            }
            catch (Exception e) {
                this.rollback(conn);
                throw new DatabaseException(DBUtils.getErrorMessage("An error occurred reading job statistics from the database", e), e);
            }
            finally {
                this.connPool.returnConnection(conn);
            }
        }
    }

    private ManagedJobStats loadManagedJobStats(long jobId, Connection conn) throws SQLException, JobException {
        PreparedStatement stmt = conn.prepareStatement(GET_JOB_STATS_SQL);
        stmt.setLong(1, jobId);
        ResultSet rs = stmt.executeQuery();
        rs.next();
        Long startTimeL = (Long)rs.getObject(ManagedJobTableColumn.START_TIME.toString());
        Date startTime = startTimeL != null ? new Date(startTimeL) : null;
        Long endTimeL = (Long)rs.getObject(ManagedJobTableColumn.END_TIME.toString());
        Date endTime = endTimeL != null ? new Date(endTimeL) : null;
        Long runTimeL = (Long)rs.getObject(ManagedJobTableColumn.RUN_TIME.toString());
        long runTimeMs = runTimeL != null ? runTimeL : -1L;
        Long discoveredObjCntL = (Long)rs.getObject(ManagedJobTableColumn.DISCOVERED_OBJ_CNT.toString());
        long discoveredObjCnt = discoveredObjCntL != null ? discoveredObjCntL : -1L;
        Long totalObjCntL = (Long)rs.getObject(ManagedJobTableColumn.TOTAL_OBJ_CNT.toString());
        long totalObjCnt = totalObjCntL != null ? totalObjCntL : -1L;
        Long totalObjSizeL = (Long)rs.getObject(ManagedJobTableColumn.TOTAL_OBJ_SIZE.toString());
        long totalObjSize = totalObjSizeL != null ? totalObjSizeL : -1L;
        Long successObjCntL = (Long)rs.getObject(ManagedJobTableColumn.SUCCESS_OBJ_CNT.toString());
        long successObjCnt = successObjCntL != null ? successObjCntL : -1L;
        Long successObjSizeL = (Long)rs.getObject(ManagedJobTableColumn.SUCCESS_OBJ_SIZE.toString());
        long successObjSize = successObjSizeL != null ? successObjSizeL : -1L;
        Long failObjCntL = (Long)rs.getObject(ManagedJobTableColumn.FAIL_OBJ_CNT.toString());
        long failObjCnt = failObjCntL != null ? failObjCntL : -1L;
        Long failObjSizeL = (Long)rs.getObject(ManagedJobTableColumn.FAIL_OBJ_SIZE.toString());
        long failObjSize = failObjSizeL != null ? failObjSizeL : -1L;
        Long failDirCntL = (Long)rs.getObject(ManagedJobTableColumn.FAIL_DIR_CNT.toString());
        long failDirCnt = failDirCntL != null ? failDirCntL : -1L;
        return new ManagedJobStats(startTime, endTime, runTimeMs, discoveredObjCnt, totalObjCnt, successObjCnt, failObjCnt, failDirCnt, totalObjSize, successObjSize, failObjSize);
    }

    private Boolean readBoolean(ResultSet rs, String colName) throws SQLException {
        Integer val = (Integer)rs.getObject(colName);
        if (val == null) {
            return null;
        }
        return val == 1;
    }

    private Integer readInteger(ResultSet rs, String colName) throws SQLException {
        return (Integer)rs.getObject(colName);
    }

    private void getCopyJobDetails(CopyJob copyJob, Connection conn, long jobId) throws SQLException {
        Boolean ignoreConflicts;
        PreparedStatement stmt = conn.prepareStatement(GET_COPY_JOB_DETAILS_SQL);
        stmt.setLong(1, jobId);
        ResultSet rs = stmt.executeQuery();
        rs.next();
        String targetProfileName = rs.getString(CopyJobTableColumn.TARGET_PROFILE_NAME.toString());
        AbstractProfileBase targetProfile = ProfileManager.getProfileByName(targetProfileName);
        if (targetProfile == null) {
            throw new SQLException("The job's target profile \"" + targetProfileName + "\" not found.");
        }
        copyJob.setTargetProfile(targetProfile);
        copyJob.setTargetPath(rs.getString(CopyJobTableColumn.TARGET_PATH.toString()));
        FileMetadata md = new FileMetadata();
        md.setSearchIndex(this.readBoolean(rs, CopyJobTableColumn.INDEX.toString()));
        md.setShred(this.readBoolean(rs, CopyJobTableColumn.SHRED.toString()));
        md.setRetentionHold(this.readBoolean(rs, CopyJobTableColumn.HOLD.toString()));
        md.setRetention(Retention.fromHcapValue(rs.getString(CopyJobTableColumn.RETENTION.toString())));
        md.setUid(UidGidUtil.convertIntToLong(this.readInteger(rs, CopyJobTableColumn.UID.toString())));
        md.setGid(UidGidUtil.convertIntToLong(this.readInteger(rs, CopyJobTableColumn.GID.toString())));
        md.setFileMode(this.readInteger(rs, CopyJobTableColumn.FILE_MODE.toString()));
        md.setDirMode(this.readInteger(rs, CopyJobTableColumn.DIR_MODE.toString()));
        copyJob.setIngestionMetadata(md);
        String customMdValue = rs.getString(CopyJobTableColumn.CUSTOM_METADATA.toString());
        String customMdForm = rs.getString(CopyJobTableColumn.CUSTOM_METADATA_FORM.toString());
        if (customMdForm != null) {
            copyJob.setCustomMetadata(new CustomMetadata(customMdForm, customMdValue));
        }
        String ownerStr = rs.getString(CopyJobTableColumn.OWNER.toString());
        md.setOwner(Owner.createFromStringRepresentation(ownerStr));
        String aclMdValue = rs.getString(CopyJobTableColumn.ACL.toString());
        String aclMdForm = rs.getString(CopyJobTableColumn.ACL_FORM.toString());
        if (aclMdForm != null) {
            md.setACL(new ACLMetadata(aclMdForm, aclMdValue));
        }
        copyJob.setIgnoreConflicts((ignoreConflicts = this.readBoolean(rs, CopyJobTableColumn.IGNORE_CONFLICTS.toString())) == null ? false : ignoreConflicts);
    }

    private void getDeleteJobDetails(DeleteJob deleteJob, Connection conn, long jobId) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(GET_DELETE_JOB_DETAILS_SQL);
        stmt.setLong(1, jobId);
        ResultSet rs = stmt.executeQuery();
        rs.next();
        int operationOrdinal = rs.getInt(DeleteJobTableColumn.OPERATION.toString());
        deleteJob.setOperation(DeleteJob.Operation.values()[operationOrdinal]);
        deleteJob.setReason(rs.getString(DeleteJobTableColumn.REASON.toString()));
    }

    private void getSetMetadataJobDetails(SetMetadataJob metadataJob, Connection conn, long jobId) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(GET_SET_METADATA_JOB_DETAILS_SQL);
        stmt.setLong(1, jobId);
        ResultSet rs = stmt.executeQuery();
        rs.next();
        FileMetadata md = new FileMetadata();
        md.setSearchIndex(this.readBoolean(rs, SetMetadataJobTableColumn.INDEX.toString()));
        md.setShred(this.readBoolean(rs, SetMetadataJobTableColumn.SHRED.toString()));
        md.setRetentionHold(this.readBoolean(rs, SetMetadataJobTableColumn.HOLD.toString()));
        md.setRetention(Retention.fromHcapValue(rs.getString(SetMetadataJobTableColumn.RETENTION.toString())));
        metadataJob.setIngestionMetadata(md);
        String customMdValue = rs.getString(SetMetadataJobTableColumn.CUSTOM_METADATA.toString());
        String customMdForm = rs.getString(SetMetadataJobTableColumn.CUSTOM_METADATA_FORM.toString());
        if (customMdForm != null) {
            metadataJob.setCustomMetadata(new CustomMetadata(customMdForm, customMdValue));
        }
        String ownerStr = rs.getString(SetMetadataJobTableColumn.OWNER.toString());
        md.setOwner(Owner.createFromStringRepresentation(ownerStr));
        String aclMdValue = rs.getString(SetMetadataJobTableColumn.ACL.toString());
        String aclMdForm = rs.getString(SetMetadataJobTableColumn.ACL_FORM.toString());
        if (aclMdForm != null) {
            md.setACL(new ACLMetadata(aclMdForm, aclMdValue));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ManagedJobImpl insertJob(ManagedJob managedJob) throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            PooledDbConnection conn = null;
            try {
                ManagedJobImpl managedJobImpl;
                ManagedJobSchema jobSchema;
                conn = this.connPool.getConnection();
                conn.setAutoCommit(false);
                long jobId = this.getNextDbRecordId();
                switch (managedJob.getJobType()) {
                    case COPY: {
                        jobSchema = new CopyJobSchema(jobId);
                        jobSchema.setSourceProfile(managedJob.getSourceProfile());
                        ((CopyJobSchema)jobSchema).setTargetProfile(managedJob.getTargetProfile());
                        break;
                    }
                    case DELETE: {
                        jobSchema = new DeleteJobSchema(jobId);
                        jobSchema.setSourceProfile(managedJob.getSourceProfile());
                        break;
                    }
                    case SET_METADATA: {
                        jobSchema = new SetMetadataJobSchema(jobId);
                        jobSchema.setSourceProfile(managedJob.getSourceProfile());
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported job type: " + (Object)((Object)managedJob.getJobType()));
                    }
                }
                List<ArcProcessFile> initialDiscoveryList = managedJob.getInitialDiscoveryList();
                long maxRecordId = jobSchema.create(conn, initialDiscoveryList);
                JobStatus status = JobStatus.NOT_STARTED;
                this.insertJob(managedJob, status, conn, jobId, initialDiscoveryList == null ? 0 : initialDiscoveryList.size(), maxRecordId);
                switch (managedJob.getJobType()) {
                    case COPY: {
                        this.insertCopyJobDetails((CopyJob)managedJob, conn, jobId);
                        managedJobImpl = new CopyJobImpl(new JobId(jobId), (CopyJob)managedJob, jobSchema);
                        break;
                    }
                    case DELETE: {
                        this.insertDeleteJobDetails((DeleteJob)managedJob, conn, jobId);
                        managedJobImpl = new DeleteJobImpl(new JobId(jobId), (DeleteJob)managedJob, jobSchema);
                        break;
                    }
                    case SET_METADATA: {
                        this.insertSetMetadataJobDetails((SetMetadataJob)managedJob, conn, jobId);
                        managedJobImpl = new SetMetadataJobImpl(new JobId(jobId), (SetMetadataJob)managedJob, jobSchema);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported job type: " + (Object)((Object)managedJob.getJobType()));
                    }
                }
                managedJobImpl.setStatus(status, false);
                managedJobImpl.setDiscoveredObjectCount(initialDiscoveryList.size());
                conn.commit();
                ManagedJobImpl managedJobImpl2 = managedJobImpl;
                return managedJobImpl2;
            }
            catch (Exception e) {
                String sqlState;
                this.rollback(conn);
                if (e instanceof SQLException && (sqlState = ((SQLException)e).getSQLState()) != null && sqlState.equals("23505")) {
                    throw new DatabaseException("Another job of the same name already exists.", e);
                }
                throw new DatabaseException(DBUtils.getErrorMessage("An error occurred inserting a new job into the database", e), e);
            }
            finally {
                this.connPool.returnConnection(conn);
            }
        }
    }

    private void insertJob(ManagedJob managedJob, JobStatus status, Connection conn, long jobId, int discoveredObjCnt, long maxRecordId) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(INSERT_JOB_SQL);
        stmt.setLong(1, jobId);
        stmt.setString(2, managedJob.getJobName());
        stmt.setInt(3, managedJob.getJobType().ordinal());
        boolean isNameUserDefined = managedJob.getUserDefinedJobName() != null;
        stmt.setInt(4, isNameUserDefined ? 1 : 0);
        stmt.setInt(5, status.ordinal());
        stmt.setString(6, managedJob.getSourceProfile().getName());
        stmt.setString(7, managedJob.getSourcePath());
        String importFileName = null;
        File importFile = managedJob.getListFile();
        if (importFile != null) {
            importFileName = importFile.getAbsolutePath();
        }
        stmt.setString(8, importFileName);
        LoadSchedule loadSchedule = managedJob.getLoadSchedule();
        stmt.setInt(9, loadSchedule.isLowLoadEnabled() ? 1 : 0);
        stmt.setLong(10, loadSchedule.getLowLoadEndTime().getTime());
        stmt.setInt(11, loadSchedule.getLowLoadMaxConnCount());
        stmt.setInt(12, loadSchedule.getLowLoadMaxConnPerNodeCount());
        stmt.setLong(13, loadSchedule.getLowLoadStartTime().getTime());
        stmt.setInt(14, loadSchedule.getMaxConnFilesystem());
        stmt.setInt(15, loadSchedule.getMaxConnCount());
        stmt.setInt(16, loadSchedule.getMaxConnPerNodeCount());
        stmt.setInt(17, discoveredObjCnt);
        stmt.setLong(18, maxRecordId);
        stmt.executeUpdate();
    }

    private void insertCopyJobDetails(CopyJob copyJob, Connection conn, long jobId) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(INSERT_COPY_JOB_DETAILS_SQL);
        stmt.setLong(1, jobId);
        stmt.setString(2, copyJob.getTargetProfile().getName());
        stmt.setString(3, copyJob.getTargetPath());
        FileMetadata md = copyJob.getIngestionMetadata();
        if (md.hasSearchIndex()) {
            stmt.setInt(4, md.isSearchIndex() != false ? 1 : 0);
        } else {
            stmt.setNull(4, 4);
        }
        if (md.hasShred()) {
            stmt.setInt(5, md.isShred() != false ? 1 : 0);
        } else {
            stmt.setNull(5, 4);
        }
        if (md.hasRetentionHold()) {
            stmt.setInt(6, md.isRetentionHold() != false ? 1 : 0);
        } else {
            stmt.setNull(6, 4);
        }
        if (md.hasRetention()) {
            stmt.setString(7, md.getRetention().getHCAPValue());
        } else {
            stmt.setNull(7, 12);
        }
        if (md.hasUid()) {
            stmt.setInt(8, md.getUid().intValue());
        } else {
            stmt.setNull(8, 4);
        }
        if (md.hasGid()) {
            stmt.setInt(9, md.getGid().intValue());
        } else {
            stmt.setNull(9, 4);
        }
        if (md.hasFileMode()) {
            stmt.setInt(10, md.getFileMode());
        } else {
            stmt.setNull(10, 4);
        }
        if (md.hasDirMode()) {
            stmt.setInt(11, md.getDirMode());
        } else {
            stmt.setNull(11, 4);
        }
        CustomMetadata cmd = copyJob.getCustomMetadata();
        if (cmd == null) {
            stmt.setNull(12, 12);
            stmt.setNull(13, 12);
        } else {
            stmt.setString(12, cmd.getValue());
            stmt.setString(13, cmd.getShortForm());
        }
        Owner owner = copyJob.getOwner();
        if (owner == null) {
            stmt.setNull(14, 12);
        } else {
            stmt.setString(14, copyJob.getOwner().createStringRepresentation());
        }
        ACLMetadata acl = copyJob.getACL();
        if (acl == null) {
            stmt.setNull(15, 12);
            stmt.setNull(16, 12);
        } else {
            stmt.setString(15, acl.getValue());
            stmt.setString(16, acl.getShortForm());
        }
        stmt.setInt(17, copyJob.ignoreConflicts() ? 1 : 0);
        stmt.executeUpdate();
    }

    private void insertDeleteJobDetails(DeleteJob deleteJob, Connection conn, long jobId) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(INSERT_DELETE_JOB_DETAILS_SQL);
        stmt.setLong(1, jobId);
        stmt.setInt(2, deleteJob.getOperation().ordinal());
        stmt.setString(3, deleteJob.getReason());
        stmt.executeUpdate();
    }

    private void insertSetMetadataJobDetails(SetMetadataJob metadataJob, Connection conn, long jobId) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(INSERT_SET_METADATA_JOB_DETAILS_SQL);
        stmt.setLong(1, jobId);
        FileMetadata md = metadataJob.getIngestionMetadata();
        if (md.hasSearchIndex()) {
            stmt.setInt(2, md.isSearchIndex() != false ? 1 : 0);
        } else {
            stmt.setNull(2, 4);
        }
        if (md.hasShred()) {
            stmt.setInt(3, md.isShred() != false ? 1 : 0);
        } else {
            stmt.setNull(3, 4);
        }
        if (md.hasRetentionHold()) {
            stmt.setInt(4, md.isRetentionHold() != false ? 1 : 0);
        } else {
            stmt.setNull(4, 4);
        }
        if (md.hasRetention()) {
            stmt.setString(5, md.getRetention().getHCAPValue());
        } else {
            stmt.setNull(5, 12);
        }
        CustomMetadata cmd = metadataJob.getCustomMetadata();
        if (cmd == null) {
            stmt.setNull(6, 12);
            stmt.setNull(7, 12);
        } else {
            stmt.setString(6, cmd.getValue());
            stmt.setString(7, cmd.getShortForm());
        }
        Owner owner = metadataJob.getOwner();
        if (owner == null) {
            stmt.setNull(8, 12);
        } else {
            stmt.setString(8, metadataJob.getOwner().createStringRepresentation());
        }
        ACLMetadata acl = metadataJob.getACL();
        if (acl == null) {
            stmt.setNull(9, 12);
            stmt.setNull(10, 12);
        } else {
            stmt.setString(9, acl.getValue());
            stmt.setString(10, acl.getShortForm());
        }
        stmt.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJob(JobId id, ManagedJob managedJob) throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            long jobId = id.getId();
            PooledDbConnection conn = null;
            try {
                conn = this.connPool.getConnection();
                conn.setAutoCommit(false);
                this.updateJob(managedJob, conn, jobId);
                switch (managedJob.getJobType()) {
                    case COPY: {
                        this.updateCopyJobDetails((CopyJob)managedJob, conn, jobId);
                        break;
                    }
                    case DELETE: {
                        this.updateDeleteJobDetails((DeleteJob)managedJob, conn, jobId);
                        break;
                    }
                    case SET_METADATA: {
                        this.updateSetMetadataJobDetails((SetMetadataJob)managedJob, conn, jobId);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported job type: " + (Object)((Object)managedJob.getJobType()));
                    }
                }
                conn.commit();
            }
            catch (Exception e) {
                this.rollback(conn);
                throw new DatabaseException(DBUtils.getErrorMessage("An error occurred updating the job in the database", e), e);
            }
            finally {
                this.connPool.returnConnection(conn);
            }
        }
    }

    private void updateJob(ManagedJob managedJob, Connection conn, long jobId) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(UPDATE_JOB_SQL);
        stmt.setString(1, managedJob.getJobName());
        stmt.setInt(2, managedJob.getJobType().ordinal());
        boolean isNameUserDefined = managedJob.getUserDefinedJobName() != null;
        stmt.setInt(3, isNameUserDefined ? 1 : 0);
        stmt.setString(4, managedJob.getSourceProfile().getName());
        stmt.setString(5, managedJob.getSourcePath());
        String importFileName = null;
        File importFile = managedJob.getListFile();
        if (importFile != null) {
            importFileName = importFile.getAbsolutePath();
        }
        stmt.setString(6, importFileName);
        LoadSchedule loadSchedule = managedJob.getLoadSchedule();
        stmt.setInt(7, loadSchedule.isLowLoadEnabled() ? 1 : 0);
        stmt.setLong(8, loadSchedule.getLowLoadEndTime().getTime());
        stmt.setInt(9, loadSchedule.getLowLoadMaxConnCount());
        stmt.setInt(10, loadSchedule.getLowLoadMaxConnPerNodeCount());
        stmt.setLong(11, loadSchedule.getLowLoadStartTime().getTime());
        stmt.setInt(12, loadSchedule.getMaxConnFilesystem());
        stmt.setInt(13, loadSchedule.getMaxConnCount());
        stmt.setInt(14, loadSchedule.getMaxConnPerNodeCount());
        stmt.setLong(15, jobId);
        stmt.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJobName(JobId id, String name) throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            long jobId = id.getId();
            PooledDbConnection conn = null;
            try {
                conn = this.connPool.getConnection();
                PreparedStatement stmt = conn.prepareStatement(UPDATE_JOB_NAME_SQL);
                stmt.setString(1, name);
                stmt.setLong(2, jobId);
                stmt.executeUpdate();
            }
            catch (Exception e) {
                String sqlState;
                if (e instanceof SQLException && (sqlState = ((SQLException)e).getSQLState()) != null && sqlState.equals("23505")) {
                    throw new DatabaseException("Another job of the same name already exists.", e);
                }
                throw new DatabaseException(DBUtils.getErrorMessage("An error occurred updating the job name in the database", e), e);
            }
            finally {
                this.connPool.returnConnection(conn);
            }
        }
    }

    private void updateCopyJobDetails(CopyJob copyJob, Connection conn, long jobId) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(UPDATE_COPY_JOB_DETAILS_SQL);
        stmt.setString(1, copyJob.getTargetProfile().getName());
        stmt.setString(2, copyJob.getTargetPath());
        FileMetadata md = copyJob.getIngestionMetadata();
        if (md.hasSearchIndex()) {
            stmt.setInt(3, md.isSearchIndex() != false ? 1 : 0);
        } else {
            stmt.setNull(3, 4);
        }
        if (md.hasShred()) {
            stmt.setInt(4, md.isShred() != false ? 1 : 0);
        } else {
            stmt.setNull(4, 4);
        }
        if (md.hasRetentionHold()) {
            stmt.setInt(5, md.isRetentionHold() != false ? 1 : 0);
        } else {
            stmt.setNull(5, 4);
        }
        if (md.hasRetention()) {
            stmt.setString(6, md.getRetention().getHCAPValue());
        } else {
            stmt.setNull(6, 12);
        }
        if (md.hasUid()) {
            stmt.setInt(7, md.getUid().intValue());
        } else {
            stmt.setNull(7, 4);
        }
        if (md.hasGid()) {
            stmt.setInt(8, md.getGid().intValue());
        } else {
            stmt.setNull(8, 4);
        }
        if (md.hasFileMode()) {
            stmt.setInt(9, md.getFileMode());
        } else {
            stmt.setNull(9, 4);
        }
        if (md.hasDirMode()) {
            stmt.setInt(10, md.getDirMode());
        } else {
            stmt.setNull(10, 4);
        }
        CustomMetadata cmd = copyJob.getCustomMetadata();
        if (cmd == null) {
            stmt.setNull(11, 12);
            stmt.setNull(12, 12);
        } else {
            stmt.setString(11, cmd.getValue());
            stmt.setString(12, cmd.getShortForm());
        }
        if (md.hasOwner()) {
            stmt.setString(13, md.getOwner().createStringRepresentation());
        } else {
            stmt.setNull(13, 12);
        }
        if (md.hasACL().booleanValue()) {
            stmt.setString(14, md.getACL().getValue());
            stmt.setString(15, md.getACL().getShortForm());
        } else {
            stmt.setNull(14, 12);
            stmt.setNull(15, 12);
        }
        stmt.setInt(16, copyJob.ignoreConflicts() ? 1 : 0);
        stmt.setLong(17, jobId);
        stmt.executeUpdate();
    }

    private void updateDeleteJobDetails(DeleteJob deleteJob, Connection conn, long jobId) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(UPDATE_DELETE_JOB_DETAILS_SQL);
        stmt.setInt(1, deleteJob.getOperation().ordinal());
        stmt.setString(2, deleteJob.getReason());
        stmt.setLong(3, jobId);
        stmt.executeUpdate();
    }

    private void updateSetMetadataJobDetails(SetMetadataJob metadataJob, Connection conn, long jobId) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(UPDATE_SET_METADATA_JOB_DETAILS_SQL);
        FileMetadata md = metadataJob.getIngestionMetadata();
        if (md.hasSearchIndex()) {
            stmt.setInt(1, md.isSearchIndex() != false ? 1 : 0);
        } else {
            stmt.setNull(1, 4);
        }
        if (md.hasShred()) {
            stmt.setInt(2, md.isShred() != false ? 1 : 0);
        } else {
            stmt.setNull(2, 4);
        }
        if (md.hasRetentionHold()) {
            stmt.setInt(3, md.isRetentionHold() != false ? 1 : 0);
        } else {
            stmt.setNull(3, 4);
        }
        if (md.hasRetention()) {
            stmt.setString(4, md.getRetention().getHCAPValue());
        } else {
            stmt.setNull(4, 12);
        }
        CustomMetadata cmd = metadataJob.getCustomMetadata();
        if (cmd == null) {
            stmt.setNull(5, 12);
            stmt.setNull(6, 12);
        } else {
            stmt.setString(5, cmd.getValue());
            stmt.setString(6, cmd.getShortForm());
        }
        if (md.hasOwner()) {
            stmt.setString(7, md.getOwner().createStringRepresentation());
        } else {
            stmt.setNull(7, 12);
        }
        if (md.hasACL().booleanValue()) {
            stmt.setString(8, md.getACL().getValue());
            stmt.setString(9, md.getACL().getShortForm());
        } else {
            stmt.setNull(8, 12);
            stmt.setNull(9, 12);
        }
        stmt.setLong(10, jobId);
        stmt.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteJob(JobId jobId, ManagedJob.Type type) throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            long dbId = jobId.getId();
            PooledDbConnection conn = null;
            try {
                ManagedJobSchema jobSchema;
                switch (type) {
                    case COPY: {
                        jobSchema = new CopyJobSchema(jobId.getId());
                        break;
                    }
                    case DELETE: {
                        jobSchema = new DeleteJobSchema(jobId.getId());
                        break;
                    }
                    case SET_METADATA: {
                        jobSchema = new SetMetadataJobSchema(jobId.getId());
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported job type: " + (Object)((Object)type));
                    }
                }
                jobSchema.dropSchema();
                conn = this.connPool.getConnection();
                conn.setAutoCommit(false);
                this.deleteJob(conn, dbId);
                switch (type) {
                    case COPY: {
                        this.deleteCopyJobDetails(conn, dbId);
                        break;
                    }
                    case DELETE: {
                        this.deleteDeleteJobDetails(conn, dbId);
                        break;
                    }
                    case SET_METADATA: {
                        this.deleteMetadataJobDetails(conn, dbId);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported job type: " + (Object)((Object)type));
                    }
                }
                conn.commit();
                this.connPool.returnConnection(conn);
            }
            catch (Exception e) {
                try {
                    this.rollback(conn);
                    throw new DatabaseException(DBUtils.getErrorMessage("An error occurred deleting a job from the database", e), e);
                }
                catch (Throwable throwable) {
                    this.connPool.returnConnection(conn);
                    throw throwable;
                }
            }
        }
    }

    private void deleteJob(Connection conn, long jobId) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(DELETE_FROM_JOBS_SQL);
        stmt.setLong(1, jobId);
        stmt.executeUpdate();
    }

    private void deleteCopyJobDetails(Connection conn, long jobId) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(DELETE_FROM_COPY_JOB_DETAILS_SQL);
        stmt.setLong(1, jobId);
        stmt.executeUpdate();
    }

    private void deleteDeleteJobDetails(Connection conn, long jobId) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(DELETE_FROM_DELETE_JOB_DETAILS_SQL);
        stmt.setLong(1, jobId);
        stmt.executeUpdate();
    }

    private void deleteMetadataJobDetails(Connection conn, long jobId) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(DELETE_FROM_METADATA_JOB_DETAILS_SQL);
        stmt.setLong(1, jobId);
        stmt.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLoadSchedule(JobId jobId, LoadSchedule loadSchedule) throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            PooledDbConnection conn = null;
            try {
                conn = this.connPool.getConnection();
                conn.setAutoCommit(false);
                this.updateLoadSchedule(loadSchedule, conn, jobId.getId());
                conn.commit();
            }
            catch (Exception e) {
                this.rollback(conn);
                throw new DatabaseException(DBUtils.getErrorMessage("An error occurred updating the load schedule", e), e);
            }
            finally {
                this.connPool.returnConnection(conn);
            }
        }
    }

    private void updateLoadSchedule(LoadSchedule loadSchedule, Connection conn, long jobId) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(UPDATE_LOAD_SCHEDULE_SQL);
        stmt.setInt(1, loadSchedule.isLowLoadEnabled() ? 1 : 0);
        stmt.setLong(2, loadSchedule.getLowLoadEndTime().getTime());
        stmt.setInt(3, loadSchedule.getLowLoadMaxConnCount());
        stmt.setInt(4, loadSchedule.getLowLoadMaxConnPerNodeCount());
        stmt.setLong(5, loadSchedule.getLowLoadStartTime().getTime());
        stmt.setInt(6, loadSchedule.getMaxConnFilesystem());
        stmt.setInt(7, loadSchedule.getMaxConnCount());
        stmt.setInt(8, loadSchedule.getMaxConnPerNodeCount());
        stmt.setLong(9, jobId);
        stmt.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJobStatus(JobId jobId, JobStatus status) throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            PooledDbConnection conn = null;
            try {
                conn = this.connPool.getConnection();
                this.updateJobStatus(conn, jobId.getId(), status);
            }
            catch (Exception e) {
                this.rollback(conn);
                throw new DatabaseException(DBUtils.getErrorMessage("An error occurred updating job status", e), e);
            }
            finally {
                this.connPool.returnConnection(conn);
            }
        }
    }

    private void updateJobStatus(Connection conn, long jobId, JobStatus status) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(UPDATE_JOB_STATUS_SQL);
        stmt.setInt(1, status.ordinal());
        stmt.setLong(2, jobId);
        stmt.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFindFilesStatus(long jobId, boolean isComplete) throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            PooledDbConnection conn = null;
            try {
                conn = this.connPool.getConnection();
                this.updateFindFilesStatus(conn, jobId, isComplete);
            }
            catch (Exception e) {
                this.rollback(conn);
                throw new DatabaseException(DBUtils.getErrorMessage("An error occurred updating job status", e), e);
            }
            finally {
                this.connPool.returnConnection(conn);
            }
        }
    }

    private void updateFindFilesStatus(Connection conn, long jobId, boolean isComplete) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(UPDATE_IS_FIND_COMPLETE_SQL);
        stmt.setInt(1, isComplete ? 1 : 0);
        stmt.setLong(2, jobId);
        stmt.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRunStats(long jobId, long startTime, long endTime, long runTime) throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            PooledDbConnection conn = null;
            try {
                conn = this.connPool.getConnection();
                this.updateRunStats(conn, jobId, startTime, endTime, runTime);
            }
            catch (Exception e) {
                this.rollback(conn);
                throw new DatabaseException(DBUtils.getErrorMessage("An error occurred updating job statistics", e), e);
            }
            finally {
                this.connPool.returnConnection(conn);
            }
        }
    }

    private void updateRunStats(Connection conn, long jobId, long startTime, long endTime, long runTime) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(UPDATE_RUN_STATS_SQL);
        stmt.setLong(1, startTime);
        stmt.setLong(2, endTime);
        stmt.setLong(3, runTime);
        stmt.setLong(4, jobId);
        stmt.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProcessedFilesStats(PooledDbConnection conn, long jobId, long totalCnt, long totalSize, long successCnt, long successSize, long failCnt, long failSize, long failDirCnt) throws SQLException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            PreparedStatement selectStmt = conn.prepareStatement(GET_PROCESSED_FILES_STATS_STMT_NAME, GET_PROCESSED_FILES_STATS);
            selectStmt.clearParameters();
            selectStmt.setLong(1, jobId);
            ResultSet rs = selectStmt.executeQuery();
            if (!rs.next()) {
                throw new RuntimeException("No row found for id " + jobId + ", sql: " + GET_PROCESSED_FILES_STATS);
            }
            totalCnt += rs.getLong(ManagedJobTableColumn.TOTAL_OBJ_CNT.getColumnName());
            totalSize += rs.getLong(ManagedJobTableColumn.TOTAL_OBJ_SIZE.getColumnName());
            successCnt += rs.getLong(ManagedJobTableColumn.SUCCESS_OBJ_CNT.getColumnName());
            successSize += rs.getLong(ManagedJobTableColumn.SUCCESS_OBJ_SIZE.getColumnName());
            failCnt += rs.getLong(ManagedJobTableColumn.FAIL_OBJ_CNT.getColumnName());
            failSize += rs.getLong(ManagedJobTableColumn.FAIL_OBJ_SIZE.getColumnName());
            failDirCnt += rs.getLong(ManagedJobTableColumn.FAIL_DIR_CNT.getColumnName());
            PreparedStatement stmt = conn.prepareStatement(UPDATE_PROCESSED_FILES_STATS_STMT_NAME, UPDATE_PROCESSED_FILES_STATS);
            stmt.clearParameters();
            stmt.setLong(1, totalCnt);
            stmt.setLong(2, totalSize);
            stmt.setLong(3, successCnt);
            stmt.setLong(4, successSize);
            stmt.setLong(5, failCnt);
            stmt.setLong(6, failSize);
            stmt.setLong(7, failDirCnt);
            stmt.setLong(8, jobId);
            stmt.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTotalFilesStats(PooledDbConnection conn, long jobId, long totalCntToAdd, long sizeToAdd) throws SQLException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            PreparedStatement selectStmt = conn.prepareStatement(GET_TOTAL_FILES_STATS_STMT_NAME, GET_TOTAL_FILES_STATS);
            selectStmt.clearParameters();
            selectStmt.setLong(1, jobId);
            ResultSet rs = selectStmt.executeQuery();
            if (!rs.next()) {
                throw new RuntimeException("No row found for id " + jobId + ", sql: " + GET_TOTAL_FILES_STATS);
            }
            long totalCnt = rs.getLong(1) + totalCntToAdd;
            long totalSize = rs.getLong(2) + sizeToAdd;
            PreparedStatement stmt = conn.prepareStatement(UPDATE_TOTAL_FILES_STATS_STMT_NAME, UPDATE_TOTAL_FILES_STATS);
            stmt.clearParameters();
            stmt.setLong(1, totalCnt);
            stmt.setLong(2, totalSize);
            stmt.setLong(3, jobId);
            stmt.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDirStats(PooledDbConnection conn, long jobId, int totalCntToAdd, int failCntToAdd, int failDirCntToAdd) throws SQLException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            PreparedStatement selectStmt = conn.prepareStatement(GET_TOTAL_AND_FAILED_STATS_STMT_NAME, GET_TOTAL_AND_FAILED_STATS);
            selectStmt.clearParameters();
            selectStmt.setLong(1, jobId);
            ResultSet rs = selectStmt.executeQuery();
            if (!rs.next()) {
                throw new RuntimeException("No row found for id " + jobId + ", sql: " + GET_TOTAL_FILES_STATS);
            }
            long totalCnt = rs.getLong(1) + (long)totalCntToAdd;
            long failCnt = rs.getLong(2) + (long)failCntToAdd;
            long failDirCnt = rs.getLong(3) + (long)failDirCntToAdd;
            PreparedStatement stmt = conn.prepareStatement(UPDATE_TOTAL_AND_FAILED_STMT_NAME, UPDATE_TOTAL_AND_FAILED_STATS);
            stmt.clearParameters();
            stmt.setLong(1, totalCnt);
            stmt.setLong(2, failCnt);
            stmt.setLong(3, failDirCnt);
            stmt.setLong(4, jobId);
            stmt.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementTotalAndFailedObjectCnt(PooledDbConnection conn, long jobId, int totalCntToSubtract, int failCntToSubtract) throws SQLException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            PreparedStatement selectStmt = conn.prepareStatement(GET_TOTAL_AND_FAILED_STATS_STMT_NAME, GET_TOTAL_AND_FAILED_STATS);
            selectStmt.clearParameters();
            selectStmt.setLong(1, jobId);
            ResultSet rs = selectStmt.executeQuery();
            if (!rs.next()) {
                throw new RuntimeException("No row found for id " + jobId + ", sql: " + GET_TOTAL_FILES_STATS);
            }
            long totalCnt = rs.getLong(1) - (long)totalCntToSubtract;
            long failCnt = rs.getLong(2) - (long)failCntToSubtract;
            long failDirCnt = rs.getLong(3);
            if (totalCnt < 0L) {
                LOG.log(Level.WARNING, "Attempted to reduce total object count to below zero");
                totalCnt = 0L;
            }
            if (failCnt < 0L) {
                LOG.log(Level.WARNING, "Attempted to reduce failed object count to below zero");
                failCnt = 0L;
            }
            PreparedStatement stmt = conn.prepareStatement(UPDATE_TOTAL_AND_FAILED_STMT_NAME, UPDATE_TOTAL_AND_FAILED_STATS);
            stmt.clearParameters();
            stmt.setLong(1, totalCnt);
            stmt.setLong(2, failCnt);
            stmt.setLong(3, failDirCnt);
            stmt.setLong(4, jobId);
            stmt.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDiscoveredObjCnt(PooledDbConnection conn, long jobId, long totalCntToAdd, long maxRecordIdAdded, int maxPathDepthAdded) throws SQLException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            PreparedStatement selectStmt = conn.prepareStatement(GET_DISCOVERED_OBJ_CNT_STMT_NAME, GET_DISCOVERED_OBJ_CNT);
            selectStmt.clearParameters();
            selectStmt.setLong(1, jobId);
            ResultSet rs = selectStmt.executeQuery();
            if (!rs.next()) {
                throw new RuntimeException("No row found for id " + jobId + ", sql: " + GET_DISCOVERED_OBJ_CNT);
            }
            long totalCnt = rs.getLong(1) + totalCntToAdd;
            int maxPathDepth = rs.getInt(2);
            if (maxPathDepth >= 0) {
                maxPathDepth = Math.max(maxPathDepth, maxPathDepthAdded);
            }
            long maxRecordId = Math.max(rs.getLong(3), maxRecordIdAdded);
            PreparedStatement stmt = conn.prepareStatement(UPDATE_DISCOVERED_OBJ_CNT_STMT_NAME, UPDATE_DISCOVERED_OJB_CNT);
            stmt.clearParameters();
            stmt.setLong(1, totalCnt);
            stmt.setInt(2, maxPathDepth);
            stmt.setLong(3, maxRecordId);
            stmt.setLong(4, jobId);
            stmt.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxPathDepth(PooledDbConnection conn, long jobId) throws SQLException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            PreparedStatement selectStmt = conn.prepareStatement(GET_DISCOVERED_OBJ_CNT_STMT_NAME, GET_DISCOVERED_OBJ_CNT);
            selectStmt.clearParameters();
            selectStmt.setLong(1, jobId);
            ResultSet rs = selectStmt.executeQuery();
            if (!rs.next()) {
                throw new RuntimeException("No row found for id " + jobId + ", sql: " + GET_DISCOVERED_OBJ_CNT);
            }
            return rs.getInt(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetJobStats(long jobId) throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            PooledDbConnection conn = null;
            try {
                conn = this.connPool.getConnection();
                PreparedStatement stmt = conn.prepareStatement(RESET_JOB_STATS_SQL);
                stmt.setLong(1, jobId);
                stmt.executeUpdate();
            }
            catch (Exception e) {
                throw new DatabaseException(DBUtils.getErrorMessage("An error occurred resetting job statistics", e), e);
            }
            finally {
                this.connPool.returnConnection(conn);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<String> getJobsUsingProfile(String profileName) throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            PooledDbConnection conn = null;
            try {
                conn = this.connPool.getConnection();
                Set<String> set = this.getJobsUsingProfile(conn, profileName);
                return set;
            }
            catch (Exception e) {
                throw new DatabaseException(DBUtils.getErrorMessage("An error occurred finding jobs using profile " + profileName, e), e);
            }
            finally {
                this.connPool.returnConnection(conn);
            }
        }
    }

    private Set<String> getJobsUsingProfile(Connection conn, String profileName) throws SQLException {
        HashSet<String> jobNames = new HashSet<String>();
        if (profileName == null) {
            return jobNames;
        }
        Statement stmt = conn.createStatement();
        ResultSet rs = DBUtils.executeQuery(stmt, GET_ALL_JOBS_AND_PROFILES_SQL);
        while (rs.next()) {
            String sourceProfileName = rs.getString(ManagedJobTableColumn.SOURCE_PROFILE_NAME.toString());
            if (sourceProfileName != null && sourceProfileName.equals(profileName)) {
                jobNames.add(rs.getString(ManagedJobTableColumn.JOB_NAME.toString()));
                continue;
            }
            String targetProfileName = rs.getString(CopyJobTableColumn.TARGET_PROFILE_NAME.toString());
            if (targetProfileName == null || !targetProfileName.equals(profileName)) continue;
            jobNames.add(rs.getString(ManagedJobTableColumn.JOB_NAME.toString()));
        }
        return jobNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeProfileName(String fromName, String toName) throws DatabaseException {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            PooledDbConnection conn = null;
            try {
                conn = this.connPool.getConnection();
                this.changeProfileName(conn, fromName, toName);
            }
            catch (Exception e) {
                throw new DatabaseException(DBUtils.getErrorMessage("An error occurred changing profile name from " + fromName + " to " + toName + " in saved jobs", e), e);
            }
            finally {
                this.connPool.returnConnection(conn);
            }
        }
    }

    private void changeProfileName(Connection conn, String fromName, String toName) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(CHANGE_SOURCE_PROFILE_NAME_SQL);
        stmt.setString(1, toName);
        stmt.setString(2, fromName);
        stmt.executeUpdate();
        stmt = conn.prepareStatement(CHANGE_TARGET_PROFILE_NAME_SQL);
        stmt.setString(1, toName);
        stmt.setString(2, fromName);
        stmt.executeUpdate();
    }

    private void rollback(Connection conn) {
        try {
            conn.rollback();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        Object object = DatabaseResourceManager.DB_LOCK;
        synchronized (object) {
            this.connPool.closeAll();
            super.finalize();
        }
    }
}

