/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.utils.database;

import com.archivas.clienttools.arcutils.api.ArcMoverEngine;
import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.api.JobId;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJobSummary;
import com.archivas.clienttools.arcutils.impl.LocalJvmArcMoverEngine;
import com.archivas.clienttools.arcutils.impl.jobs.FileStatus;
import com.archivas.clienttools.arcutils.impl.jobs.ManagedJobImpl;
import com.archivas.clienttools.arcutils.model.ArcCopyFile;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.FileType;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.ProfileManager;
import com.archivas.clienttools.arcutils.utils.FileUtil;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import com.archivas.clienttools.arcutils.utils.database.DatabaseResourceManager;
import com.archivas.clienttools.arcutils.utils.database.FileLifeCycle;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobSchema;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobTableColumn;
import com.archivas.clienttools.arcutils.utils.net.SSLCertChain;
import com.archivas.clienttools.arcutils.utils.net.SSLCertificateCallback;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.time.DurationFormatUtils;

public class PopulateDmDb
implements SSLCertificateCallback {
    private String jobName;
    private ManagedJob.Type jobType;
    private long rowCnt;
    private long startTime = 0L;
    private int percentReadyToFind;
    private int percentReadyToProcess;
    private int percentReadyToPostProcess;
    private long readyToFindCnt;
    private long readyToProcessCnt;
    private long readyToPostProcessCnt;
    private FileLifeCycle jobLifeCycle;
    private FileLifeCycle fileLifeCycle;
    private FileStatus fileStatus;
    private static final String COPY_INSERT_COLS_SQL = "(INITIAL_LIST, RECORD_ID, RECORD_TYPE, SOURCE_PATH, SOURCE_VERSION, SOURCE_PROFILE_NAME, LIFE_CYCLE, STATUS, TARGET_PATH, TARGET_PROFILE_NAME, SIZE) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String DELETE_INSERT_COLS_SQL = "(INITIAL_LIST, RECORD_ID, RECORD_TYPE, SOURCE_PATH, SOURCE_VERSION, SOURCE_PROFILE_NAME, LIFE_CYCLE, STATUS)  VALUES (?, ?, ?, ?, ?, ?, ?, ?)";

    private PopulateDmDb(String jobName, ManagedJob.Type jobType, long rowCnt, int percentReadyToFind, int percentReadyToProcess, int percentReadyToPostProcess, FileLifeCycle jobLifeCycle) {
        this.jobName = jobName;
        this.jobType = jobType;
        this.rowCnt = rowCnt;
        this.percentReadyToFind = percentReadyToFind;
        this.percentReadyToProcess = percentReadyToProcess;
        this.percentReadyToPostProcess = percentReadyToPostProcess;
        this.jobLifeCycle = jobLifeCycle;
    }

    private void insertRows() throws SQLException, DatabaseException, JobException {
        long l;
        ArcMoverEngine engine = LocalJvmArcMoverEngine.getInstance();
        List<ManagedJobSummary> allJobs = engine.getAllManagedJobs();
        JobId jobId = null;
        for (ManagedJobSummary summary : allJobs) {
            if (!summary.getJobName().equals(this.jobName)) continue;
            jobId = summary.getJobId();
            break;
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Job \"" + this.jobName + "\" not found");
        }
        System.out.print("Loading managed job ....");
        System.out.flush();
        ManagedJobImpl jobImpl = engine.loadManagedJob(jobId, this.jobType);
        System.out.println(" done");
        ManagedJob job = jobImpl.getJob();
        AbstractProfileBase sourceProfile = job.getSourceProfile();
        AbstractProfileBase targetProfile = job.getTargetProfile();
        String sourcePath = job.getSourcePath();
        String targetPath = job.getTargetPath();
        ArcCopyFile file = this.generateFile(sourceProfile, targetProfile, sourcePath, targetPath);
        String fileSourcePath = file.getSourcePath();
        String fileSourceProfile = file.getSourceProfile().getName();
        String fileTargetPath = file.getTargetPath();
        String fileTargetProfile = targetProfile == null ? null : file.getTargetProfile().getName();
        long fileSize = file.getSize();
        int fileObjectType = FileType.UNKNOWN.ordinal();
        if (file.isDirectory()) {
            fileObjectType = FileType.DIRECTORY.ordinal();
        } else if (file.isFile()) {
            fileObjectType = FileType.FILE.ordinal();
        }
        Long version = file.getSourceVersion();
        if (version == null) {
            version = 0L;
        }
        long recordId = jobImpl.getManagedJobSchema().getLastDbRecordId();
        long discoveredObjectCnt = jobImpl.getDiscoveredObjectCount();
        long totalObjCnt = jobImpl.getTotalObjectCount();
        System.out.println("*** max RECORD_ID = " + recordId + ", initialDiscoveredObjectCnt = " + discoveredObjectCnt);
        boolean isDelete = this.jobType == ManagedJob.Type.DELETE;
        String insertSql = "INSERT INTO " + ManagedJobSchema.getJobSchemaName(jobId.getId()) + "." + "JOB_FILES" + (isDelete ? DELETE_INSERT_COLS_SQL : COPY_INSERT_COLS_SQL);
        String updateSql = "UPDATE managed_jobs set " + (Object)((Object)ManagedJobTableColumn.DISCOVERED_OBJ_CNT) + " = ?, " + (Object)((Object)ManagedJobTableColumn.MAX_RECORD_ID) + " = ?, " + (Object)((Object)ManagedJobTableColumn.TOTAL_OBJ_CNT) + " = ?  WHERE " + (Object)((Object)ManagedJobTableColumn.JOB_ID) + " = ?";
        Connection conn = DatabaseResourceManager.createConnection();
        conn.setAutoCommit(false);
        PreparedStatement insertStatement = conn.prepareStatement(insertSql);
        PreparedStatement updateStatement = conn.prepareStatement(updateSql);
        this.startTime = System.currentTimeMillis();
        for (l = 0L; l < this.rowCnt; ++l) {
            ++recordId;
            this.getLifeCycle(l);
            if (this.fileLifeCycle.ordinal() > FileLifeCycle.FINDING.ordinal()) {
                ++totalObjCnt;
            }
            ++discoveredObjectCnt;
            insertStatement.clearParameters();
            insertStatement.setInt(1, DatabaseResourceManager.boolToDbValue(false));
            insertStatement.setLong(2, recordId);
            insertStatement.setInt(3, fileObjectType);
            insertStatement.setString(4, fileSourcePath);
            insertStatement.setLong(5, version);
            insertStatement.setString(6, fileSourceProfile);
            insertStatement.setInt(7, this.fileLifeCycle.ordinal());
            if (this.fileStatus == null) {
                insertStatement.setNull(8, 5);
            } else {
                insertStatement.setInt(8, this.fileStatus.ordinal());
            }
            if (!isDelete) {
                insertStatement.setString(9, fileTargetPath);
                insertStatement.setString(10, fileTargetProfile);
                insertStatement.setLong(11, fileSize);
            }
            insertStatement.execute();
            if (l % 5000L != 0L) continue;
            updateStatement.clearParameters();
            updateStatement.setLong(1, discoveredObjectCnt);
            updateStatement.setLong(2, recordId);
            updateStatement.setLong(3, totalObjCnt);
            updateStatement.setLong(4, jobId.getId());
            updateStatement.execute();
            conn.commit();
            this.displayStats(l);
        }
        updateStatement.clearParameters();
        updateStatement.setLong(1, discoveredObjectCnt);
        updateStatement.setLong(2, recordId);
        updateStatement.setLong(3, totalObjCnt);
        updateStatement.setLong(4, jobId.getId());
        updateStatement.execute();
        conn.commit();
        this.displayStats(l);
    }

    private void getLifeCycle(long rowNum) {
        int val = (int)rowNum % 100;
        if (this.percentReadyToFind > 0 && val < this.percentReadyToFind) {
            ++this.readyToFindCnt;
            if (this.jobLifeCycle.ordinal() > FileLifeCycle.FINDING.ordinal()) {
                this.fileLifeCycle = FileLifeCycle.FINDING;
                this.fileStatus = FileStatus.FAILED;
            } else {
                this.fileLifeCycle = FileLifeCycle.READY_TO_FIND;
                this.fileStatus = FileStatus.NONE;
            }
        } else if (this.percentReadyToProcess > 0 && val >= this.percentReadyToFind && val < this.percentReadyToFind + this.percentReadyToProcess) {
            ++this.readyToProcessCnt;
            if (this.jobLifeCycle.ordinal() > FileLifeCycle.PROCESSING.ordinal()) {
                this.fileLifeCycle = FileLifeCycle.PROCESSING;
                this.fileStatus = FileStatus.FAILED;
            } else {
                this.fileLifeCycle = FileLifeCycle.READY_TO_PROCESS;
                this.fileStatus = FileStatus.NONE;
            }
        } else if (this.percentReadyToPostProcess > 0 && val >= this.percentReadyToFind + this.percentReadyToProcess) {
            ++this.readyToPostProcessCnt;
            if (this.jobLifeCycle.ordinal() > FileLifeCycle.POSTPROCESSING.ordinal()) {
                this.fileLifeCycle = FileLifeCycle.POSTPROCESSING;
                this.fileStatus = FileStatus.FAILED;
            } else {
                this.fileLifeCycle = FileLifeCycle.READY_TO_POSTPROCESS;
                this.fileStatus = FileStatus.NONE;
            }
        } else {
            throw new RuntimeException("Could not determine the life cycle to get");
        }
    }

    private void displayStats(long insertedCnt) {
        float percentComplete = (float)insertedCnt / (float)this.rowCnt;
        long now = System.currentTimeMillis();
        long elapsedTime = now - this.startTime;
        long timeRemaining = (long)((float)(now - this.startTime) / percentComplete) - elapsedTime;
        String elapsedTimeStr = DurationFormatUtils.formatDurationWords((long)elapsedTime, (boolean)true, (boolean)true);
        String timeRemainingStr = DurationFormatUtils.formatDurationWords((long)timeRemaining, (boolean)true, (boolean)true);
        System.out.println("Inserted " + insertedCnt + " rows (" + this.readyToFindCnt + " readyToFind, " + this.readyToProcessCnt + " readyToProcess, " + this.readyToPostProcessCnt + " readyToPostProcess) in " + elapsedTimeStr + ".  " + (int)(percentComplete * 100.0f) + " % complete, " + timeRemainingStr + " remaining.");
    }

    private ArcCopyFile generateFile(AbstractProfileBase sourceProfile, AbstractProfileBase targetProfile, String rootSourcePath, String rootTargetPath) {
        String fileName = this.generateFilePath();
        String sourceFileName = fileName = FileUtil.converWindowsPathToUnix(fileName, sourceProfile.getPathSeparator());
        if (sourceFileName.indexOf(":") == 1 && rootSourcePath.indexOf(":") == 1) {
            sourceFileName = sourceFileName.substring(2);
        }
        String targetFileName = fileName;
        if (fileName.indexOf(":") == 1) {
            targetFileName = targetFileName.substring(2);
        }
        String completeSourcePath = FileUtil.resolvePath(rootSourcePath, sourceFileName, sourceProfile.getPathSeparator());
        String completeTargetPath = null;
        if (targetProfile != null) {
            completeTargetPath = FileUtil.resolvePath(rootTargetPath, targetFileName, targetProfile.getPathSeparator());
        }
        ArcMoverFile source = ArcMoverFile.getFileInstance(sourceProfile, completeSourcePath, new FileMetadata(FileType.FILE));
        return new ArcCopyFile(source, targetProfile, completeTargetPath, null);
    }

    private String generateFilePath() {
        return "abcd/efg/hijkl/mnop/qrstuv/wxyzabcd/efg/hijk/lmnop";
    }

    @Override
    public void validCertCallback(AbstractProfileBase profile, SSLCertChain certChain) {
        profile.setSSLCertChain(certChain);
    }

    @Override
    public SSLCertificateCallback.AllowSSLCert exceptionCallback(AbstractProfileBase profile, SSLCertChain certChain, String warningString) {
        return SSLCertificateCallback.AllowSSLCert.THIS_SESSION_ONLY;
    }

    public static void main(String[] args) {
        String usageString = "Usage: hcpdm populate <job_name> <COPY|DELETE> <rowCnt> <percentReadyToFind> <percentReadyToProcess> <percentReadyToPostProcess> <life-cycle>";
        String jobName = null;
        long rowCnt = 0L;
        ManagedJob.Type jobType = null;
        int percentReadyToFind = 0;
        int percentReadyToProcess = 0;
        int percentReadyToPostProcess = 0;
        FileLifeCycle lifeCycle = null;
        try {
            jobName = args[1];
            jobType = ManagedJob.Type.valueOf(args[2]);
            if (jobType == null) {
                throw new IllegalArgumentException("invalid job type <" + args[2] + ">.  Must be COPY or DELETE");
            }
            rowCnt = Long.valueOf(args[3]);
            percentReadyToFind = Integer.valueOf(args[4]);
            if (percentReadyToFind + (percentReadyToProcess = Integer.valueOf(args[5]).intValue()) + (percentReadyToPostProcess = Integer.valueOf(args[6]).intValue()) != 100) {
                throw new IllegalArgumentException("percentReadyToFind + percentReadyToProcess + percentReadyToPostProcess must equal 100");
            }
            if (percentReadyToFind < 0 || percentReadyToProcess < 0 || percentReadyToPostProcess < 0) {
                throw new IllegalArgumentException("percentReadyToFind, percentReadyToProcess, and percentReadyToPostProcess must all be between 0 and 100, inclusive");
            }
            lifeCycle = FileLifeCycle.valueOf(args[7]);
        }
        catch (Exception e) {
            System.out.println(usageString);
            e.printStackTrace();
            System.exit(-1);
        }
        try {
            PopulateDmDb pop = new PopulateDmDb(jobName, jobType, rowCnt, percentReadyToFind, percentReadyToProcess, percentReadyToPostProcess, lifeCycle);
            ProfileManager.initialize(pop);
            pop.insertRows();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

