/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.utils.database;

import com.archivas.clienttools.arcutils.config.HCPMoverProperties;
import com.archivas.clienttools.arcutils.impl.jobs.FileStatus;
import com.archivas.clienttools.arcutils.utils.database.BatchTableUpdater;
import com.archivas.clienttools.arcutils.utils.database.FileLifeCycle;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobFilesTableColumn;

public class ResetJobTableIterator {
    private BatchTableUpdater findUpdater;
    private BatchTableUpdater processUpdater;
    private BatchTableUpdater postProcessUpdater;

    public ResetJobTableIterator(long jobId, String tableName, boolean dirsIncludedInTotalCnt) throws Exception {
        this.findUpdater = new BatchTableUpdater(jobId, tableName, ManagedJobFilesTableColumn.STATUS.toString() + " = " + FileStatus.NONE.ordinal() + ", " + ManagedJobFilesTableColumn.LIFE_CYCLE.toString() + " = " + FileLifeCycle.READY_TO_FIND.ordinal(), ManagedJobFilesTableColumn.LIFE_CYCLE.toString() + " = " + FileLifeCycle.FINDING.ordinal() + " AND " + ManagedJobFilesTableColumn.STATUS.toString() + " = " + FileStatus.FAILED.ordinal(), HCPMoverProperties.FIND_FILES_BATCH_SIZE.getAsInt(), true, dirsIncludedInTotalCnt);
        this.processUpdater = new BatchTableUpdater(jobId, tableName, ManagedJobFilesTableColumn.STATUS.toString() + " = " + FileStatus.NONE.ordinal() + ", " + ManagedJobFilesTableColumn.LIFE_CYCLE.toString() + " = " + FileLifeCycle.READY_TO_PROCESS.ordinal(), ManagedJobFilesTableColumn.LIFE_CYCLE.toString() + " = " + FileLifeCycle.PROCESSING.ordinal() + " AND " + ManagedJobFilesTableColumn.STATUS.toString() + " = " + FileStatus.FAILED.ordinal(), HCPMoverProperties.PROCESS_FILES_BATCH_SIZE.getAsInt(), false, false);
        this.postProcessUpdater = new BatchTableUpdater(jobId, tableName, ManagedJobFilesTableColumn.STATUS.toString() + " = " + FileStatus.NONE.ordinal() + ", " + ManagedJobFilesTableColumn.LIFE_CYCLE.toString() + " = " + FileLifeCycle.READY_TO_POSTPROCESS.ordinal(), ManagedJobFilesTableColumn.LIFE_CYCLE.toString() + " = " + FileLifeCycle.POSTPROCESSING.ordinal() + " AND " + ManagedJobFilesTableColumn.STATUS.toString() + " = " + FileStatus.FAILED.ordinal(), HCPMoverProperties.POSTPROCESS_FILES_BATCH_SIZE.getAsInt(), false, false);
    }

    public synchronized boolean updateNextBatch() throws Exception {
        if (this.findUpdater != null) {
            boolean moreFindFiles = this.findUpdater.updateNextBatch();
            if (!moreFindFiles) {
                this.findUpdater = null;
            }
            return true;
        }
        if (this.processUpdater != null) {
            boolean moreProcessFiles = this.processUpdater.updateNextBatch();
            if (!moreProcessFiles) {
                this.processUpdater = null;
            }
            return true;
        }
        if (this.postProcessUpdater != null) {
            boolean morePostProcessFiles = this.postProcessUpdater.updateNextBatch();
            if (!morePostProcessFiles) {
                this.postProcessUpdater = null;
            }
            return morePostProcessFiles;
        }
        return false;
    }

    public synchronized void close() {
        if (this.findUpdater != null) {
            this.findUpdater.close();
            this.findUpdater = null;
        }
        if (this.processUpdater != null) {
            this.processUpdater.close();
            this.processUpdater = null;
        }
        if (this.postProcessUpdater != null) {
            this.postProcessUpdater.close();
            this.postProcessUpdater = null;
        }
    }
}

