/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.utils.database;

import com.archivas.clienttools.arcutils.impl.jobs.FileStatus;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.model.ArcProcessFile;
import com.archivas.clienttools.arcutils.model.ArcSetMetadataFile;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.FileType;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.utils.database.DatabaseResourceManager;
import com.archivas.clienttools.arcutils.utils.database.FileLifeCycle;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobFilesTableColumn;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobSchema;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SetMetadataJobSchema
extends ManagedJobSchema {
    private static final String INSERT_FILES_TO_DISCOVER_COLS = "( " + (Object)((Object)ManagedJobFilesTableColumn.LIFE_CYCLE) + ", " + (Object)((Object)ManagedJobFilesTableColumn.STATUS) + ", " + (Object)((Object)ManagedJobFilesTableColumn.INITIAL_LIST) + ", " + (Object)((Object)ManagedJobFilesTableColumn.RECORD_ID) + ", " + (Object)((Object)ManagedJobFilesTableColumn.RECORD_TYPE) + ", " + (Object)((Object)ManagedJobFilesTableColumn.SOURCE_PATH) + ", " + (Object)((Object)ManagedJobFilesTableColumn.SOURCE_VERSION) + ", " + (Object)((Object)ManagedJobFilesTableColumn.PARENT_RECORD_ID) + " ) values ( " + FileLifeCycle.READY_TO_FIND.ordinal() + ", " + FileStatus.NONE.ordinal() + ", ?, ?, ?, ?, ?, ?)";

    public SetMetadataJobSchema(long jobId) {
        super(jobId);
    }

    @Override
    protected String getExtraFileDataColumns() {
        return "";
    }

    @Override
    protected String getInsertFilesToDiscoverSqlCols() {
        return INSERT_FILES_TO_DISCOVER_COLS;
    }

    @Override
    protected void setInsertFilesToDiscoverySqlParams(ArcProcessFile file, PreparedStatement preparedStatement, boolean isInitialList, long id, int pathDepth) throws SQLException {
        preparedStatement.setInt(1, DatabaseResourceManager.boolToDbValue(isInitialList));
        preparedStatement.setLong(2, id);
        int fileObjectType = FileType.UNKNOWN.ordinal();
        if (file.isDirectory()) {
            fileObjectType = FileType.DIRECTORY.ordinal();
        } else if (file.isFile()) {
            fileObjectType = FileType.FILE.ordinal();
        } else if (file.isSymlink()) {
            fileObjectType = FileType.SYMLINK.ordinal();
        }
        Long version = file.getSourceVersion();
        if (version == null) {
            version = 0L;
        }
        preparedStatement.setInt(3, fileObjectType);
        preparedStatement.setString(4, file.getSourcePath());
        preparedStatement.setLong(5, version);
        preparedStatement.setLong(6, file.getParentDatabaseRecordId());
    }

    @Override
    protected ArcProcessFile readArcProcessFile(ResultSet rs) throws SQLException {
        ArcMoverFile sourceFile = this.readSourceFile(this.getSourceProfile(), rs);
        ArcSetMetadataFile arcFile = new ArcSetMetadataFile(sourceFile);
        int recordId = rs.getInt(ManagedJobFilesTableColumn.RECORD_ID.toString());
        arcFile.setDatabaseRecordId(recordId);
        int parentRecordId = rs.getInt(ManagedJobFilesTableColumn.PARENT_RECORD_ID.toString());
        arcFile.setParentDatabaseRecordId(parentRecordId);
        Boolean isInInitialList = DatabaseResourceManager.dbValToBoolean((Integer)rs.getObject(ManagedJobFilesTableColumn.INITIAL_LIST.toString()));
        if (isInInitialList != null && isInInitialList.booleanValue()) {
            arcFile.setIsPartOfInitList();
        }
        return arcFile;
    }

    private ArcMoverFile readSourceFile(AbstractProfileBase sourceProfile, ResultSet rs) throws SQLException {
        String sourcePath = rs.getString(ManagedJobFilesTableColumn.SOURCE_PATH.toString());
        Long version = rs.getLong(ManagedJobFilesTableColumn.SOURCE_VERSION.toString());
        int recordTypeOrdinalValue = rs.getInt(ManagedJobFilesTableColumn.RECORD_TYPE.toString());
        FileMetadata metadata = new FileMetadata(FileType.values()[recordTypeOrdinalValue]);
        if (version != null && version > 0L) {
            metadata.setIsVersion(true);
            metadata.setVersionNumber(version);
        }
        return ArcMoverFile.getFileInstance(sourceProfile, sourcePath, metadata);
    }
}

