/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.utils.database;

import com.archivas.clienttools.arcutils.utils.database.DatabaseDataType;

public enum VersionTableColumn {
    SCHEMA_VERSION(DatabaseDataType.INT);

    private final String dataTypeString;
    private DatabaseDataType dataTypeEnum;
    private boolean isColumnUnique;

    private VersionTableColumn(DatabaseDataType dataType) {
        this(dataType, null);
    }

    private VersionTableColumn(DatabaseDataType dataType, Integer colSize) {
        this(dataType, colSize, false);
    }

    private VersionTableColumn(DatabaseDataType dataType, Integer colSize, boolean isColumnUnique) {
        this.isColumnUnique = isColumnUnique;
        this.dataTypeEnum = dataType;
        StringBuilder sb = new StringBuilder(dataType.toString());
        if (colSize != null) {
            sb.append("(").append(colSize).append(")");
        }
        this.dataTypeString = sb.toString();
    }

    public String getColumnName() {
        return this.toString();
    }

    public String getDataTypeString() {
        return this.dataTypeString;
    }

    public DatabaseDataType getDataTypeEnum() {
        return this.dataTypeEnum;
    }

    public boolean isUnique() {
        return this.isColumnUnique;
    }

    public static String getPrimaryKeyString() {
        return "";
    }

    public static String getColumnDefinitions() {
        StringBuilder sb = new StringBuilder();
        for (VersionTableColumn column : VersionTableColumn.values()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(column.getColumnName());
            sb.append(" ");
            sb.append(column.getDataTypeString());
            if (!column.isUnique()) continue;
            sb.append(" unique");
        }
        return sb.toString();
    }
}

