/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.utils.filesystem;

import com.archivas.clienttools.arcutils.utils.filesystem.FileFilterLimiter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FSIterator {
    private ArrayList<File> directories = new ArrayList();
    private ArrayList<File> initialFiles = new ArrayList();
    private FileFilterLimiter limiterFilter = null;
    private File currentDirectory = null;
    private HashMap<File, String> ioErrors = new HashMap();
    private boolean traverseSubDirs = true;

    public FSIterator(List<File> fsFileObjects, int batchSize) throws IllegalArgumentException {
        String errorMessage = null;
        if (fsFileObjects == null) {
            errorMessage = "Unable to construct hcpMoverUtils.filesystem.FSIterator because the passed File List is null.";
        }
        if (errorMessage != null) {
            throw new IllegalArgumentException(errorMessage);
        }
        this.primeCache(fsFileObjects);
        if (!this.directories.isEmpty()) {
            this.currentDirectory = this.directories.remove(0);
        }
        this.limiterFilter = new FileFilterLimiter(batchSize);
    }

    public FSIterator(File directory, int batchSize) throws IllegalArgumentException {
        String errorMessage = null;
        if (directory == null) {
            errorMessage = "Unable to construct hcpMoverUtils.filesystem.FSIterator because the passed File List is null.";
        } else if (directory.isFile()) {
            errorMessage = "File object \"directory\" param does not represent a directory. ";
        }
        if (errorMessage != null) {
            throw new IllegalArgumentException(errorMessage);
        }
        this.traverseSubDirs = false;
        ArrayList<File> directoryList = new ArrayList<File>(1);
        directoryList.add(directory);
        this.primeCache(directoryList);
        if (!this.directories.isEmpty()) {
            this.currentDirectory = this.directories.remove(0);
        }
        this.limiterFilter = new FileFilterLimiter(batchSize);
    }

    public File[] getNextBatch() {
        File[] retVal = this.initialFiles.toArray(new File[0]);
        if (retVal.length > 0) {
            this.initialFiles.clear();
        } else {
            retVal = this.currentDirectory.listFiles(this.limiterFilter);
            if (retVal == null) {
                String filePath = "null";
                if (this.limiterFilter.getLastFileSeen() != null) {
                    filePath = this.limiterFilter.getLastFileSeen().getAbsolutePath();
                }
                String msg = "IOException received while iterating directory: \"" + this.currentDirectory + "\". Number of files iterated in directory: " + this.limiterFilter.getNumberOfFilesIterated() + ". Last File object iterated in directory: " + filePath + ". Skipping this directory and all its contents. ";
                this.ioErrors.put(this.currentDirectory, msg);
                retVal = this.startIterationOfNextDirectory();
            } else {
                this.limiterFilter.resetForNextBatch(retVal.length);
                this.collectDirectories(retVal);
                if (retVal.length == 0) {
                    retVal = this.startIterationOfNextDirectory();
                }
            }
        }
        return retVal;
    }

    public HashMap getIOExceptions() {
        HashMap<File, String> retVal = new HashMap<File, String>();
        retVal.putAll(this.ioErrors);
        return retVal;
    }

    private void collectDirectories(File[] fileArray) {
        if (this.traverseSubDirs) {
            for (File f : fileArray) {
                if (!f.isDirectory()) continue;
                this.directories.add(f);
            }
        }
    }

    private File getNextDirectory() {
        File retVal = null;
        if (!this.directories.isEmpty()) {
            retVal = this.directories.remove(0);
        }
        return retVal;
    }

    private File[] startIterationOfNextDirectory() {
        File[] retVal = new File[]{};
        this.currentDirectory = this.getNextDirectory();
        if (this.currentDirectory != null) {
            this.limiterFilter.reset();
            retVal = this.getNextBatch();
        }
        return retVal;
    }

    private void primeCache(List<File> fsList) {
        for (File f : fsList) {
            if (f.isDirectory()) {
                this.directories.add(f);
                continue;
            }
            this.initialFiles.add(f);
        }
    }
}

