/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.utils.filesystem;

import java.io.File;
import java.io.FileFilter;

public class FileFilterLimiter
implements FileFilter {
    private int batchSize = 0;
    private int numberAccepted = 0;
    private int whereToStartAccepting = 0;
    private int numberFiltered = 0;
    private File lastFileSeen = null;

    FileFilterLimiter(int batchSize) throws IllegalArgumentException {
        if (batchSize == 0) {
            throw new IllegalArgumentException("Programming Error: BATCH_SIZE == 0 not allowed.");
        }
        this.batchSize = batchSize;
    }

    @Override
    public boolean accept(File pathname) {
        boolean retVal = false;
        this.lastFileSeen = pathname;
        ++this.numberFiltered;
        if (this.numberFiltered > this.whereToStartAccepting && this.numberAccepted < this.batchSize) {
            retVal = true;
            ++this.numberAccepted;
        }
        return retVal;
    }

    void resetForNextBatch(int sizeOflastBatch) {
        this.internalReset();
        this.whereToStartAccepting += sizeOflastBatch;
    }

    void reset() {
        this.internalReset();
        this.whereToStartAccepting = 0;
    }

    int getNumberOfFilesIterated() {
        return this.numberFiltered;
    }

    File getLastFileSeen() {
        File retVal = null;
        if (this.numberFiltered > 0) {
            retVal = this.lastFileSeen;
        }
        return retVal;
    }

    private void internalReset() {
        this.numberFiltered = 0;
        this.numberAccepted = 0;
    }
}

