/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.utils.filesystem;

import com.archivas.clienttools.arcutils.utils.filesystem.FSIterator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class FileSystemCache {
    private int requestedSize = 0;
    private FSIterator fsIterator = null;
    private List<File> cache = null;
    private CacheFiller fillerThread = null;
    private final File initialSingleDir;
    private final List<File> initialFileList;
    private int batchSize = 0;
    private static ArrayList<File> testDirs = new ArrayList();
    private static ArrayList<File> allTestFiles = new ArrayList();
    private static int numDirsPerDir = 10;

    public FileSystemCache(int size, List<File> fsFileObjects) throws IllegalArgumentException {
        String errorMessage = null;
        if (fsFileObjects == null) {
            errorMessage = "Unable to construct hcpMoverUtils.file system.HCPMoverFileSystemCache because the passed File List is null.";
        } else {
            for (File f : fsFileObjects) {
                if (f.exists()) continue;
                errorMessage = "Non existent file reference passed in File list to FileSystemCache constructor.";
            }
        }
        if (errorMessage != null) {
            throw new IllegalArgumentException(errorMessage);
        }
        this.initialFileList = fsFileObjects;
        this.initialSingleDir = null;
        this.requestedSize = size;
        this.cache = Collections.synchronizedList(new ArrayList(this.requestedSize));
        this.batchSize = size / 10;
        this.fsIterator = new FSIterator(fsFileObjects, this.batchSize);
        boolean moreObjectsToGet = this.fillCache();
        this.fillerThread = new CacheFiller();
        if (moreObjectsToGet) {
            this.fillerThread.setDaemon(true);
            this.fillerThread.start();
        }
    }

    public FileSystemCache(int size, File directory) throws IllegalArgumentException {
        String errorMessage = null;
        if (directory == null) {
            errorMessage = "Unable to construct hcpMoverUtils.file system.HCPMoverFileSystemCache because the passed File object is null.";
        } else if (directory.isFile()) {
            errorMessage = "File object \"directory\" param does not represent a directory. ";
        }
        if (errorMessage != null) {
            throw new IllegalArgumentException(errorMessage);
        }
        this.initialFileList = null;
        this.initialSingleDir = directory;
        this.requestedSize = size;
        this.cache = Collections.synchronizedList(new ArrayList(this.requestedSize));
        this.batchSize = size / 10;
        this.fsIterator = new FSIterator(directory, this.batchSize);
        boolean moreObjectsToGet = this.fillCache();
        this.fillerThread = new CacheFiller();
        if (moreObjectsToGet) {
            this.fillerThread.setDaemon(true);
            this.fillerThread.start();
        }
    }

    public static FileSystemCache create(FileSystemCache existingCache) throws IllegalArgumentException {
        FileSystemCache retVal = null;
        retVal = existingCache.initialFileList != null ? new FileSystemCache(existingCache.batchSize, existingCache.initialFileList) : new FileSystemCache(existingCache.batchSize, existingCache.initialSingleDir);
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized File getNextFile() {
        File retVal = null;
        if (this.cache.size() == 0) {
            CacheFiller cacheFiller = this.fillerThread;
            synchronized (cacheFiller) {
                while (this.fillerThread.isAlive() && this.cache.size() == 0) {
                    try {
                        this.fillerThread.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        if (this.cache.size() > 0) {
            retVal = this.cache.remove(0);
        }
        return retVal;
    }

    public synchronized HashMap getAllEncounteredIOExceptions() {
        HashMap retVal = new HashMap();
        retVal.putAll(this.fsIterator.getIOExceptions());
        return retVal;
    }

    private boolean fillCache() {
        boolean moreObjects = true;
        int numNeededToFillCache = this.requestedSize - this.cache.size();
        File[] files = this.fsIterator.getNextBatch();
        while (files != null && files.length > 0) {
            this.cache.addAll(Arrays.asList(files));
            if (this.cache.size() >= numNeededToFillCache) break;
            files = this.fsIterator.getNextBatch();
        }
        if (files.length == 0) {
            moreObjects = false;
        }
        return moreObjects;
    }

    private static void createDirContents(File directory, boolean singleDirectory) throws IOException {
        File newFile;
        int i;
        int numFilesPerDir = 500;
        String rootPath = directory.getAbsolutePath() + "/";
        for (i = 0; i < numFilesPerDir; ++i) {
            newFile = new File(rootPath + "file_" + i);
            newFile.deleteOnExit();
            newFile.createNewFile();
            if (singleDirectory) continue;
            allTestFiles.add(newFile);
        }
        for (i = 0; i < numDirsPerDir; ++i) {
            newFile = new File(rootPath + "dir_" + i);
            newFile.deleteOnExit();
            newFile.mkdir();
            testDirs.add(newFile);
            if (singleDirectory) continue;
            allTestFiles.add(newFile);
        }
    }

    private static List<File> createTestDirsAndFiles(boolean singleDirectory, List<File> outTopLevelRoot) throws IOException {
        ArrayList<File> retList = new ArrayList<File>();
        String osName = System.getProperty("os.name");
        File rootDir = null;
        if (osName.startsWith("Windows")) {
            File firstPartOfRoot = new File("c:/testDir/");
            firstPartOfRoot.mkdir();
            outTopLevelRoot.add(firstPartOfRoot);
            rootDir = new File(firstPartOfRoot.getAbsolutePath() + "/testRootDir");
        } else {
            String userHome = System.getProperty("user.home");
            File firstPartOfRoot = new File(userHome + "/testDir");
            firstPartOfRoot.mkdir();
            outTopLevelRoot.add(firstPartOfRoot);
            rootDir = new File(firstPartOfRoot.getAbsolutePath() + "/testRootDir");
        }
        retList.add(rootDir);
        if (singleDirectory) {
            allTestFiles.add(rootDir);
        }
        rootDir.deleteOnExit();
        rootDir.mkdir();
        String rootPathParentDir = rootDir.getParent() + "/";
        for (int i = 0; i < 10; ++i) {
            File newFile = new File(rootPathParentDir + "initfile_" + i);
            newFile.deleteOnExit();
            newFile.createNewFile();
            allTestFiles.add(newFile);
            retList.add(newFile);
        }
        testDirs.add(rootDir);
        int dirDepth = 20 * numDirsPerDir;
        for (int d = 0; d < dirDepth; ++d) {
            FileSystemCache.createDirContents(testDirs.remove(0), singleDirectory);
        }
        return retList;
    }

    private static void validateFoundFileAgainstTestFiles(File fileObj) {
        boolean foundInList;
        if (fileObj != null && !(foundInList = allTestFiles.remove(fileObj))) {
            System.err.println("Test failed. File: " + fileObj.getAbsolutePath() + " not found in test list.");
            System.exit(-1);
        }
    }

    private static void runTest(boolean singleDirectory) throws Exception {
        try {
            int numFileObjectsRetrieved = 0;
            System.out.println("Creating test file system...");
            ArrayList<File> topLevelDir = new ArrayList<File>(1);
            List<File> fileObjects = FileSystemCache.createTestDirsAndFiles(singleDirectory, topLevelDir);
            System.out.println("Test file system created.");
            System.out.println("Creating HCPMoverFileCache...");
            long createStartTime = System.currentTimeMillis();
            FileSystemCache cache = null;
            cache = singleDirectory ? new FileSystemCache(10000, (File)topLevelDir.get(0)) : new FileSystemCache(10000, fileObjects);
            long createEndTime = System.currentTimeMillis();
            System.out.println("HCPMoverFileCache created.");
            System.out.println("Total create time of cache: " + (createEndTime - createStartTime) / 1000L + " seconds");
            long startTime = System.currentTimeMillis();
            File nextFile = cache.getNextFile();
            int totalNumOfTestFileObjects = allTestFiles.size();
            FileSystemCache.validateFoundFileAgainstTestFiles(nextFile);
            while (nextFile != null) {
                ++numFileObjectsRetrieved;
                nextFile = cache.getNextFile();
                FileSystemCache.validateFoundFileAgainstTestFiles(nextFile);
            }
            long endTime = System.currentTimeMillis();
            long totalTime = endTime - startTime;
            System.out.println("Test iteration time time: " + totalTime / 1000L + " seconds.");
            System.out.println("The number of File object retrieved is: " + numFileObjectsRetrieved);
            HashMap ioExceptionsMap = cache.getAllEncounteredIOExceptions();
            int numberDirectoriesSkipped = ioExceptionsMap.size();
            System.out.println("\nThe total number of skipped directories is: " + numberDirectoriesSkipped);
            if (numberDirectoriesSkipped > 0) {
                System.err.println("The found IOException follow:");
            }
            for (File f : ioExceptionsMap.keySet()) {
                System.err.println("Skipped Dir: " + f.getAbsolutePath() + ". Msg: " + (String)ioExceptionsMap.get(f));
            }
            if (!allTestFiles.isEmpty()) {
                int numFilesNotFound = allTestFiles.size();
                System.err.println("Test failed. All fileObjects not found by iterator. Number fileObjects not found: " + numFilesNotFound);
                System.err.println("Files not found: ");
                for (int i = 0; i < numFilesNotFound; ++i) {
                    System.err.println(allTestFiles.get(i).getAbsolutePath());
                }
                System.exit(-1);
            }
        }
        catch (Exception e) {
            System.err.print("Exception caught in test main. Msg: " + e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
        System.out.println("Test Passed. Test file system successfully iterated. Single directory: " + singleDirectory);
        System.out.println("Removing test file system...");
    }

    public static void main(String[] args) {
        try {
            FileSystemCache.runTest(false);
            FileSystemCache.runTest(true);
        }
        catch (Exception e) {
            System.err.print("Exception caught in test main. Msg: " + e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private class CacheFiller
    extends Thread {
        private CacheFiller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean moreObjectsToGet;
            while (FileSystemCache.this.cache.size() >= FileSystemCache.this.requestedSize || (moreObjectsToGet = FileSystemCache.this.fillCache())) {
                CacheFiller cacheFiller = this;
                synchronized (cacheFiller) {
                    this.notifyAll();
                    while (FileSystemCache.this.cache.size() >= FileSystemCache.this.requestedSize / 2) {
                        try {
                            this.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            CacheFiller cacheFiller = this;
            synchronized (cacheFiller) {
                this.notifyAll();
            }
        }
    }
}

