/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.utils.net;

import com.archivas.clienttools.arcutils.config.ConfigurationHelper;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.HCAPProfile;
import com.archivas.clienttools.arcutils.utils.net.GetCertsCallback;
import com.archivas.clienttools.arcutils.utils.net.SSLCertChain;
import com.archivas.clienttools.arcutils.utils.net.SSLCertificateCallback;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;

public class GetCertsX509TrustManager
implements X509TrustManager {
    public static final String PACKAGE_NAME = GetCertsX509TrustManager.class.getPackage().getName();
    public static final String CLASS_FULL_NAME = GetCertsX509TrustManager.class.getName();
    public static final String CLASS_NAME = CLASS_FULL_NAME.substring(PACKAGE_NAME.length() + 1);
    public static Logger LOG = Logger.getLogger(CLASS_FULL_NAME);
    private static File persistedKeystoreFile = null;
    private static char[] persistedKeystorePassword = "password".toCharArray();
    private X509TrustManager standardTrustManager = null;
    private static X509TrustManager persistedTrustManager = null;
    private static KeyStore persistedKeyStore = null;
    private static X509TrustManager memoryTrustManager = null;
    private static KeyStore memoryKeyStore = null;
    private GetCertsCallback callback = null;
    private SSLCertificateCallback sslExceptionCallback = null;
    private String hostname = null;
    private AbstractProfileBase profile = null;
    private static final Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetCertsX509TrustManager(HCAPProfile profile, SSLCertificateCallback sslExceptionCallback) throws NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException {
        this.profile = profile;
        this.hostname = profile.getHostname();
        Object object = LOCK;
        synchronized (object) {
            this.sslExceptionCallback = sslExceptionCallback;
            LOG.log(Level.FINER, "Entering GetCertsX509TrustManager(Keystore, callback)");
            this.initStandardTrustManager(null);
            this.initPersistedTrustManager();
            this.initMemoryTrustManager();
            if (this.standardTrustManager == null && persistedTrustManager == null && memoryTrustManager == null) {
                throw new NoSuchAlgorithmException("no trust manager found");
            }
        }
    }

    public void initStandardTrustManager(KeyStore keystore) throws NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(keystore);
        TrustManager[] trustmanagers = factory.getTrustManagers();
        for (int i = 0; i < trustmanagers.length; ++i) {
            if (!(trustmanagers[i] instanceof X509TrustManager)) continue;
            if (this.standardTrustManager == null) {
                this.standardTrustManager = (X509TrustManager)trustmanagers[i];
            }
            LOG.log(Level.FINER, "standardTrustManager=" + trustmanagers[i]);
        }
    }

    public void initPersistedTrustManager() throws NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException {
        this.initPersistedTrustManager(false);
    }

    public void initPersistedTrustManager(boolean forcereload) throws NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException {
        if (persistedTrustManager != null && !forcereload) {
            return;
        }
        String homedir = System.getProperty("user.home");
        String fileNameTemplate = ConfigurationHelper.USER_CONFIG_DIRECTORY + ConfigurationHelper.getStringProperty("ssl.keystore.filename", "cacerts");
        String fileName = MessageFormat.format(fileNameTemplate, homedir);
        persistedKeystoreFile = new File(fileName);
        try {
            persistedKeyStore = KeyStore.getInstance("JKS");
            try {
                FileInputStream fis = null;
                if (persistedKeystoreFile.exists()) {
                    fis = new FileInputStream(persistedKeystoreFile);
                }
                persistedKeyStore.load(fis, persistedKeystorePassword);
            }
            catch (FileNotFoundException e) {
                LOG.log(Level.WARNING, "Unexpected Exception", e);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Unexpected Exception", e);
            }
            catch (CertificateException e) {
                LOG.log(Level.WARNING, "Unexpected Exception", e);
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(persistedKeyStore);
            TrustManager[] tms = tmf.getTrustManagers();
            for (int i = 0; i < tms.length; ++i) {
                if (!(tms[i] instanceof X509TrustManager)) continue;
                persistedTrustManager = (X509TrustManager)tms[i];
                break;
            }
            LOG.log(Level.FINER, "persistedTrustManager=" + persistedTrustManager);
        }
        catch (KeyStoreException e) {
            LOG.log(Level.WARNING, "Unexpected Exception", e);
            throw e;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.log(Level.WARNING, "Unexpected Exception", e);
            throw e;
        }
        catch (RuntimeException e) {
            LOG.log(Level.WARNING, "Unexpected Exception", e);
            throw e;
        }
    }

    public void initMemoryTrustManager() throws NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException {
        this.initMemoryTrustManager(false);
    }

    public void initMemoryTrustManager(boolean forcereload) throws NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException {
        if (memoryTrustManager != null && !forcereload) {
            return;
        }
        try {
            if (memoryKeyStore == null) {
                memoryKeyStore = KeyStore.getInstance("JKS");
            }
            try {
                memoryKeyStore.load(null, persistedKeystorePassword);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Unexpected Exception", e);
            }
            catch (CertificateException e) {
                LOG.log(Level.WARNING, "Unexpected Exception", e);
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(memoryKeyStore);
            TrustManager[] tms = tmf.getTrustManagers();
            for (int i = 0; i < tms.length; ++i) {
                if (!(tms[i] instanceof X509TrustManager)) continue;
                memoryTrustManager = (X509TrustManager)tms[i];
                break;
            }
            LOG.log(Level.FINER, "MemoryTrustManager=" + memoryTrustManager);
        }
        catch (KeyStoreException e) {
            LOG.log(Level.WARNING, "Unexpected Exception", e);
            throw e;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.log(Level.WARNING, "Unexpected Exception", e);
            throw e;
        }
        catch (RuntimeException e) {
            LOG.log(Level.WARNING, "Unexpected Exception", e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        SSLCertChain certChain = new SSLCertChain(authType, certificates);
        Object object = LOCK;
        synchronized (object) {
            if (this.callback != null) {
                this.callback.callback(certChain);
            }
            try {
                this.standardTrustManager.checkClientTrusted(certificates, authType);
            }
            catch (CertificateException certException) {
                if (this.callback != null) {
                    this.callback.callback(new SSLCertChain(authType, certificates, certException));
                }
                LOG.log(Level.WARNING, "Error checking Client Trust", certException);
                throw certException;
            }
            catch (RuntimeException certException) {
                LOG.log(Level.WARNING, "Error checking Client Trust", certException);
                throw certException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        Object object = LOCK;
        synchronized (object) {
            try {
                if (certificates != null && LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "Server certificate chain:");
                    for (int i = 0; i < certificates.length; ++i) {
                        LOG.log(Level.FINER, "X509Certificate[" + i + "]=" + certificates[i]);
                    }
                }
                this.checkServerTrusted1(certificates, authType);
            }
            catch (CertificateException e) {
                LOG.log(Level.FINEST, "Exception checking trust for certificate.", e);
                throw e;
            }
            catch (RuntimeException e) {
                LOG.log(Level.WARNING, "Unexpected exception checking trust for certificate.", e);
                throw e;
            }
        }
    }

    public String testHostname(String hostname, SSLCertChain certChain) {
        String result = null;
        String testingCN = null;
        try {
            List<X509Certificate> certList = certChain.getCertificateList();
            String[] cnList = new String[certList.size()];
            Iterator<X509Certificate> i = certList.iterator();
            int count = 0;
            while (i.hasNext()) {
                String dn = i.next().getSubjectDN().getName();
                String cn = dn.substring(dn.indexOf("CN=") + 3, dn.indexOf(44));
                if (cn.startsWith("*.")) {
                    cn = cn.substring(2);
                }
                cnList[count] = cn;
                testingCN = cn;
                ++count;
            }
            BrowserCompatHostnameVerifier verifier = new BrowserCompatHostnameVerifier();
            verifier.verify(hostname, cnList, null);
        }
        catch (SSLException e) {
            if (testingCN != null) {
                result = "Host name " + hostname + " is not equal to the certificate issurer's \nhost name " + testingCN;
            }
            LOG.log(Level.FINE, e.getMessage(), e);
        }
        return result;
    }

    public void checkServerTrusted1(X509Certificate[] certificates, String authType) throws CertificateException {
        SSLCertChain certChain = new SSLCertChain(authType, certificates);
        try {
            LOG.log(Level.FINEST, "About to have MemoryTrustManager Test cert: " + certChain);
            memoryTrustManager.checkServerTrusted(certificates, authType);
            LOG.log(Level.FINEST, "MemoryTrustManager Approves of cert: " + certChain);
            if (this.sslExceptionCallback != null) {
                this.sslExceptionCallback.validCertCallback(this.profile, certChain);
            }
            return;
        }
        catch (Exception certException) {
            LOG.log(Level.FINE, "Error checking Server Trust via MemoryTrustManager: " + certException.getMessage());
            LOG.log(Level.FINER, "Error checking Server Trust via MemoryTrustManager", certException);
            try {
                LOG.log(Level.FINEST, "About to have PersistedTrustManager Test cert: " + certChain);
                persistedTrustManager.checkServerTrusted(certificates, authType);
                LOG.log(Level.FINEST, "PersistedTrustManager Approves of cert: " + certChain);
                if (this.sslExceptionCallback != null) {
                    this.sslExceptionCallback.validCertCallback(this.profile, certChain);
                }
                return;
            }
            catch (Exception certException2) {
                LOG.log(Level.FINE, "Error checking Server Trust via PersistedTrustManager: " + certException2.getMessage());
                LOG.log(Level.FINER, "Error checking Server Trust via PersistedTrustManager", certException2);
                try {
                    LOG.log(Level.FINEST, "About to have standardTrustManager Test cert: " + certChain);
                    this.standardTrustManager.checkServerTrusted(certificates, authType);
                    LOG.log(Level.FINEST, "standardTrustManager Approves of cert: " + certChain);
                    if (this.sslExceptionCallback != null) {
                        this.sslExceptionCallback.validCertCallback(this.profile, certChain);
                    }
                }
                catch (CertificateException certException3) {
                    LOG.log(Level.FINE, "Error checking Server Trust via standardTrustManager: " + certException3.getMessage());
                    LOG.log(Level.FINER, "Error checking Server Trust via standardTrustManager", certException3);
                    this.handleCertFailureCallback(certChain, certException3);
                }
                return;
            }
        }
    }

    protected void handleCertFailureCallback(SSLCertChain certChain, CertificateException certException) throws CertificateException {
        String hostNameWarningString = null;
        if (this.hostname != null) {
            hostNameWarningString = this.testHostname(this.hostname, certChain);
        }
        SSLCertificateCallback.AllowSSLCert allowAccess = SSLCertificateCallback.AllowSSLCert.NO;
        certChain.setCertificateException(certException);
        if (this.sslExceptionCallback != null) {
            try {
                allowAccess = this.sslExceptionCallback.exceptionCallback(this.profile, certChain, hostNameWarningString);
                LOG.log(Level.FINE, "SSLExceptionCallback returned from user: " + (Object)((Object)allowAccess));
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Unexpected Exception in SSL Certificate Exception Callback.  Disallowing use of certificate: " + certChain, e);
                allowAccess = SSLCertificateCallback.AllowSSLCert.NO;
            }
        }
        if (allowAccess == SSLCertificateCallback.AllowSSLCert.THIS_SESSION_ONLY) {
            try {
                LOG.log(Level.FINER, "About to store certificate in memory keystore: " + certChain);
                memoryKeyStore.setCertificateEntry(certChain.getIssuedByCommonName(), certChain.getCertificateList().get(0));
                this.initMemoryTrustManager(true);
                LOG.log(Level.FINER, "Successfully stored cert into memory keystore: " + certChain);
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Error saving certificate to memory keystore", e);
            }
        } else if (allowAccess == SSLCertificateCallback.AllowSSLCert.PERMANENTLY_SAVE) {
            try {
                LOG.log(Level.FINER, "About to store certificate in persisted keystore: " + certChain);
                persistedKeyStore.setCertificateEntry(certChain.getIssuedByCommonName(), certChain.getCertificateList().get(0));
                FileOutputStream fos = new FileOutputStream(persistedKeystoreFile);
                persistedKeyStore.store(fos, persistedKeystorePassword);
                this.initPersistedTrustManager(true);
                LOG.log(Level.FINER, "Successfully stored cert into persisted keystore: " + certChain);
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Error saving certificate to persisted keystore", e);
            }
        } else {
            throw certException;
        }
        if (this.sslExceptionCallback != null) {
            this.sslExceptionCallback.validCertCallback(this.profile, certChain);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }
}

