/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.utils.net;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.digest.DigestUtils;

public class SSLCertChain
implements Serializable {
    private static final Logger LOG = Logger.getLogger(SSLCertChain.class.getName());
    private String authType = null;
    private List<X509Certificate> certificateList = null;
    private Exception certificateException = null;

    public SSLCertChain() {
    }

    public SSLCertChain(String authType, ArrayList<X509Certificate> certificateList) {
        this.authType = authType;
        this.certificateList = certificateList;
    }

    public SSLCertChain(String authType, X509Certificate[] certificates) {
        this.authType = authType;
        this.setCertificateList(certificates);
    }

    public SSLCertChain(String authType, X509Certificate[] certificates, Exception certificateException) {
        this.authType = authType;
        this.certificateException = certificateException;
        this.setCertificateList(certificates);
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public List<X509Certificate> getCertificateList() {
        return this.certificateList;
    }

    public void setCertificateList(List<X509Certificate> certificateList) {
        this.certificateList = certificateList;
    }

    public void setCertificateList(X509Certificate[] certificates) {
        this.certificateList = Arrays.asList(certificates);
    }

    public Exception getCertificateException() {
        return this.certificateException;
    }

    public void setCertificateException(Exception certificateException) {
        this.certificateException = certificateException;
    }

    public String toDetailString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SSLCertChain");
        sb.append("{authType='").append(this.authType).append('\'');
        sb.append(", certificateList=").append(this.certificateList);
        sb.append('}');
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SSLCertChain");
        sb.append("{authType='").append(this.authType).append('\'');
        sb.append(", issuedToCN='").append(this.getIssuedToCommonName()).append('\'');
        sb.append(", IssuedByCN='").append(this.getIssuedByCommonName()).append('\'');
        sb.append(", validRangeString='").append(this.getValidRangeString()).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public Map<String, String> getDNInfo(Principal principal) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        StringTokenizer st = new StringTokenizer(principal.getName(), ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            int index = token.indexOf(61);
            if (index > -1) {
                String key = token.substring(0, index).trim();
                String val = token.substring(index + 1).trim();
                map.put(key, val);
                continue;
            }
            LOG.log(Level.WARNING, "Unexpected string parsing error looking for '=' in " + principal.getName());
        }
        return map;
    }

    public Map<String, String> getIssuedToDNInfo() {
        X509Certificate cert = this.getCertificateList().get(0);
        return this.getDNInfo(cert.getSubjectX500Principal());
    }

    public String getIssuedToCommonName() {
        return this.getIssuedToDNInfo().get("CN");
    }

    public String getIssuedToOrganization() {
        return this.getIssuedToDNInfo().get("O");
    }

    public String getIssuedToOrgUnit() {
        return this.getIssuedToDNInfo().get("OU");
    }

    public String getIssuedToLocation() {
        return this.getIssuedToDNInfo().get("L");
    }

    public String getIssuedToState() {
        return this.getIssuedToDNInfo().get("ST");
    }

    public String getIssuedToCountry() {
        return this.getIssuedToDNInfo().get("C");
    }

    public Map<String, String> getIssuedByDNInfo() {
        X509Certificate cert = this.getCertificateList().get(0);
        return this.getDNInfo(cert.getIssuerX500Principal());
    }

    public String getIssuedByCommonName() {
        return this.getIssuedByDNInfo().get("CN");
    }

    public String getIssuedByOrganization() {
        return this.getIssuedByDNInfo().get("O");
    }

    public String getIssuedByOrgUnit() {
        return this.getIssuedByDNInfo().get("OU");
    }

    public String getIssuedByLocation() {
        return this.getIssuedByDNInfo().get("L");
    }

    public String getIssuedByState() {
        return this.getIssuedByDNInfo().get("ST");
    }

    public String getIssuedByCountry() {
        return this.getIssuedByDNInfo().get("C");
    }

    public BigInteger getSerialNumber() {
        X509Certificate cert = this.getCertificateList().get(0);
        return cert.getSerialNumber();
    }

    public String getSerialNumberString() {
        X509Certificate cert = this.getCertificateList().get(0);
        BigInteger sn = cert.getSerialNumber();
        return SSLCertChain.byteArrayToColonSeparatedHexString(sn.toByteArray(), ":");
    }

    public static String byteArrayToHexString(byte[] in) {
        return SSLCertChain.byteArrayToColonSeparatedHexString(in, null);
    }

    public static String byteArrayToColonSeparatedHexString(byte[] in, String separatorStr) {
        byte ch = 0;
        int i = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        StringBuffer out = new StringBuffer(in.length * 2);
        while (i < in.length) {
            ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(pseudo[ch]);
            if (separatorStr == null || ++i >= in.length) continue;
            out.append(separatorStr);
        }
        String rslt = new String(out);
        return rslt;
    }

    public Date getValidNotBefore() {
        X509Certificate cert = this.getCertificateList().get(0);
        return cert.getNotBefore();
    }

    public Date getValidNotAfter() {
        X509Certificate cert = this.getCertificateList().get(0);
        return cert.getNotAfter();
    }

    public String getValidNotBeforeString() {
        return "" + this.getValidNotBefore();
    }

    public String getValidNotAfterString() {
        return "" + this.getValidNotAfter();
    }

    public String getValidRangeString() {
        Date notBefore = this.getValidNotBefore();
        Date notAfter = this.getValidNotAfter();
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");
        return format.format(notBefore) + " to " + format.format(notAfter);
    }

    public String getFingerprint() {
        X509Certificate cert = this.getCertificateList().get(0);
        return new String(cert.getSignature());
    }

    public String getSignatureAlgorithm() {
        X509Certificate cert = this.getCertificateList().get(0);
        return cert.getSigAlgName();
    }

    public String getSignatureString() {
        X509Certificate cert = this.getCertificateList().get(0);
        return SSLCertChain.byteArrayToColonSeparatedHexString(cert.getSignature(), ":");
    }

    public String getPublicKeyAlgorithm() {
        X509Certificate cert = this.getCertificateList().get(0);
        return cert.getPublicKey().getAlgorithm();
    }

    public String getPublicKeyString() {
        X509Certificate cert = this.getCertificateList().get(0);
        return SSLCertChain.byteArrayToColonSeparatedHexString(cert.getPublicKey().getEncoded(), ":");
    }

    public String getMD5FingerprintString() {
        X509Certificate cert = this.getCertificateList().get(0);
        String s = null;
        try {
            s = SSLCertChain.byteArrayToColonSeparatedHexString(DigestUtils.md5((byte[])cert.getTBSCertificate()), ":");
        }
        catch (CertificateEncodingException e) {
            LOG.log(Level.WARNING, "Error generating MD5 Fingerprint for SSL Certificate : " + this.toString());
        }
        return s;
    }

    public String getShaFingerprintString() {
        X509Certificate cert = this.getCertificateList().get(0);
        String s = null;
        try {
            s = SSLCertChain.byteArrayToColonSeparatedHexString(DigestUtils.sha((byte[])cert.getTBSCertificate()), ":");
        }
        catch (CertificateEncodingException e) {
            LOG.log(Level.WARNING, "Error generating MD5 Fingerprint for SSL Certificate : " + this.toString());
        }
        return s;
    }

    public String getValidity() {
        String validity = "The cert is valid";
        try {
            X509Certificate cert = this.getCertificateList().get(0);
            cert.checkValidity();
        }
        catch (CertificateExpiredException e) {
            LOG.log(Level.WARNING, "Unexpected Exception", e);
            validity = e.toString();
        }
        catch (CertificateNotYetValidException e) {
            LOG.log(Level.WARNING, "Unexpected Exception", e);
            validity = e.toString();
        }
        return validity;
    }
}

