/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.utils.net;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class UrlUtils {
    public static final String PACKAGE_NAME = UrlUtils.class.getPackage().getName();
    public static final String CLASS_FULL_NAME = UrlUtils.class.getName();
    public static final String CLASS_NAME = CLASS_FULL_NAME.substring(PACKAGE_NAME.length() + 1);

    public static URL makeURL(String title, String urlString) throws MalformedURLException {
        URL url;
        block11: {
            if (urlString == null) {
                return null;
            }
            if (urlString.trim().length() < 1) {
                return null;
            }
            url = null;
            int i = -1;
            try {
                i = urlString.indexOf(58);
                if (i < 0) {
                    urlString = "file:" + urlString;
                }
                url = new URL(urlString);
            }
            catch (MalformedURLException e) {
                if (i < 0) break block11;
                try {
                    urlString = "file:" + urlString;
                    url = new URL(urlString);
                }
                catch (MalformedURLException e2a) {
                    MalformedURLException e2 = new MalformedURLException(title + ":  Malformed URL `" + urlString + "`");
                    e2.initCause(e);
                    throw e2;
                }
            }
        }
        if (url != null) {
            try {
                URI uri = url.toURI();
                if (uri.isOpaque()) {
                    String currentDir = System.getProperty("user.dir");
                    String path2 = currentDir + System.getProperty("file.separator") + uri.getSchemeSpecificPart();
                    uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), path2, uri.getQuery(), uri.getFragment());
                    uri = uri.normalize();
                    url = uri.toURL();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return url;
    }

    public static URL makeDirectoryURL(String title, String urlString) throws MalformedURLException {
        URL url = UrlUtils.makeURL(title, urlString);
        if (url == null) {
            return null;
        }
        String path = url.getPath();
        if (path != null && !path.endsWith("/")) {
            String filepart = path + "/";
            if (url.getQuery() != null) {
                filepart = filepart + url.getQuery();
            }
            url = new URL(url.getProtocol(), url.getHost(), url.getPort(), filepart);
        }
        return url;
    }
}

