/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.logging;

import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.SAXException;

public class DefaultFormatter
extends SimpleFormatter {
    public static final String lineSeparator = System.getProperty("line.separator");
    static final String DEFAULT_RECORD_FORMAT = "{1,date,MM/dd} {1, time,HH:mm:ss.SSS} {0,number,00000000} {8} at ({5}:{6, number,####}) {7}:{12} {10}" + lineSeparator + "{11}";
    static final String DEFAULT_EXCEPTION_FORMAT = "{1,date,MM/dd} {1, time,HH:mm:ss.SSS} {0,number,00000000} {12,number,000}                  {13} {14}" + lineSeparator + "{15}";
    static final String DEFAULT_STACK_ELEMENT_FORMAT = "{1,date,MM/dd} {1, time,HH:mm:ss.SSS} {0,number,00000000} {12,number,000}                          at {13}.{14}({15}:{16, number,####})" + lineSeparator;
    public static final String DEFAULT_PROGRESS_FORMAT = "{1,date,MM/dd} {1, time,HH:mm:ss.SSS} {10}" + lineSeparator + "{11}";
    final Pattern lineBreak = Pattern.compile("\n");
    static final int otherPartsSize = 12;
    private String format = DEFAULT_RECORD_FORMAT;

    public DefaultFormatter() {
    }

    public DefaultFormatter(String formatOverride) {
        this.format = formatOverride != null ? formatOverride : DEFAULT_RECORD_FORMAT;
    }

    @Override
    public synchronized String format(LogRecord record) {
        Object[] arguments = this.buildParameters(record);
        StringBuffer result = new StringBuffer(100);
        MessageFormat recordFormatter = new MessageFormat(this.format);
        try {
            MessageFormat messageFormatter = new MessageFormat(record.getMessage());
            messageFormatter.format(record.getParameters(), result, (FieldPosition)null);
        }
        catch (IllegalArgumentException e) {
            result.append(record.getMessage());
        }
        List messages = this.split(result);
        int count = messages.size();
        StringBuffer formatedLogRecord = new StringBuffer(100 * count);
        try {
            if (count == 1) {
                arguments[10] = messages.get(0);
                recordFormatter.format(arguments, formatedLogRecord, (FieldPosition)null);
            } else {
                for (int i = 0; i < count; ++i) {
                    String s = Integer.toString(i);
                    arguments[10] = this.getPad(s) + s + " " + messages.get(i);
                    recordFormatter.format(arguments, formatedLogRecord, (FieldPosition)null);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Logging error. Stack trace follows");
            e.printStackTrace();
            return Arrays.asList(arguments).toString() + '\n';
        }
        return formatedLogRecord.toString();
    }

    private Object[] buildParameters(LogRecord record) {
        StackTraceElement frame = DefaultFormatter.getCaller();
        Object[] arguments = new Object[13];
        arguments[0] = new Long(record.getSequenceNumber());
        arguments[1] = new Date(record.getMillis());
        arguments[2] = record.getLoggerName();
        arguments[3] = record.getSourceClassName();
        arguments[4] = record.getSourceMethodName();
        if (frame != null) {
            arguments[5] = frame.getFileName();
            arguments[6] = frame.getLineNumber();
        } else {
            arguments[5] = "";
            arguments[6] = -1;
        }
        arguments[7] = Thread.currentThread().getId();
        arguments[12] = Thread.currentThread().getName();
        arguments[8] = record.getLevel().getName();
        arguments[9] = new Integer(record.getLevel().intValue());
        arguments[11] = this.writeThrowable(arguments, record, 0);
        return arguments;
    }

    public CharSequence writeThrowable(Object[] otherParts, LogRecord record, int index) {
        MessageFormat exceptionFormatter = new MessageFormat(DEFAULT_EXCEPTION_FORMAT);
        MessageFormat stackElementFormatter = new MessageFormat(DEFAULT_STACK_ELEMENT_FORMAT);
        Throwable t = record.getThrown();
        if (t == null) {
            return "";
        }
        assert (otherParts.length >= 12);
        StringBuffer tb = new StringBuffer(1000);
        while (t != null) {
            if (tb.length() > 200000) {
                tb.append("Stack trace too large to completely format\n");
                return tb;
            }
            Object[] throwParts = new Object[16];
            throwParts[12] = new Integer(index++);
            throwParts[13] = t.getClass().getName();
            throwParts[14] = t.getMessage() == null ? "" : t.getMessage();
            StackTraceElement[] elements = t.getStackTrace();
            StringBuffer sb = new StringBuffer(1000);
            for (int i = 0; i < elements.length; ++i) {
                Object[] stackParts = new Object[17];
                stackParts[12] = new Integer(index++);
                stackParts[13] = elements[i].getClassName();
                stackParts[14] = elements[i].getMethodName();
                stackParts[15] = elements[i].getFileName();
                stackParts[16] = new Integer(elements[i].getLineNumber());
                System.arraycopy(otherParts, 0, stackParts, 0, 12);
                stackElementFormatter.format(stackParts, sb, (FieldPosition)null);
            }
            throwParts[15] = sb;
            System.arraycopy(otherParts, 0, throwParts, 0, 12);
            exceptionFormatter.format(throwParts, tb, (FieldPosition)null);
            try {
                if (t instanceof SQLException) {
                    SQLException sqlt = (SQLException)t;
                    t = sqlt.getNextException();
                    continue;
                }
                if (t instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)t).getTargetException();
                    continue;
                }
                if (t instanceof SAXException) {
                    t = ((SAXException)t).getException();
                    continue;
                }
                t = t.getCause();
            }
            catch (NoClassDefFoundError e) {
                System.out.println("cannot find class. backtrace will not be printed " + e);
                t = null;
            }
        }
        return tb;
    }

    public static String dumpThreads() {
        StringBuffer sb = new StringBuffer();
        try {
            ThreadGroup tg = Thread.currentThread().getThreadGroup();
            while (tg.getParent() != null) {
                tg = tg.getParent();
            }
            sb.append("ThreadGroup root: ").append(tg.getName()).append("\n");
            Thread[] threadArray = new Thread[1000];
            tg.enumerate(threadArray, true);
            for (int i = 0; i < threadArray.length; ++i) {
                Thread thread = threadArray[i];
                if (thread == null) continue;
                sb.append("thread ").append(thread.getId()).append(" name=").append(thread.getName()).append("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public List split(CharSequence input) {
        CharSequence match;
        int index = 0;
        ArrayList<CharSequence> matchList = null;
        Matcher m = this.lineBreak.matcher(input);
        while (m.find()) {
            if (m.start() - index < 0) continue;
            if (matchList == null) {
                matchList = new ArrayList<CharSequence>();
            }
            match = input.subSequence(index, m.start());
            matchList.add(match);
            index = m.end();
        }
        if (index == 0) {
            return Collections.singletonList(input);
        }
        match = input.subSequence(index, input.length());
        matchList.add(match);
        return matchList;
    }

    private CharSequence getPad(String s) {
        return s.length() < 3 ? "000".subSequence(0, s.length()) : s;
    }

    protected static StackTraceElement getCaller() {
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (int ix = stack.length - 1; ix >= 0; --ix) {
            StackTraceElement frame = stack[ix];
            String cname = frame.getClassName();
            if (!"com.ris.util.logging.RISLogger".equals(cname) && !"java.util.logging.Logger".equals(cname) && !"com.archivas.logging.DefaultFormatter".equals(cname)) continue;
            return stack[ix + 1];
        }
        return null;
    }
}

