/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.logging;

import com.archivas.clienttools.arcutils.utils.FileUtil;
import java.io.IOException;
import java.util.logging.LogManager;
import org.apache.commons.lang.text.StrBuilder;

public class FileHandler
extends java.util.logging.FileHandler {
    private static String getPattern() {
        String cname;
        LogManager manager = LogManager.getLogManager();
        String pattern = manager.getProperty((cname = FileHandler.class.getName()) + ".pattern");
        if (pattern == null) {
            pattern = "%h/java%u.log";
        }
        return pattern;
    }

    private static int getLimit() {
        LogManager manager = LogManager.getLogManager();
        String cname = FileHandler.class.getName();
        String limitStr = manager.getProperty(cname + ".limit");
        int limit = 10000000;
        if (limitStr != null) {
            limit = Integer.valueOf(limitStr);
        }
        return limit;
    }

    private static int getCount() {
        LogManager manager = LogManager.getLogManager();
        String cname = FileHandler.class.getName();
        String countStr = manager.getProperty(cname + ".count");
        int count = 9;
        if (countStr != null) {
            count = Integer.valueOf(countStr);
        }
        return count;
    }

    private static boolean getAppend() {
        LogManager manager = LogManager.getLogManager();
        String cname = FileHandler.class.getName();
        String appendStr = manager.getProperty(cname + ".append");
        boolean append = true;
        if (appendStr != null) {
            append = Boolean.valueOf(appendStr);
        }
        return append;
    }

    public FileHandler() throws IOException, SecurityException {
        super(FileHandler.buildPattern(FileHandler.getPattern()), FileHandler.getLimit(), FileHandler.getCount(), FileHandler.getAppend());
    }

    public FileHandler(String pattern) throws IOException, SecurityException {
        super(FileHandler.buildPattern(pattern));
    }

    public FileHandler(String pattern, boolean append) throws IOException, SecurityException {
        super(FileHandler.buildPattern(pattern), append);
    }

    public FileHandler(String pattern, int limit, int count) throws IOException, SecurityException {
        super(FileHandler.buildPattern(pattern), limit, count);
    }

    public FileHandler(String pattern, int limit, int count, boolean append) throws IOException, SecurityException {
        super(FileHandler.buildPattern(pattern), limit, count, append);
    }

    protected static String buildPattern(String pattern) {
        if (pattern == null) {
            return null;
        }
        StrBuilder newPattern = new StrBuilder(pattern);
        String applicationHomeDir = System.getProperty("application_home_dir");
        String userHomeDir = System.getProperty("user.home");
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (tmpDir == null) {
            tmpDir = userHomeDir;
        }
        if (applicationHomeDir != null) {
            newPattern = newPattern.replaceAll("%a", applicationHomeDir);
        }
        String retval = newPattern.toString();
        newPattern = newPattern.replaceAll("%t", tmpDir);
        newPattern = newPattern.replaceAll("%h", userHomeDir);
        String logPath = FileUtil.getPath(newPattern.toString());
        FileUtil.mkdirs(logPath);
        return retval;
    }
}

