/*
 * Decompiled with CFR 0.152.
 */
package org.pietschy.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.pietschy.wizard.WizardModel;
import org.pietschy.wizard.WizardStep;

public abstract class AbstractWizardModel
implements WizardModel {
    private WizardStep activeStep;
    private boolean previousAvailable;
    private boolean nextAvailable;
    private boolean lastAvailable;
    private boolean cancelAvailable;
    private boolean lastVisible = true;
    private PropertyChangeSupport pcs;
    private PropertyChangeListener completeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("complete")) {
                AbstractWizardModel.this.refreshModelState();
            }
        }
    };

    public AbstractWizardModel() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public WizardStep getActiveStep() {
        return this.activeStep;
    }

    protected void setActiveStep(WizardStep wizardStep) {
        if (this.activeStep != wizardStep) {
            WizardStep wizardStep2 = this.activeStep;
            this.activeStep = wizardStep;
            this.pcs.firePropertyChange("activeStep", wizardStep2, wizardStep);
            this.refreshModelState();
        }
    }

    public boolean isPreviousAvailable() {
        return this.previousAvailable;
    }

    public boolean isNextAvailable() {
        return this.nextAvailable;
    }

    public boolean isLastAvailable() {
        return this.lastAvailable;
    }

    protected void setPreviousAvailable(boolean bl) {
        if (this.previousAvailable != bl) {
            boolean bl2 = this.previousAvailable;
            this.previousAvailable = bl;
            this.pcs.firePropertyChange("previousAvailable", bl2, bl);
        }
    }

    protected void setNextAvailable(boolean bl) {
        if (this.nextAvailable != bl) {
            boolean bl2 = this.nextAvailable;
            this.nextAvailable = bl;
            this.pcs.firePropertyChange("nextAvailable", bl2, bl);
        }
    }

    protected void setLastAvailable(boolean bl) {
        if (this.lastAvailable != bl) {
            boolean bl2 = this.lastAvailable;
            this.lastAvailable = bl;
            this.pcs.firePropertyChange("lastAvailable", bl2, bl);
        }
    }

    protected void setCancelAvailable(boolean bl) {
        if (this.cancelAvailable != bl) {
            boolean bl2 = this.cancelAvailable;
            this.cancelAvailable = bl;
            this.pcs.firePropertyChange("cancelAvailable", bl2, bl);
        }
    }

    public boolean isLastVisible() {
        return this.lastVisible;
    }

    public void setLastVisible(boolean bl) {
        if (this.lastVisible != bl) {
            boolean bl2 = this.lastVisible;
            this.lastVisible = bl;
            this.pcs.firePropertyChange("lastVisible", bl2, bl);
        }
    }

    public void refreshModelState() {
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    protected void addCompleteListener(WizardStep wizardStep) {
        wizardStep.addPropertyChangeListener(this.completeListener);
    }
}

