/*
 * Decompiled with CFR 0.152.
 */
package org.pietschy.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.pietschy.wizard.Wizard;

public class ButtonBar
extends JPanel {
    public static final int RELATED_GAP = 4;
    public static final int UNRELATED_GAP = 8;
    private Wizard wizard;
    private JButton lastButton;
    private JButton nextButton;
    private JButton previousButton;
    private JButton finishButton;
    private JButton cancelButton;
    private JButton closeButton;
    private JButton helpButton;
    protected Component lastButtonGap = Box.createHorizontalStrut(4);
    protected Component helpButtonGap = Box.createHorizontalStrut(8);

    public ButtonBar(Wizard wizard) {
        this.wizard = wizard;
        this.wizard.getModel().addPropertyChangeListener("lastVisible", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ButtonBar.this.configureLastButton();
            }
        });
        this.wizard.addPropertyChangeListener("helpBroker", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ButtonBar.this.configureHelpButton();
            }
        });
        this.previousButton = new JButton(wizard.getPreviousAction());
        this.nextButton = new JButton(wizard.getNextAction());
        this.nextButton.setHorizontalTextPosition(10);
        this.lastButton = new JButton(wizard.getLastAction());
        this.finishButton = new JButton(wizard.getFinishAction());
        this.cancelButton = new JButton(wizard.getCancelAction());
        this.closeButton = new JButton(wizard.getCloseAction());
        this.helpButton = new JButton(wizard.getHelpAction());
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.showCloseButton(false);
        this.equalizeButtonWidths(this.helpButton, this.previousButton, this.nextButton, this.lastButton, this.finishButton, this.cancelButton, this.closeButton);
        this.layoutButtons(this.helpButton, this.previousButton, this.nextButton, this.lastButton, this.finishButton, this.cancelButton, this.closeButton);
        this.configureLastButton();
        this.configureHelpButton();
    }

    private void configureLastButton() {
        this.setLastVisible(this.wizard.getModel().isLastVisible());
    }

    private void configureHelpButton() {
        this.setHelpVisible(this.wizard.getHelpBroker() != null);
    }

    protected void layoutButtons(JButton jButton, JButton jButton2, JButton jButton3, JButton jButton4, JButton jButton5, JButton jButton6, JButton jButton7) {
        this.setLayout(new BoxLayout(this, 2));
        this.add(jButton);
        this.add(this.helpButtonGap);
        this.add(Box.createHorizontalGlue());
        this.add(jButton2);
        this.add(Box.createHorizontalStrut(4));
        this.add(jButton3);
        this.add(this.lastButtonGap);
        this.add(jButton4);
        this.add(Box.createHorizontalStrut(4));
        this.add(jButton5);
        this.add(Box.createHorizontalStrut(8));
        this.add(jButton6);
        this.add(jButton7);
    }

    protected void equalizeButtonWidths(JButton jButton, JButton jButton2, JButton jButton3, JButton jButton4, JButton jButton5, JButton jButton6, JButton jButton7) {
        int n;
        Dimension dimension = new Dimension();
        JButton[] jButtonArray = new JButton[]{jButton, jButton2, jButton3, jButton4, jButton5, jButton6, jButton7};
        for (n = 0; n < jButtonArray.length; ++n) {
            Dimension dimension2 = jButtonArray[n].getPreferredSize();
            if (dimension2.width > dimension.width) {
                dimension.width = dimension2.width;
            }
            if (dimension2.height <= dimension.height) continue;
            dimension.height = dimension2.height;
        }
        for (n = 0; n < jButtonArray.length; ++n) {
            jButtonArray[n].setPreferredSize(dimension);
        }
    }

    public void showCloseButton(boolean bl) {
        this.previousButton.setVisible(!bl);
        this.nextButton.setVisible(!bl);
        this.lastButton.setVisible(!bl);
        this.finishButton.setVisible(!bl);
        this.cancelButton.setVisible(!bl);
        this.closeButton.setVisible(bl);
    }

    private void setLastVisible(boolean bl) {
        this.lastButton.setVisible(bl);
        this.lastButtonGap.setVisible(bl);
        this.revalidate();
        this.repaint();
    }

    private void setHelpVisible(boolean bl) {
        this.helpButton.setVisible(bl);
        this.helpButtonGap.setVisible(bl);
        this.revalidate();
        this.repaint();
    }
}

