/*
 * Decompiled with CFR 0.152.
 */
package org.pietschy.wizard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.pietschy.wizard.HTMLPane;
import org.pietschy.wizard.Wizard;
import org.pietschy.wizard.WizardModel;
import org.pietschy.wizard.WizardStep;

public class DefaultTitleComponent
extends JPanel {
    private static final Color COLOR_GRAY_230 = new Color(230, 230, 230);
    private JLabel title;
    private JEditorPane summary;
    private JLabel iconLabel;
    private WizardModel model;
    private boolean gradientBackground = false;
    private Color fadeColor = COLOR_GRAY_230;

    protected DefaultTitleComponent(Wizard wizard) {
        this.model = wizard.getModel();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.WHITE);
        this.title = new JLabel();
        this.title.setFont(this.title.getFont().deriveFont(1));
        this.summary = new HTMLPane(false);
        this.summary.setFont(this.title.getFont().deriveFont(0));
        this.summary.setEditable(false);
        this.summary.setEnabled(false);
        this.summary.setForeground(Color.BLACK);
        this.summary.setDisabledTextColor(Color.BLACK);
        this.summary.setBorder(BorderFactory.createEmptyBorder(4, 8, 0, 8));
        this.summary.setText("<html>Blah</html>");
        Dimension dimension = this.summary.getPreferredSize();
        dimension.width = 0;
        dimension.height *= 2;
        this.summary.setPreferredSize(dimension);
        int n = 0;
        int n2 = 0;
        Object object = this.model.stepIterator();
        while (object.hasNext()) {
            Icon icon = ((WizardStep)object.next()).getIcon();
            if (icon == null) continue;
            n2 = Math.max(n2, icon.getIconWidth());
            n = Math.max(n, icon.getIconHeight());
        }
        this.iconLabel = new JLabel();
        object = new Dimension(n2, n);
        this.iconLabel.setMaximumSize((Dimension)object);
        this.iconLabel.setPreferredSize((Dimension)object);
        if (this.iconLabel.getComponentOrientation().isLeftToRight()) {
            this.iconLabel.setHorizontalAlignment(4);
        } else {
            this.iconLabel.setHorizontalAlignment(2);
        }
        this.iconLabel.setVerticalAlignment(0);
        jPanel.add((Component)this.title, "First");
        jPanel.add((Component)this.summary, "Center");
        jPanel.setOpaque(false);
        this.add((Component)jPanel, "Center");
        this.add((Component)this.iconLabel, "After");
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        this.model.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("activeStep")) {
                    WizardStep wizardStep = DefaultTitleComponent.this.model.getActiveStep();
                    DefaultTitleComponent.this.title.setText(wizardStep.getName());
                    DefaultTitleComponent.this.summary.setText(wizardStep.getSummary());
                    DefaultTitleComponent.this.iconLabel.setIcon(wizardStep.getIcon());
                }
            }
        });
    }

    public boolean isGradientBackground() {
        return this.gradientBackground;
    }

    public void setGradientBackground(boolean bl) {
        this.gradientBackground = bl;
    }

    protected void paintComponent(Graphics graphics) {
        if (this.isGradientBackground()) {
            Paint paint = this.prepareGradient();
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint2 = graphics2D.getPaint();
            graphics2D.setPaint(paint);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setPaint(paint2);
        } else {
            super.paintComponent(graphics);
        }
    }

    protected Paint prepareGradient() {
        return new GradientPaint(this.getWidth() / 2, 0.0f, this.getBackground(), this.getWidth(), this.getHeight(), this.getFadeColor());
    }

    private Color getFadeColor() {
        return this.fadeColor;
    }

    public void setFadeColor(Color color) {
        this.fadeColor = color;
    }
}

