/*
 * Decompiled with CFR 0.152.
 */
package org.pietschy.wizard;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;

public class HTMLPane
extends JEditorPane {
    private HTMLEditorKit kit = new HTMLEditorKit();
    private boolean antiAlias = false;
    private boolean forceReload = false;

    public HTMLPane() {
        this(true);
    }

    public HTMLPane(boolean bl) {
        this.setEditorKit(this.kit);
        this.setFont(UIManager.getFont("Label.font"));
        this.updateEditorColor(this.getForeground());
        this.setEditable(false);
        this.setOpaque(bl);
    }

    public URL getPage() {
        if (this.forceReload) {
            this.forceReload = false;
            return null;
        }
        return super.getPage();
    }

    public void setPage(URL uRL) throws IOException {
        this.forceReload = true;
        super.setPage(uRL);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.kit != null) {
            this.updateEditorFont(font);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.kit != null) {
            this.updateEditorColor(color);
        }
    }

    public void setEditorKit(EditorKit editorKit) {
        super.setEditorKit(editorKit);
        this.updateEditorColor(this.getForeground());
        this.updateEditorFont(this.getFont());
    }

    private void updateEditorFont(Font font) {
        StringBuffer stringBuffer = new StringBuffer("body { ");
        stringBuffer.append("font-family: ").append(font.getFamily()).append(";");
        stringBuffer.append(" font-size: ").append(font.getSize()).append("pt;");
        if (font.isBold()) {
            stringBuffer.append("font-weight: 700;");
        }
        if (font.isItalic()) {
            stringBuffer.append("font-style: italic;");
        }
        stringBuffer.append("}");
        this.kit.getStyleSheet().addRule(stringBuffer.toString());
    }

    private void updateEditorColor(Color color) {
        StringBuffer stringBuffer = new StringBuffer("body { color: #");
        if (color.getRed() < 16) {
            stringBuffer.append('0');
        }
        stringBuffer.append(Integer.toHexString(color.getRed()));
        if (color.getGreen() < 16) {
            stringBuffer.append('0');
        }
        stringBuffer.append(Integer.toHexString(color.getGreen()));
        if (color.getBlue() < 16) {
            stringBuffer.append('0');
        }
        stringBuffer.append(Integer.toHexString(color.getBlue()));
        stringBuffer.append(";}");
        this.kit.getStyleSheet().addRule(stringBuffer.toString());
    }

    public boolean isAntiAlias() {
        return this.antiAlias;
    }

    public void paint(Graphics graphics) {
        if (this.antiAlias) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            super.paint(graphics2D);
        } else {
            super.paint(graphics);
        }
    }

    public void setAntiAlias(boolean bl) {
        this.antiAlias = bl;
        this.repaint();
    }
}

