/*
 * Decompiled with CFR 0.152.
 */
package org.pietschy.wizard;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import org.pietschy.wizard.HelpBroker;
import org.pietschy.wizard.I18n;
import org.pietschy.wizard.Wizard;

class HelpAction
extends AbstractAction {
    private Wizard wizard;
    private HelpBroker broker;

    protected HelpAction(Wizard wizard) {
        super(I18n.getString("help.text"));
        this.wizard = wizard;
        this.putValue("MnemonicKey", new Integer(I18n.getMnemonic("help.mnemonic")));
        wizard.addPropertyChangeListener("helpBroker", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HelpAction.this.configureState();
            }
        });
        this.configureState();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        HelpBroker helpBroker = this.wizard.getHelpBroker();
        if (helpBroker != null) {
            helpBroker.activateHelp(this.wizard, this.wizard.getModel());
        }
    }

    private void configureState() {
        this.setEnabled(this.wizard.getHelpBroker() != null);
    }
}

