/*
 * Decompiled with CFR 0.152.
 */
package org.pietschy.wizard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import org.pietschy.wizard.ButtonBar;
import org.pietschy.wizard.CancelAction;
import org.pietschy.wizard.CloseAction;
import org.pietschy.wizard.DefaultTitleComponent;
import org.pietschy.wizard.FinishAction;
import org.pietschy.wizard.HelpAction;
import org.pietschy.wizard.HelpBroker;
import org.pietschy.wizard.LastAction;
import org.pietschy.wizard.NextAction;
import org.pietschy.wizard.OverviewProvider;
import org.pietschy.wizard.PreviousAction;
import org.pietschy.wizard.WizardEvent;
import org.pietschy.wizard.WizardFrameCloser;
import org.pietschy.wizard.WizardListener;
import org.pietschy.wizard.WizardModel;
import org.pietschy.wizard.WizardStep;

public class Wizard
extends JPanel {
    protected static final int BORDER_WIDTH = 8;
    public static final int EXIT_ON_CLOSE = 1;
    public static final int EXIT_ON_FINISH = 2;
    private NextAction nextAction;
    private PreviousAction previousAction;
    private LastAction lastAction;
    private FinishAction finishAction;
    private CancelAction cancelAction;
    private CloseAction closeAction;
    private HelpAction helpAction;
    private HelpBroker helpBroker;
    private WizardStep activeStep;
    private WizardModel model;
    private int defaultExitMode = 1;
    private JComponent titleComponent;
    private ButtonBar buttonBar;
    private JPanel viewPanel;
    private JPanel mainContainer;
    private JPanel overviewContainer;
    private boolean overviewVisible = true;
    private boolean canceled = false;
    private PropertyChangeListener viewListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Wizard.this.handleViewChange();
        }
    };

    public Wizard(WizardModel wizardModel) {
        if (wizardModel == null) {
            throw new NullPointerException("models is null");
        }
        this.model = wizardModel;
        this.model.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("activeStep")) {
                    Wizard.this.handleStepChange();
                }
            }
        });
        this.nextAction = new NextAction(this);
        this.previousAction = new PreviousAction(this);
        this.lastAction = new LastAction(this);
        this.finishAction = new FinishAction(this);
        this.cancelAction = new CancelAction(this);
        this.closeAction = new CloseAction(this);
        this.helpAction = new HelpAction(this);
        Object object = wizardModel.stepIterator();
        while (object.hasNext()) {
            ((WizardStep)object.next()).init(this.model);
        }
        this.setLayout(new BorderLayout());
        this.titleComponent = this.createTitleComponent();
        this.buttonBar = this.createButtonBar();
        this.mainContainer = new JPanel(new BorderLayout());
        this.overviewContainer = new JPanel(new BorderLayout());
        this.viewPanel = new JPanel(new BorderLayout());
        this.viewPanel.setPreferredSize(this.calculatePreferredStepSize());
        this.mainContainer.add((Component)this.titleComponent, "North");
        object = new JPanel(new BorderLayout());
        ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        ((Container)object).add((Component)this.viewPanel, "Center");
        this.mainContainer.add((Component)object, "Center");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JSeparator(0), "North");
        jPanel.add((Component)this.buttonBar, "Center");
        this.mainContainer.add((Component)jPanel, "South");
        if (wizardModel instanceof OverviewProvider) {
            object = new JPanel(new BorderLayout());
            ((JComponent)object).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2), BorderFactory.createEtchedBorder()));
            ((Container)object).add((Component)((OverviewProvider)((Object)wizardModel)).getOverviewComponent(), "Center");
            this.overviewContainer.add((Component)object, "West");
        }
        this.add((Component)this.mainContainer, "Center");
        this.add((Component)this.overviewContainer, "West");
        this.configureOverviewContainer();
        if (wizardModel instanceof HelpBroker) {
            this.setHelpBroker((HelpBroker)((Object)wizardModel));
        }
        this.model.reset();
    }

    public void setDefaultExitMode(int n) {
        if (n != 2 && n != 1) {
            throw new IllegalArgumentException();
        }
        this.defaultExitMode = n;
    }

    public int getDefaultExitMode() {
        return this.defaultExitMode;
    }

    protected JComponent createTitleComponent() {
        return new DefaultTitleComponent(this);
    }

    public JComponent getTitleComponent() {
        return this.titleComponent;
    }

    protected ButtonBar createButtonBar() {
        return new ButtonBar(this);
    }

    public void reset() {
        this.canceled = false;
        this.getModel().reset();
    }

    public WizardModel getModel() {
        return this.model;
    }

    public boolean isOverviewVisible() {
        return this.overviewVisible;
    }

    public void setOverviewVisible(boolean bl) {
        if (this.overviewVisible != bl) {
            boolean bl2 = this.overviewVisible;
            this.overviewVisible = bl;
            this.firePropertyChange("overviewVisible", bl2, bl);
            this.configureOverviewContainer();
        }
    }

    private void configureOverviewContainer() {
        this.overviewContainer.setVisible(this.overviewVisible && this.model instanceof OverviewProvider);
    }

    public void setHelpBroker(HelpBroker helpBroker) {
        HelpBroker helpBroker2 = this.helpBroker;
        this.helpBroker = helpBroker;
        this.firePropertyChange("helpBroker", helpBroker2, helpBroker);
    }

    public HelpBroker getHelpBroker() {
        return this.helpBroker;
    }

    public Action getNextAction() {
        return this.nextAction;
    }

    public Action getPreviousAction() {
        return this.previousAction;
    }

    public Action getLastAction() {
        return this.lastAction;
    }

    public Action getFinishAction() {
        return this.finishAction;
    }

    public Action getCancelAction() {
        return this.cancelAction;
    }

    public Action getHelpAction() {
        return this.helpAction;
    }

    public Action getCloseAction() {
        return this.closeAction;
    }

    protected void showCloseButton() {
        this.buttonBar.showCloseButton(true);
    }

    public void cancel() {
        WizardStep wizardStep = this.getModel().getActiveStep();
        if (wizardStep != null && wizardStep.isBusy()) {
            if (!this.confirmAbort()) {
                return;
            }
            wizardStep.abortBusy();
        }
        this.canceled = true;
        this.fireWizardCancelled();
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    protected boolean confirmAbort() {
        int n = JOptionPane.showConfirmDialog(this, "Cancel the currently active task?", "Abort", 1);
        return n == 0;
    }

    public void close() {
        this.fireWizardClosed();
    }

    public void addWizardListener(WizardListener wizardListener) {
        this.listenerList.add(WizardListener.class, wizardListener);
    }

    public void removeWizardListener(WizardListener wizardListener) {
        this.listenerList.remove(WizardListener.class, wizardListener);
    }

    private void handleStepChange() {
        if (this.activeStep != null) {
            this.activeStep.removePropertyChangeListener("view", this.viewListener);
        }
        this.activeStep = this.model.getActiveStep();
        this.activeStep.addPropertyChangeListener("view", this.viewListener);
        this.activeStep.prepare();
        this.handleViewChange();
    }

    private void handleViewChange() {
        this.viewPanel.removeAll();
        this.viewPanel.add(this.activeStep.getView(), "Center");
        this.viewPanel.revalidate();
        this.viewPanel.repaint();
    }

    private Dimension calculatePreferredStepSize() {
        int n = 0;
        int n2 = 0;
        Iterator iterator = this.getModel().stepIterator();
        while (iterator.hasNext()) {
            WizardStep wizardStep = (WizardStep)iterator.next();
            Dimension dimension = wizardStep.getPreferredSize();
            n = Math.max(dimension.width, n);
            n2 = Math.max(dimension.height, n2);
        }
        return new Dimension(n, n2);
    }

    private void fireWizardClosed() {
        Object[] objectArray = this.listenerList.getListenerList();
        WizardEvent wizardEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$org$pietschy$wizard$WizardListener == null ? Wizard.class$("org.pietschy.wizard.WizardListener") : class$org$pietschy$wizard$WizardListener)) continue;
            if (wizardEvent == null) {
                wizardEvent = new WizardEvent(this);
            }
            ((WizardListener)objectArray[i + 1]).wizardClosed(wizardEvent);
        }
    }

    private void fireWizardCancelled() {
        Object[] objectArray = this.listenerList.getListenerList();
        WizardEvent wizardEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$org$pietschy$wizard$WizardListener == null ? Wizard.class$("org.pietschy.wizard.WizardListener") : class$org$pietschy$wizard$WizardListener)) continue;
            if (wizardEvent == null) {
                wizardEvent = new WizardEvent(this);
            }
            ((WizardListener)objectArray[i + 1]).wizardCancelled(wizardEvent);
        }
    }

    public void showInFrame(String string) {
        this.showInFrame(string, null, null);
    }

    public void showInFrame(String string, Image image) {
        this.showInFrame(string, image, null);
    }

    public void showInFrame(String string, Component component) {
        this.showInFrame(string, null, component);
    }

    public void showInFrame(String string, Image image, Component component) {
        JFrame jFrame = new JFrame(string);
        jFrame.setIconImage(image);
        this.showInWindow(jFrame, component);
    }

    public void showInDialog(String string, Component component, boolean bl) {
        JDialog jDialog = null;
        if (component != null) {
            Window window;
            Window window2 = window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
            if (window instanceof Frame) {
                jDialog = new JDialog((Frame)window, string, bl);
            } else if (window instanceof Dialog) {
                jDialog = new JDialog((Dialog)window, string, bl);
            } else {
                throw new IllegalArgumentException("Parent component must be within a Frame or Dialog");
            }
            jDialog = component instanceof Window ? this.createDialogFor((Window)component, string, bl) : this.createDialogFor(SwingUtilities.getWindowAncestor(component), string, bl);
        } else {
            jDialog = new JDialog();
            jDialog.setModal(bl);
            jDialog.setTitle(string);
        }
        jDialog.setLocationRelativeTo(component);
        this.showInWindow(jDialog, component);
    }

    private JDialog createDialogFor(Window window, String string, boolean bl) {
        if (window == null) {
            throw new NullPointerException("window is null");
        }
        JDialog jDialog = null;
        if (window instanceof Frame) {
            jDialog = new JDialog((Frame)window, string, bl);
        } else if (window instanceof Dialog) {
            jDialog = new JDialog((Dialog)window, string, bl);
        }
        return jDialog;
    }

    private void showInWindow(Window window, Component component) {
        ((RootPaneContainer)((Object)window)).getContentPane().add(this);
        window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Wizard.this.cancel();
            }
        });
        WizardFrameCloser.bind(this, window);
        window.pack();
        window.setLocationRelativeTo(component);
        window.setVisible(true);
        window.toFront();
    }

    private class OverviewBorder
    extends AbstractBorder {
        private int width = 5;
        private Insets insets = new Insets(0, 0, 0, 2);

        private OverviewBorder() {
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.setColor(Color.BLACK);
            graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4);
            graphics.setColor(color);
        }

        public Insets getBorderInsets(Component component) {
            return this.insets;
        }
    }
}

