/*
 * Decompiled with CFR 0.152.
 */
package org.pietschy.wizard;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.pietschy.wizard.I18n;
import org.pietschy.wizard.InvalidStateException;
import org.pietschy.wizard.Wizard;
import org.pietschy.wizard.WizardModel;
import org.pietschy.wizard.WizardStep;

public abstract class WizardAction
extends AbstractAction
implements PropertyChangeListener {
    protected Wizard wizard;
    private WizardStep activeStep;

    protected WizardAction(String string, Wizard wizard, Icon icon) {
        this(string, wizard);
        this.putValue("SmallIcon", icon);
    }

    protected WizardAction(String string, Wizard wizard) {
        super(I18n.getString(string + ".text"));
        this.wizard = wizard;
        this.getModel().addPropertyChangeListener(this);
        this.activeStep = this.getModel().getActiveStep();
        if (this.activeStep != null) {
            this.activeStep.addPropertyChangeListener(this);
        }
        this.putValue("MnemonicKey", new Integer(I18n.getMnemonic(string + ".mnemonic")));
        this.updateState();
    }

    protected Wizard getWizard() {
        return this.wizard;
    }

    public WizardModel getModel() {
        return this.getWizard().getModel();
    }

    public WizardStep getActiveStep() {
        return this.activeStep;
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        try {
            this.doAction(actionEvent);
        }
        catch (InvalidStateException invalidStateException) {
            this.handleInvalideStateException(invalidStateException);
        }
    }

    protected void handleInvalideStateException(InvalidStateException invalidStateException) {
        if (invalidStateException.isShowUser()) {
            JOptionPane.showMessageDialog(this.getWizard(), invalidStateException.getMessage(), "Error", 1);
        }
    }

    public abstract void doAction(ActionEvent var1) throws InvalidStateException;

    protected abstract void updateState();

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("activeStep")) {
            if (this.activeStep != null) {
                this.activeStep.removePropertyChangeListener(this);
            }
            this.activeStep = (WizardStep)propertyChangeEvent.getNewValue();
            this.activeStep.addPropertyChangeListener(this);
        }
        this.updateState();
    }
}

