/*
 * Decompiled with CFR 0.152.
 */
package org.pietschy.wizard.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Stack;
import org.pietschy.wizard.AbstractWizardModel;
import org.pietschy.wizard.WizardModel;
import org.pietschy.wizard.WizardStep;
import org.pietschy.wizard.models.Condition;

public class DynamicModel
extends AbstractWizardModel {
    public static final Condition TRUE_CONDITION = new Condition(){

        public boolean evaluate(WizardModel wizardModel) {
            return true;
        }
    };
    private ArrayList steps = new ArrayList();
    private ArrayList conditions = new ArrayList();
    private Stack history = new Stack();

    public void add(WizardStep wizardStep) {
        if (wizardStep instanceof Condition) {
            this.add(wizardStep, (Condition)((Object)wizardStep));
        } else {
            this.add(wizardStep, TRUE_CONDITION);
        }
    }

    public void add(WizardStep wizardStep, Condition condition) {
        this.addCompleteListener(wizardStep);
        this.steps.add(wizardStep);
        this.conditions.add(condition);
    }

    public void nextStep() {
        WizardStep wizardStep = this.getActiveStep();
        this.history.push(wizardStep);
        this.setActiveStep(this.findNextVisibleStep(wizardStep));
    }

    public void previousStep() {
        WizardStep wizardStep = (WizardStep)this.history.pop();
        this.setActiveStep(wizardStep);
    }

    public void lastStep() {
        WizardStep wizardStep = this.getActiveStep();
        this.history.push(wizardStep);
        this.setActiveStep(this.findLastStep());
    }

    public void reset() {
        this.history.clear();
        this.setActiveStep(this.findNextVisibleStep(null));
    }

    public boolean isLastStep(WizardStep wizardStep) {
        return this.findLastStep().equals(wizardStep);
    }

    public void refreshModelState() {
        WizardStep wizardStep = this.getActiveStep();
        this.setNextAvailable(wizardStep != null && wizardStep.isComplete() && !this.isLastStep(wizardStep));
        this.setPreviousAvailable(wizardStep != null && !this.history.isEmpty());
        this.setLastAvailable(wizardStep != null && this.allStepsComplete() && !this.isLastStep(wizardStep));
        this.setCancelAvailable(true);
    }

    public boolean allStepsComplete() {
        for (int i = 0; i < this.steps.size(); ++i) {
            WizardStep wizardStep = (WizardStep)this.steps.get(i);
            Condition condition = (Condition)this.conditions.get(i);
            if (!condition.evaluate(this) || wizardStep.isComplete()) continue;
            return false;
        }
        return true;
    }

    public Iterator stepIterator() {
        return Collections.unmodifiableList(this.steps).iterator();
    }

    private WizardStep findNextVisibleStep(WizardStep wizardStep) {
        int n;
        for (int i = n = wizardStep == null ? 0 : this.steps.indexOf(wizardStep) + 1; i < this.conditions.size(); ++i) {
            Condition condition = (Condition)this.conditions.get(i);
            if (!condition.evaluate(this)) continue;
            return (WizardStep)this.steps.get(i);
        }
        throw new IllegalStateException("Wizard contains no more visible steps");
    }

    private WizardStep findLastStep() {
        for (int i = this.conditions.size() - 1; i >= 0; --i) {
            Condition condition = (Condition)this.conditions.get(i);
            if (!condition.evaluate(this)) continue;
            return (WizardStep)this.steps.get(i);
        }
        throw new IllegalStateException("Wizard contains no visible steps");
    }
}

