/*
 * Decompiled with CFR 0.152.
 */
package org.pietschy.wizard.models;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.pietschy.wizard.AbstractWizardModel;
import org.pietschy.wizard.WizardStep;
import org.pietschy.wizard.models.AbstractPathVisitor;
import org.pietschy.wizard.models.BranchingPath;
import org.pietschy.wizard.models.Path;
import org.pietschy.wizard.models.SimplePath;

public class MultiPathModel
extends AbstractWizardModel {
    private Path firstPath;
    private Path lastPath;
    private Map pathMapping;
    private Stack history = new Stack();

    public MultiPathModel(Path path) {
        this.firstPath = path;
        PathMapVisitor pathMapVisitor = new PathMapVisitor();
        path.acceptVisitor(pathMapVisitor);
        this.pathMapping = pathMapVisitor.getMap();
        LastPathVisitor lastPathVisitor = new LastPathVisitor();
        path.acceptVisitor(lastPathVisitor);
        this.lastPath = lastPathVisitor.getPath();
        if (this.lastPath == null) {
            throw new IllegalStateException("Unable to locate last path");
        }
        Iterator iterator = this.pathMapping.keySet().iterator();
        while (iterator.hasNext()) {
            this.addCompleteListener((WizardStep)iterator.next());
        }
    }

    public Path getFirstPath() {
        return this.firstPath;
    }

    public Path getLastPath() {
        return this.lastPath;
    }

    public void nextStep() {
        WizardStep wizardStep = this.getActiveStep();
        Path path = this.getPathForStep(wizardStep);
        if (path.isLastStep(wizardStep)) {
            Path path2 = path.getNextPath(this);
            this.setActiveStep(path2.firstStep());
        } else {
            this.setActiveStep(path.nextStep(wizardStep));
        }
        this.history.push(wizardStep);
    }

    public void previousStep() {
        WizardStep wizardStep = (WizardStep)this.history.pop();
        this.setActiveStep(wizardStep);
    }

    public void lastStep() {
        this.history.push(this.getActiveStep());
        WizardStep wizardStep = this.getLastPath().lastStep();
        this.setActiveStep(wizardStep);
    }

    public void reset() {
        this.history.clear();
        WizardStep wizardStep = this.firstPath.firstStep();
        this.setActiveStep(wizardStep);
        this.history.push(wizardStep);
    }

    public boolean isLastStep(WizardStep wizardStep) {
        Path path = this.getPathForStep(wizardStep);
        return path.equals(this.getLastPath()) && path.isLastStep(wizardStep);
    }

    public void refreshModelState() {
        WizardStep wizardStep = this.getActiveStep();
        Path path = this.getPathForStep(wizardStep);
        this.setNextAvailable(wizardStep.isComplete() && !this.isLastStep(wizardStep));
        this.setPreviousAvailable(!path.equals(this.firstPath) || !path.isFirstStep(wizardStep));
        this.setLastAvailable(this.allStepsComplete() && !this.isLastStep(wizardStep));
        this.setCancelAvailable(true);
    }

    public boolean allStepsComplete() {
        Iterator iterator = this.stepIterator();
        while (iterator.hasNext()) {
            if (((WizardStep)iterator.next()).isComplete()) continue;
            return false;
        }
        return true;
    }

    public Iterator stepIterator() {
        return this.pathMapping.keySet().iterator();
    }

    protected Path getPathForStep(WizardStep wizardStep) {
        return (Path)this.pathMapping.get(wizardStep);
    }

    private class PathMapVisitor
    extends AbstractPathVisitor {
        private HashMap map = new HashMap();

        public void visitPath(SimplePath simplePath) {
            if (this.enter(simplePath)) {
                this.populateMap(simplePath);
                simplePath.visitNextPath(this);
            }
        }

        public void visitPath(BranchingPath branchingPath) {
            if (this.enter(branchingPath)) {
                this.populateMap(branchingPath);
                branchingPath.visitBranches(this);
            }
        }

        private void populateMap(Path path) {
            Iterator iterator = path.getSteps().iterator();
            while (iterator.hasNext()) {
                WizardStep wizardStep = (WizardStep)iterator.next();
                this.map.put(wizardStep, path);
            }
        }

        public Map getMap() {
            return this.map;
        }
    }

    private class LastPathVisitor
    extends AbstractPathVisitor {
        private Path last;

        private LastPathVisitor() {
        }

        public void visitPath(SimplePath simplePath) {
            if (this.enter(simplePath)) {
                if (simplePath.getNextPath() == null) {
                    if (this.last != null) {
                        throw new IllegalStateException("Two paths have empty values for nextPath");
                    }
                    this.last = simplePath;
                } else {
                    simplePath.visitNextPath(this);
                }
            }
        }

        public void visitPath(BranchingPath branchingPath) {
            if (this.enter(branchingPath)) {
                branchingPath.visitBranches(this);
            }
        }

        public Path getPath() {
            return this.last;
        }
    }
}

