/*
 * Decompiled with CFR 0.152.
 */
package org.pietschy.wizard.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComponent;
import org.pietschy.wizard.AbstractWizardModel;
import org.pietschy.wizard.OverviewProvider;
import org.pietschy.wizard.WizardStep;
import org.pietschy.wizard.models.StaticModelOverview;

public class StaticModel
extends AbstractWizardModel
implements OverviewProvider {
    private ArrayList steps = new ArrayList();
    private int currentStep = 0;
    private StaticModelOverview overviewComponent;

    public void reset() {
        this.currentStep = 0;
        this.setActiveStep((WizardStep)this.steps.get(this.currentStep));
    }

    public void nextStep() {
        if (this.currentStep >= this.steps.size() - 1) {
            throw new IllegalStateException("Already on last step");
        }
        ++this.currentStep;
        this.setActiveStep((WizardStep)this.steps.get(this.currentStep));
    }

    public void previousStep() {
        if (this.currentStep == 0) {
            throw new IllegalStateException("Already at first step");
        }
        --this.currentStep;
        this.setActiveStep((WizardStep)this.steps.get(this.currentStep));
    }

    public void lastStep() {
        this.currentStep = this.steps.size() - 1;
        this.setActiveStep((WizardStep)this.steps.get(this.currentStep));
    }

    public boolean isLastStep(WizardStep wizardStep) {
        return this.steps.indexOf(wizardStep) == this.steps.size() - 1;
    }

    public Iterator stepIterator() {
        return Collections.unmodifiableList(this.steps).iterator();
    }

    public void add(WizardStep wizardStep) {
        this.steps.add(wizardStep);
        this.addCompleteListener(wizardStep);
    }

    public void refreshModelState() {
        this.setNextAvailable(this.getActiveStep().isComplete() && !this.isLastStep(this.getActiveStep()));
        this.setPreviousAvailable(this.currentStep > 0);
        this.setLastAvailable(this.allStepsComplete() && !this.isLastStep(this.getActiveStep()));
        this.setCancelAvailable(true);
    }

    public boolean allStepsComplete() {
        Iterator iterator = this.steps.iterator();
        while (iterator.hasNext()) {
            if (((WizardStep)iterator.next()).isComplete()) continue;
            return false;
        }
        return true;
    }

    public JComponent getOverviewComponent() {
        if (this.overviewComponent == null) {
            this.overviewComponent = new StaticModelOverview(this);
        }
        return this.overviewComponent;
    }
}

