/*
 * Decompiled with CFR 0.152.
 */
package org.pietschy.wizard.models;

import java.awt.Color;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.pietschy.wizard.I18n;
import org.pietschy.wizard.WizardStep;
import org.pietschy.wizard.models.StaticModel;

public class StaticModelOverview
extends JPanel
implements PropertyChangeListener {
    private StaticModel model;
    private HashMap labels = new HashMap();

    public StaticModelOverview(StaticModel staticModel) {
        this.model = staticModel;
        this.model.addPropertyChangeListener(this);
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setLayout(new BoxLayout(this, 3));
        JLabel jLabel = new JLabel(I18n.getString("StaticModelOverview.title"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 4, 4));
        jLabel.setAlignmentX(0.0f);
        jLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, jLabel.getMaximumSize().height));
        this.add(jLabel);
        int n = 1;
        Iterator iterator = staticModel.stepIterator();
        while (iterator.hasNext()) {
            WizardStep wizardStep = (WizardStep)iterator.next();
            JLabel jLabel2 = new JLabel("" + n++ + ". " + wizardStep.getName());
            jLabel2.setBackground(new Color(240, 240, 240));
            jLabel2.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
            jLabel2.setAlignmentX(0.0f);
            jLabel2.setMaximumSize(new Dimension(Integer.MAX_VALUE, jLabel2.getMaximumSize().height));
            this.add(jLabel2);
            this.labels.put(wizardStep, jLabel2);
        }
        this.add(Box.createGlue());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("activeStep")) {
            JLabel jLabel = (JLabel)this.labels.get(propertyChangeEvent.getOldValue());
            if (jLabel != null) {
                this.formatInactive(jLabel);
            }
            JLabel jLabel2 = (JLabel)this.labels.get(propertyChangeEvent.getNewValue());
            this.formatActive(jLabel2);
            this.repaint();
        }
    }

    protected void formatActive(JLabel jLabel) {
        jLabel.setOpaque(true);
    }

    protected void formatInactive(JLabel jLabel) {
        jLabel.setOpaque(false);
    }
}

