/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vm.console.storageV1.impl;

import com.huawei.vm.console.storageV1.impl.FloppyDriver;
import com.huawei.vm.console.utilsV1.ImageIO;
import com.huawei.vm.console.utilsV1.TestPrint;
import com.huawei.vm.console.utilsV1.VMException;
import de.tu_darmstadt.informatik.rbg.bstickler.udflib.UDFExtendFile;
import java.util.Map;

public class FloppyImage
extends FloppyDriver {
    private ImageIO image = new ImageIO();
    private ImageIO newImage = null;

    public FloppyImage(String path, boolean isMustExist) throws VMException {
        super(path);
        this.mustExist = isMustExist;
        this.image.open(this.deviceName, this.mustExist, true);
        this.validCapacity(this.image);
    }

    private void validCapacity(ImageIO image) throws VMException {
        if ((long)(this.getBlockLength() * this.getTotalBlocks()) != image.getMediumSize()) {
            try {
                this.image.close();
            }
            catch (VMException e) {
                TestPrint.println(1, "Floppy Image:close error");
            }
            throw new VMException(335);
        }
    }

    @Override
    protected void open(String path) throws VMException {
        this.image.open(path, this.mustExist, true);
    }

    @Override
    public boolean isWriteProtect() {
        return super.isWriteProtect() || !this.image.canWrite();
    }

    @Override
    public void formatUnit(int mediumType, int startCylinderNumber, int endCylinderNumber, int startHeadNumber, int endHeadNumber) {
    }

    @Override
    public void write(byte[] dataBuffer, long startPosition, int length) throws VMException {
        if (this.isWriteProtect()) {
            throw new VMException(254);
        }
        this.image.write(dataBuffer, startPosition, length);
    }

    @Override
    public void inquiry() {
    }

    @Override
    public int read(byte[] dataBuffer, long startPosition, int length) throws VMException {
        return this.image.read(dataBuffer, startPosition, length);
    }

    @Override
    public long getMediumSize() throws VMException {
        long size = this.image.getMediumSize();
        if (0L > size) {
            throw new VMException(253);
        }
        return size;
    }

    @Override
    public void close() throws VMException {
        this.image.close();
    }

    @Override
    protected void prepareChangeDisk(String localDirName, Map<Long, UDFExtendFile> memoryStructMap, String diskName) throws VMException {
        this.newImage = new ImageIO();
        this.newImage.open(diskName, true, true);
        this.validCapacity(this.newImage);
    }

    @Override
    public void eject() {
        try {
            this.setDeviceState(0);
            this.deviceName = null;
            this.needInit = false;
            this.close();
        }
        catch (VMException e) {
            TestPrint.println(3, "Image file close fail!");
        }
    }

    @Override
    public void insert() throws VMException {
        if (null != this.newImage) {
            this.image = this.newImage;
            this.newImage = null;
            this.setDeviceState(0);
            this.deviceName = this.newDiskName;
            this.newDiskName = null;
        }
        this.needInit = true;
    }

    @Override
    public boolean isInited() {
        return this.image.isActive() && this.needInit;
    }
}

