/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.informatik.rbg.bstickler.udflib.handler;

import de.tu_darmstadt.informatik.rbg.mhartle.sabre.ContentHandler;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.DataReference;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.HandlerException;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.StructureHandler;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.impl.ByteArrayDataReference;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.impl.ChainingStreamHandler;

public class PaddingHandler
extends ChainingStreamHandler {
    private int blockSize = 2048;
    private long currentPosition = 0L;

    public PaddingHandler(StructureHandler myStructureHandler, ContentHandler myContentHandler) {
        super(myStructureHandler, myContentHandler);
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    @Override
    public void data(DataReference myDataReference) throws HandlerException {
        this.currentPosition += myDataReference.getLength();
        super.data(myDataReference);
    }

    @Override
    public void endElement() throws HandlerException {
        if (this.currentPosition % (long)this.blockSize != 0L) {
            int paddingLength = this.blockSize - (int)(this.currentPosition % (long)this.blockSize);
            super.isEndOver(true);
            super.isDataOver(true);
            super.data(new ByteArrayDataReference(new byte[paddingLength]));
            this.currentPosition += (long)paddingLength;
        } else {
            super.isEndOver(true);
            super.data(new ByteArrayDataReference(new byte[0]));
        }
        super.endElement();
    }
}

