/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import com.apple.laf.AquaComboBoxUI;
import com.apple.laf.AquaFocusHandler;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaUtilControlSize;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.DefaultButtonModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

class AquaComboBoxButton
extends JButton {
    protected final JComboBox comboBox;
    protected final JList list;
    protected final CellRendererPane rendererPane;
    protected final AquaComboBoxUI ui;
    protected final AquaPainter<JRSUIState> painter = AquaPainter.create(JRSUIState.getInstance());
    boolean isPopDown;
    boolean isSquare;

    protected AquaComboBoxButton(AquaComboBoxUI aquaComboBoxUI, JComboBox jComboBox, CellRendererPane cellRendererPane, JList jList) {
        super("");
        this.putClientProperty("JButton.buttonType", "comboboxInternal");
        this.ui = aquaComboBoxUI;
        this.comboBox = jComboBox;
        this.rendererPane = cellRendererPane;
        this.list = jList;
        this.setModel(new DefaultButtonModel(){

            @Override
            public void setArmed(boolean bl) {
                super.setArmed(this.isPressed() ? true : bl);
            }
        });
        this.setEnabled(jComboBox.isEnabled());
    }

    @Override
    public boolean isEnabled() {
        return this.comboBox == null ? true : this.comboBox.isEnabled();
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    protected void setIsPopDown(boolean bl) {
        this.isPopDown = bl;
        this.repaint();
    }

    protected void setIsSquare(boolean bl) {
        this.isSquare = bl;
        this.repaint();
    }

    protected JRSUIConstants.State getState(ButtonModel buttonModel) {
        if (!this.comboBox.isEnabled()) {
            return JRSUIConstants.State.DISABLED;
        }
        if (!AquaFocusHandler.isActive(this.comboBox)) {
            return JRSUIConstants.State.INACTIVE;
        }
        if (buttonModel.isArmed()) {
            return JRSUIConstants.State.PRESSED;
        }
        return JRSUIConstants.State.ACTIVE;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        boolean bl = this.comboBox.isEditable();
        int n = 0;
        int n2 = 0;
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (this.comboBox.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n3, n4);
        }
        JRSUIConstants.Size size = AquaUtilControlSize.getUserSizeFrom(this.comboBox);
        ((JRSUIState)this.painter.state).set(size == null ? JRSUIConstants.Size.REGULAR : size);
        ButtonModel buttonModel = this.getModel();
        ((JRSUIState)this.painter.state).set(this.getState(buttonModel));
        ((JRSUIState)this.painter.state).set(JRSUIConstants.AlignmentVertical.CENTER);
        if (AquaComboBoxUI.isTableCellEditor(this.comboBox)) {
            ((JRSUIState)this.painter.state).set(JRSUIConstants.AlignmentHorizontal.RIGHT);
            ((JRSUIState)this.painter.state).set(JRSUIConstants.Widget.BUTTON_POP_UP);
            ((JRSUIState)this.painter.state).set(JRSUIConstants.ArrowsOnly.YES);
            this.painter.paint(graphics, this, n2, n, n3, n4);
            this.doRendererPaint(graphics, buttonModel, bl, this.getInsets(), n2, n, n3, n4);
            return;
        }
        ((JRSUIState)this.painter.state).set(JRSUIConstants.AlignmentHorizontal.CENTER);
        Insets insets = this.getInsets();
        if (!bl) {
            n += insets.top;
            n2 += insets.left;
            n3 -= insets.left + insets.right;
            n4 -= insets.top + insets.bottom;
        }
        if (n4 <= 0 || n3 <= 0) {
            return;
        }
        boolean bl2 = this.comboBox.hasFocus();
        if (bl) {
            ((JRSUIState)this.painter.state).set(JRSUIConstants.Widget.BUTTON_COMBO_BOX);
            ((JRSUIState)this.painter.state).set(JRSUIConstants.IndicatorOnly.YES);
            ((JRSUIState)this.painter.state).set(JRSUIConstants.AlignmentHorizontal.LEFT);
            bl2 |= this.comboBox.getEditor().getEditorComponent().hasFocus();
        } else {
            ((JRSUIState)this.painter.state).set(JRSUIConstants.IndicatorOnly.NO);
            ((JRSUIState)this.painter.state).set(JRSUIConstants.AlignmentHorizontal.CENTER);
            if (this.isPopDown) {
                ((JRSUIState)this.painter.state).set(this.isSquare ? JRSUIConstants.Widget.BUTTON_POP_DOWN_SQUARE : JRSUIConstants.Widget.BUTTON_POP_DOWN);
            } else {
                ((JRSUIState)this.painter.state).set(this.isSquare ? JRSUIConstants.Widget.BUTTON_POP_UP_SQUARE : JRSUIConstants.Widget.BUTTON_POP_UP);
            }
        }
        ((JRSUIState)this.painter.state).set(bl2 ? JRSUIConstants.Focused.YES : JRSUIConstants.Focused.NO);
        if (this.isSquare) {
            this.painter.paint(graphics, this.comboBox, n2 + 2, n - 1, n3 - 4, n4);
        } else {
            this.painter.paint(graphics, this.comboBox, n2, n, n3, n4);
        }
        if (!bl && this.comboBox != null) {
            this.doRendererPaint(graphics, buttonModel, bl, insets, n2, n, n3, n4);
        }
    }

    protected void doRendererPaint(Graphics graphics, ButtonModel buttonModel, boolean bl, Insets insets, int n, int n2, int n3, int n4) {
        ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
        Component component = listCellRenderer.getListCellRendererComponent(this.list, this.comboBox.getSelectedItem(), -1, false, false);
        if (!bl && !AquaComboBoxUI.isTableCellEditor(this.comboBox)) {
            ++n2;
            n4 -= 4;
            n += 10;
            n3 -= 34;
        }
        component.setFont(this.rendererPane.getFont());
        if (buttonModel.isArmed() && buttonModel.isPressed()) {
            if (this.isOpaque()) {
                component.setBackground(UIManager.getColor("Button.select"));
            }
            component.setForeground(this.comboBox.getForeground());
        } else if (!this.comboBox.isEnabled()) {
            if (this.isOpaque()) {
                component.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
            }
            component.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
        } else {
            component.setForeground(this.comboBox.getForeground());
            component.setBackground(this.comboBox.getBackground());
        }
        boolean bl2 = false;
        if (component instanceof JPanel) {
            bl2 = true;
        }
        int n5 = n3 - (insets.right + 0);
        n2 = n4 / 2 - 8;
        n4 = 19;
        Color color = component.getBackground();
        boolean bl3 = color instanceof UIResource;
        if (bl3) {
            component.setBackground(new Color(0, 0, 0, 0));
        }
        this.rendererPane.paintComponent(graphics, component, this, n, n2, n5, n4, bl2);
        if (bl3) {
            component.setBackground(color);
        }
    }
}

