/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.sun.org.apache.xml.internal.security.utils.UnsyncBufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.jcp.xml.dsig.internal.dom.DOMCanonicalizationMethod;
import org.jcp.xml.dsig.internal.dom.DOMReference;
import org.jcp.xml.dsig.internal.dom.DOMSignatureMethod;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMSubTreeData;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.jcp.xml.dsig.internal.dom.Policy;
import org.jcp.xml.dsig.internal.dom.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMSignedInfo
extends DOMStructure
implements SignedInfo {
    private static Logger log = Logger.getLogger("org.jcp.xml.dsig.internal.dom");
    private List<Reference> references;
    private CanonicalizationMethod canonicalizationMethod;
    private SignatureMethod signatureMethod;
    private String id;
    private Document ownerDoc;
    private Element localSiElem;
    private InputStream canonData;

    public DOMSignedInfo(CanonicalizationMethod canonicalizationMethod, SignatureMethod signatureMethod, List<? extends Reference> list) {
        if (canonicalizationMethod == null || signatureMethod == null || list == null) {
            throw new NullPointerException();
        }
        this.canonicalizationMethod = canonicalizationMethod;
        this.signatureMethod = signatureMethod;
        this.references = Collections.unmodifiableList(new ArrayList<Reference>(list));
        if (this.references.isEmpty()) {
            throw new IllegalArgumentException("list of references must contain at least one entry");
        }
        int n = this.references.size();
        for (int i = 0; i < n; ++i) {
            Reference reference = this.references.get(i);
            if (reference instanceof Reference) continue;
            throw new ClassCastException("list of references contains an illegal type");
        }
    }

    public DOMSignedInfo(CanonicalizationMethod canonicalizationMethod, SignatureMethod signatureMethod, List<? extends Reference> list, String string) {
        this(canonicalizationMethod, signatureMethod, list);
        this.id = string;
    }

    public DOMSignedInfo(Element element, XMLCryptoContext xMLCryptoContext, Provider provider) throws MarshalException {
        this.localSiElem = element;
        this.ownerDoc = element.getOwnerDocument();
        this.id = DOMUtils.getAttributeValue(element, "Id");
        Element element2 = DOMUtils.getFirstChildElement(element, "CanonicalizationMethod");
        this.canonicalizationMethod = new DOMCanonicalizationMethod(element2, xMLCryptoContext, provider);
        Element element3 = DOMUtils.getNextSiblingElement(element2, "SignatureMethod");
        this.signatureMethod = DOMSignatureMethod.unmarshal(element3);
        boolean bl = Utils.secureValidation(xMLCryptoContext);
        String string = this.signatureMethod.getAlgorithm();
        if (bl && Policy.restrictAlg(string)) {
            throw new MarshalException("It is forbidden to use algorithm " + string + " when secure validation is enabled");
        }
        ArrayList<DOMReference> arrayList = new ArrayList<DOMReference>(5);
        Element element4 = DOMUtils.getNextSiblingElement(element3, "Reference");
        arrayList.add(new DOMReference(element4, xMLCryptoContext, provider));
        element4 = DOMUtils.getNextSiblingElement(element4);
        while (element4 != null) {
            String string2 = element4.getLocalName();
            if (!string2.equals("Reference")) {
                throw new MarshalException("Invalid element name: " + string2 + ", expected Reference");
            }
            arrayList.add(new DOMReference(element4, xMLCryptoContext, provider));
            if (bl && Policy.restrictNumReferences(arrayList.size())) {
                String string3 = "A maximum of " + Policy.maxReferences() + " references per Manifest are allowed when secure validation is enabled";
                throw new MarshalException(string3);
            }
            element4 = DOMUtils.getNextSiblingElement(element4);
        }
        this.references = Collections.unmodifiableList(arrayList);
    }

    @Override
    public CanonicalizationMethod getCanonicalizationMethod() {
        return this.canonicalizationMethod;
    }

    @Override
    public SignatureMethod getSignatureMethod() {
        return this.signatureMethod;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List getReferences() {
        return this.references;
    }

    @Override
    public InputStream getCanonicalizedData() {
        return this.canonData;
    }

    public void canonicalize(XMLCryptoContext xMLCryptoContext, ByteArrayOutputStream byteArrayOutputStream) throws XMLSignatureException {
        block10: {
            UnsyncBufferedOutputStream unsyncBufferedOutputStream;
            block9: {
                if (xMLCryptoContext == null) {
                    throw new NullPointerException("context cannot be null");
                }
                unsyncBufferedOutputStream = new UnsyncBufferedOutputStream(byteArrayOutputStream);
                DOMSubTreeData dOMSubTreeData = new DOMSubTreeData(this.localSiElem, true);
                try {
                    ((DOMCanonicalizationMethod)this.canonicalizationMethod).canonicalize(dOMSubTreeData, xMLCryptoContext, unsyncBufferedOutputStream);
                }
                catch (TransformException transformException) {
                    throw new XMLSignatureException(transformException);
                }
                try {
                    ((OutputStream)unsyncBufferedOutputStream).flush();
                }
                catch (IOException iOException) {
                    if (!log.isLoggable(Level.FINE)) break block9;
                    log.log(Level.FINE, iOException.getMessage(), iOException);
                }
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Canonicalized SignedInfo:");
                StringBuilder stringBuilder = new StringBuilder(byArray.length);
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuilder.append((char)byArray[i]);
                }
                log.log(Level.FINE, stringBuilder.toString());
                log.log(Level.FINE, "Data to be signed/verified:" + Base64.encode(byArray));
            }
            this.canonData = new ByteArrayInputStream(byArray);
            try {
                ((OutputStream)unsyncBufferedOutputStream).close();
            }
            catch (IOException iOException) {
                if (!log.isLoggable(Level.FINE)) break block10;
                log.log(Level.FINE, iOException.getMessage(), iOException);
            }
        }
    }

    @Override
    public void marshal(Node node, String string, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        this.ownerDoc = DOMUtils.getOwnerDocument(node);
        Element element = DOMUtils.createElement(this.ownerDoc, "SignedInfo", "http://www.w3.org/2000/09/xmldsig#", string);
        DOMCanonicalizationMethod dOMCanonicalizationMethod = (DOMCanonicalizationMethod)this.canonicalizationMethod;
        dOMCanonicalizationMethod.marshal(element, string, dOMCryptoContext);
        ((DOMStructure)((Object)this.signatureMethod)).marshal(element, string, dOMCryptoContext);
        for (Reference reference : this.references) {
            ((DOMReference)reference).marshal(element, string, dOMCryptoContext);
        }
        DOMUtils.setAttributeID(element, "Id", this.id);
        node.appendChild(element);
        this.localSiElem = element;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SignedInfo)) {
            return false;
        }
        SignedInfo signedInfo = (SignedInfo)object;
        boolean bl = this.id == null ? signedInfo.getId() == null : this.id.equals(signedInfo.getId());
        return this.canonicalizationMethod.equals(signedInfo.getCanonicalizationMethod()) && this.signatureMethod.equals(signedInfo.getSignatureMethod()) && this.references.equals(signedInfo.getReferences()) && bl;
    }

    public int hashCode() {
        int n = 17;
        if (this.id != null) {
            n = 31 * n + this.id.hashCode();
        }
        n = 31 * n + this.canonicalizationMethod.hashCode();
        n = 31 * n + this.signatureMethod.hashCode();
        n = 31 * n + this.references.hashCode();
        return n;
    }
}

