/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vm.console.storageV1.impl;

import com.huawei.vm.console.managementV1.ConsoleControllers;
import com.huawei.vm.console.newUtils.DeviceIO;
import com.huawei.vm.console.storageV1.impl.CDROMDriver;
import com.huawei.vm.console.utilsV1.TestPrint;
import com.huawei.vm.console.utilsV1.VMException;
import de.tu_darmstadt.informatik.rbg.bstickler.udflib.UDFExtendFile;
import java.util.Map;

public class CDROMDevice
extends CDROMDriver {
    private final DeviceIO device = new DeviceIO();

    public CDROMDevice(String path) throws VMException {
        super(path);
        if (!ConsoleControllers.isSetUp()) {
            throw new VMException(210);
        }
        int result = this.device.open(this.deviceName);
        if (0 != result) {
            if (33 == result || 32 == result) {
                throw new VMException(223);
            }
            throw new VMException(220);
        }
    }

    @Override
    public void open(String path) throws VMException {
        int result;
        if (this.device.isActive()) {
            this.device.close();
        }
        if (0 != (result = this.device.open(path))) {
            if (33 == result || 32 == result) {
                throw new VMException(223);
            }
            throw new VMException(220);
        }
    }

    @Override
    public void close() throws VMException {
        int result = this.device.close();
        if (0 > result) {
            throw new VMException(221);
        }
    }

    @Override
    public int modeSense(byte[] dataBuffer, int pc, int pageCode) {
        int mediumType = this.device.getMediumType();
        dataBuffer[0] = 0;
        dataBuffer[1] = 6;
        dataBuffer[2] = (byte)mediumType;
        dataBuffer[3] = 0;
        dataBuffer[4] = 0;
        dataBuffer[5] = 0;
        dataBuffer[6] = 0;
        dataBuffer[7] = 0;
        return 8;
    }

    @Override
    public int read(byte[] dataBuffer, long startPosition, int length) throws VMException {
        int result = this.device.read(startPosition, length, dataBuffer);
        if (0 >= result) {
            this.getMediumSize();
            if (0 > result) {
                throw new VMException(250);
            }
        }
        return result;
    }

    @Override
    public long getMediumSize() throws VMException {
        long size = this.device.getCapaticy();
        if (size < 0L) {
            throw new VMException(253);
        }
        return size;
    }

    @Override
    public int readTOC(byte[] dataBuffer, boolean isMSF, int format, int startTrack) throws VMException {
        int dataLen = this.device.readTOC(dataBuffer, isMSF, format, startTrack);
        if (0 > dataLen) {
            throw new VMException(253);
        }
        return dataLen;
    }

    @Override
    public int testUnitReady() {
        int curState = this.device.testUnitReady();
        TestPrint.println(3, "CDROM Device : device state:" + this.getDeviceState() + ";Cur state:" + curState);
        if (2 == curState) {
            this.device.close();
            this.device.open(this.deviceName);
        }
        if (0 > curState) {
            curState = 0;
        }
        return curState;
    }

    @Override
    public boolean preventAllowMediumRemoval(boolean isPrevent) {
        return this.device.preventAllowMediumRemoval(isPrevent) >= 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startStopUnit(boolean isEject, boolean isStart) throws VMException {
        if (isEject && !isStart) {
            if (0 != this.device.eject(true)) throw new VMException(252);
            this.setDeviceState(0);
            return;
        } else {
            if (!isEject || !isStart) throw new VMException(252);
            if (0 != this.device.eject(false)) throw new VMException(252);
            this.refreshState();
        }
    }

    @Override
    protected void prepareChangeDisk(String localDirName, Map<Long, UDFExtendFile> memoryStructMap, String diskName) {
    }

    @Override
    public void eject() throws VMException {
        this.startStopUnit(true, false);
    }

    @Override
    public void insert() throws VMException {
        this.startStopUnit(true, true);
    }

    @Override
    public boolean isInited() {
        return this.device.isActive();
    }

    @Override
    public void inquiry() {
    }
}

