/*
 * Decompiled with CFR 0.152.
 */
package com.kvm;

import com.kvm.Base;
import com.kvm.FrenchKeyboardAction;
import com.kvm.GermanKeyboardAction;
import com.kvm.ItalianKeyboardAction;
import com.kvm.JapaneseKeyboardAction;
import com.kvm.KVMInterface;
import com.kvm.SelfAdaptionAction;
import java.awt.Color;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;

public class KeyboardPopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = 1L;
    private KVMInterface kvmInterface;
    public final JCheckBoxMenuItem selfAdaptionMenu;
    public final JCheckBoxMenuItem japaneseKeyboardMenu;
    public final JCheckBoxMenuItem frenchKeyboardMenu;
    public final JCheckBoxMenuItem italianKeyboardMenu;
    public final JCheckBoxMenuItem germanKeyboardMenu;

    public KVMInterface getKvmInterface() {
        return this.kvmInterface;
    }

    public void setKvmInterface(KVMInterface kvmInterface) {
        this.kvmInterface = kvmInterface;
    }

    public KeyboardPopupMenu(KVMInterface kvmInterface) {
        this.kvmInterface = kvmInterface;
        this.selfAdaptionMenu = new JCheckBoxMenuItem(kvmInterface.getKvmUtil().getString("usKeyboard"));
        this.japaneseKeyboardMenu = new JCheckBoxMenuItem(kvmInterface.getKvmUtil().getString("japaneseKeyboard"));
        this.frenchKeyboardMenu = new JCheckBoxMenuItem(kvmInterface.getKvmUtil().getString("frenchKeyboard"));
        this.italianKeyboardMenu = new JCheckBoxMenuItem(kvmInterface.getKvmUtil().getString("italianKeyboard"));
        this.germanKeyboardMenu = new JCheckBoxMenuItem(kvmInterface.getKvmUtil().getString("germanKeyboard"));
        this.add(this.selfAdaptionMenu);
        this.add(this.japaneseKeyboardMenu);
        this.add(this.frenchKeyboardMenu);
        this.add(this.italianKeyboardMenu);
        this.add(this.germanKeyboardMenu);
        if (Base.getKeyboardLayout() == 1) {
            this.selfAdaptionMenu.setSelected(true);
            this.japaneseKeyboardMenu.setSelected(false);
            this.frenchKeyboardMenu.setSelected(false);
            this.italianKeyboardMenu.setSelected(false);
            this.germanKeyboardMenu.setSelected(false);
        } else if (Base.getKeyboardLayout() == 2) {
            this.selfAdaptionMenu.setSelected(false);
            this.japaneseKeyboardMenu.setSelected(true);
            this.frenchKeyboardMenu.setSelected(false);
            this.italianKeyboardMenu.setSelected(false);
            this.germanKeyboardMenu.setSelected(false);
        } else if (Base.getKeyboardLayout() == 4) {
            this.selfAdaptionMenu.setSelected(false);
            this.japaneseKeyboardMenu.setSelected(false);
            this.frenchKeyboardMenu.setSelected(false);
            this.italianKeyboardMenu.setSelected(true);
            this.germanKeyboardMenu.setSelected(false);
        } else if (Base.getKeyboardLayout() == 5) {
            this.selfAdaptionMenu.setSelected(false);
            this.japaneseKeyboardMenu.setSelected(false);
            this.frenchKeyboardMenu.setSelected(false);
            this.italianKeyboardMenu.setSelected(false);
            this.germanKeyboardMenu.setSelected(true);
        } else {
            this.selfAdaptionMenu.setSelected(false);
            this.japaneseKeyboardMenu.setSelected(false);
            this.frenchKeyboardMenu.setSelected(true);
            this.italianKeyboardMenu.setSelected(false);
            this.germanKeyboardMenu.setSelected(false);
        }
        this.selfAdaptionMenu.addActionListener(this.selfAdaptionAction());
        this.japaneseKeyboardMenu.addActionListener(this.japaneseKeyboardAction());
        this.frenchKeyboardMenu.addActionListener(this.frenchKeyboardAction());
        this.italianKeyboardMenu.addActionListener(this.italianKeyboardAction());
        this.germanKeyboardMenu.addActionListener(this.germanKeyboardAction());
        this.setBackground(new Color(158, 202, 232));
        this.selfAdaptionMenu.setBackground(new Color(204, 227, 242));
        this.japaneseKeyboardMenu.setBackground(new Color(204, 227, 242));
        this.frenchKeyboardMenu.setBackground(new Color(204, 227, 242));
        this.italianKeyboardMenu.setBackground(new Color(204, 227, 242));
        this.germanKeyboardMenu.setBackground(new Color(204, 227, 242));
    }

    private ActionListener frenchKeyboardAction() {
        FrenchKeyboardAction action = new FrenchKeyboardAction(this);
        return action;
    }

    private ActionListener japaneseKeyboardAction() {
        JapaneseKeyboardAction action = new JapaneseKeyboardAction(this);
        return action;
    }

    private ActionListener selfAdaptionAction() {
        SelfAdaptionAction action = new SelfAdaptionAction(this);
        return action;
    }

    private ActionListener italianKeyboardAction() {
        ItalianKeyboardAction action = new ItalianKeyboardAction(this);
        return action;
    }

    private ActionListener germanKeyboardAction() {
        GermanKeyboardAction action = new GermanKeyboardAction(this);
        return action;
    }

    public static void setSelected(KeyboardPopupMenu keyboardPopupMenu, JCheckBoxMenuItem menu) {
        keyboardPopupMenu.selfAdaptionMenu.setSelected(false);
        keyboardPopupMenu.japaneseKeyboardMenu.setSelected(false);
        keyboardPopupMenu.frenchKeyboardMenu.setSelected(false);
        keyboardPopupMenu.italianKeyboardMenu.setSelected(false);
        keyboardPopupMenu.germanKeyboardMenu.setSelected(false);
        menu.setSelected(true);
    }
}

