/*
 * Decompiled with CFR 0.152.
 */
package com.kvm;

import com.kvm.Base;
import com.kvm.BladeThread;
import com.kvm.KVMInterface;
import com.kvm.MouseModeAction;
import com.kvm.MouseSwitchAction;
import com.kvm.USBReserAction;
import java.awt.Color;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;

public class MousePopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = 1L;
    private KVMInterface kvmInterface;
    public final JCheckBoxMenuItem mouseModeSwitchMenu;
    public final JCheckBoxMenuItem singleMouseMenu;
    public final JMenuItem usbResetMenu;
    protected static final int OK = 0;
    private transient BladeThread bladeThread;
    static final int UMS_NOTIFY_DELAY = 1000;

    public KVMInterface getKvmInterface() {
        return this.kvmInterface;
    }

    public void setKvmInterface(KVMInterface kvmInterface) {
        this.kvmInterface = kvmInterface;
    }

    public MousePopupMenu(KVMInterface kvmInterface2) {
        this.kvmInterface = kvmInterface2;
        this.mouseModeSwitchMenu = new JCheckBoxMenuItem(kvmInterface2.getKvmUtil().getString("mouse_mode_switch"));
        if (Base.getIsSynMouse()) {
            this.mouseModeSwitchMenu.setSelected(true);
        } else {
            this.mouseModeSwitchMenu.setSelected(false);
        }
        this.singleMouseMenu = new JCheckBoxMenuItem(kvmInterface2.getKvmUtil().getString("single_mouse"));
        if ("USB".equals("USB")) {
            this.add(this.mouseModeSwitchMenu);
            this.add(this.singleMouseMenu);
        }
        this.singleMouseMenu.addActionListener(this.singleMouseSwitchAction());
        this.mouseModeSwitchMenu.addActionListener(this.mouseModeSwitchAction());
        this.setBackground(new Color(158, 202, 232));
        this.singleMouseMenu.setBackground(new Color(204, 227, 242));
        this.mouseModeSwitchMenu.setBackground(new Color(204, 227, 242));
        this.usbResetMenu = new JMenuItem(kvmInterface2.getKvmUtil().getString("Mouse_Key_Reset"));
        this.add(this.usbResetMenu);
        this.usbResetMenu.addActionListener(this.usbResetAction());
        this.usbResetMenu.setBackground(new Color(204, 227, 242));
    }

    public int confirmWindow() {
        return JOptionPane.showConfirmDialog(this.getKvmInterface().getFloatToolbar().getImagePanel(), this.getKvmInterface().getKvmUtil().getString("Power_massage"), UIManager.getString("OptionPane.titleText"), 0);
    }

    public int umsConfirmWindow() {
        return JOptionPane.showConfirmDialog(this.getKvmInterface().getFloatToolbar().getImagePanel(), this.getKvmInterface().getKvmUtil().getString("Ums_Notify_Message"), UIManager.getString("OptionPane.titleText"), 2);
    }

    public void sendUmsMessage(byte message, int bladeNo) {
        if (this.bladeThread == null) {
            this.bladeThread = (BladeThread)this.getKvmInterface().getBase().getThreadGroup().get(String.valueOf(this.getKvmInterface().getActionBlade()));
        }
        if (message == 69) {
            this.bladeThread.getBladeCommu().sentData(this.getKvmInterface().getPackData().reqUmsNotify(bladeNo));
        } else {
            this.bladeThread.getBladeCommu().sentData(this.getKvmInterface().getKvmUtil().getImagePane(this.getKvmInterface().getActionBlade()).getPack().kvmCmdPowerControl(message, bladeNo));
        }
    }

    private Action mouseModeSwitchAction() {
        MouseModeAction action = new MouseModeAction(this);
        return action;
    }

    private Action singleMouseSwitchAction() {
        MouseSwitchAction action = new MouseSwitchAction(this);
        return action;
    }

    private Action usbResetAction() {
        USBReserAction action = new USBReserAction(this);
        return action;
    }
}

