/*
 * Decompiled with CFR 0.152.
 */
package com.kvm;

import com.kvm.DoProcess;
import com.kvm.KVMUtil;
import com.library.LoggerUtil;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

class SendIPMIInDiffOS {
    public static final String WINDOWS_IPMITOOL_PATH = "ipmitool/ipmitool.exe";
    public static final String LINUX_IPMITOOL_PATH = "ipmitool";
    public static final long MAX_WAIT_TIME_MINUTES = 1L;

    SendIPMIInDiffOS() {
    }

    public String useIpmitoolInDiffOS(String ipmiOEM) {
        DoProcess dop;
        String command = "";
        String ipmitoolPath = "";
        String absolutePath = "";
        Process process = null;
        String[] cmds = null;
        String result = null;
        if (KVMUtil.isWindowsOS()) {
            ipmitoolPath = WINDOWS_IPMITOOL_PATH;
            File file = new File(ipmitoolPath);
            try {
                absolutePath = file.getCanonicalPath();
                command = absolutePath + " " + ipmiOEM;
                process = Runtime.getRuntime().exec(command);
            }
            catch (IOException e1) {
                LoggerUtil.error(e1.getClass().getName());
            }
            DoProcess dop2 = new DoProcess();
            dop2.transPara(process);
            dop2.start();
            try {
                dop2.join();
            }
            catch (InterruptedException e1) {
                LoggerUtil.error(e1.getClass().getName());
            }
            result = dop2.getProResult();
        } else if (KVMUtil.isLinux()) {
            absolutePath = LINUX_IPMITOOL_PATH;
            command = absolutePath + " " + ipmiOEM;
            cmds = new String[]{"/bin/bash", "-c", command};
            try {
                process = Runtime.getRuntime().exec(cmds);
            }
            catch (IOException e2) {
                LoggerUtil.error(e2.getClass().getName());
            }
            dop = new DoProcess();
            dop.transPara(process);
            dop.start();
            try {
                dop.join();
            }
            catch (InterruptedException e2) {
                LoggerUtil.error(e2.getClass().getName());
            }
            result = dop.getProResult();
        } else if (KVMUtil.isMacOS()) {
            absolutePath = LINUX_IPMITOOL_PATH;
            command = absolutePath + " " + ipmiOEM;
            cmds = new String[]{"/bin/bash", "-c", command};
            try {
                process = Runtime.getRuntime().exec(cmds);
            }
            catch (IOException e3) {
                LoggerUtil.error(e3.getClass().getName());
            }
            dop = new DoProcess();
            dop.transPara(process);
            dop.start();
            try {
                dop.join();
            }
            catch (InterruptedException e3) {
                LoggerUtil.error(e3.getClass().getName());
            }
            result = dop.getProResult();
        }
        try {
            boolean exitValue;
            if (null != process && !(exitValue = process.waitFor(1L, TimeUnit.MINUTES))) {
                result = null;
            }
        }
        catch (InterruptedException e) {
            LoggerUtil.error(e.getClass().getName());
        }
        catch (NullPointerException e) {
            LoggerUtil.error(e.getClass().getName());
        }
        return result;
    }
}

