/*
 * Decompiled with CFR 0.152.
 */
package com.library.decoder;

import com.library.LibException;
import com.library.LoggerUtil;
import com.library.decoder.ColorConverter;
import com.library.decoder.ImageBlock;
import com.library.decoder.ImageCreater;
import com.library.decoder.JPEGData;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class ImageDecoder {
    private static int blockImageWidth = 64;
    private static int blockImageHeight = 64;
    final byte[] flagValue = new byte[]{0, 1, 3, 7, 15, 31, 63, 127, -1};
    int blockXcount = 0;
    int blockYcount = 0;
    int blockcount = 0;
    int blockCutWidth = 0;
    int blockCutHeight = 0;
    int imageWidth = 0;
    int imageHeight = 0;
    ImageBlock[] imageBlocks = null;
    ImageCreater imageCreater = null;
    private ArrayList<byte[]> zipImages = new ArrayList(10);
    int num = 0;
    int tnum = 0;
    private byte[] zipImage = null;

    public ImageDecoder() {
        this.init(1024, 1024);
        this.imageCreater = new ImageCreater();
    }

    public ImageDecoder(int imageWidth, int imageHeight) {
        this.init(imageWidth, imageHeight);
        this.imageCreater = new ImageCreater();
    }

    public final void init(int imageWidth, int imageHeight) {
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.blockXcount = imageWidth / blockImageWidth + (imageWidth % blockImageWidth == 0 ? 0 : 1);
        this.blockYcount = imageHeight / blockImageHeight + (imageHeight % blockImageHeight == 0 ? 0 : 1);
        this.blockcount = this.blockXcount * this.blockYcount;
        this.blockCutWidth = blockImageWidth - (this.blockXcount * blockImageWidth - imageWidth);
        this.blockCutHeight = blockImageHeight - (this.blockYcount * blockImageHeight - imageHeight);
        this.imageBlocks = new ImageBlock[this.blockcount];
    }

    public void reInit(int imageWidth, int imageHeight) {
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.blockXcount = imageWidth / blockImageWidth + (imageWidth % blockImageWidth == 0 ? 0 : 1);
        this.blockYcount = imageHeight / blockImageHeight + (imageHeight % blockImageHeight == 0 ? 0 : 1);
        this.blockcount = this.blockXcount * this.blockYcount;
        this.blockCutWidth = blockImageWidth - (this.blockXcount * blockImageWidth - imageWidth);
        this.blockCutHeight = blockImageHeight - (this.blockYcount * blockImageHeight - imageHeight);
        this.imageBlocks = new ImageBlock[this.blockcount];
    }

    public Object decodeRLEorJPEG(byte[] zipDatas, int imageWidth, int imageHeight) throws LibException {
        Object obj = null;
        int width = 0;
        int height = 0;
        try {
            if (this.zipImages.size() == 0) {
                LoggerUtil.error("zipImages size is null!");
            }
            width = (this.zipImages.get(this.num)[4] & 0xFF) << 8 | this.zipImages.get(this.num)[5] & 0xFF;
            height = (this.zipImages.get(this.num)[6] & 0xFF) << 8 | this.zipImages.get(this.num)[7] & 0xFF;
            obj = this.decodeRLEorJPEG1(this.zipImages.get(this.num), width, height);
            ++this.tnum;
            if (this.tnum >= 5) {
                ++this.num;
                this.tnum = 0;
            }
            if (this.num >= this.zipImages.size()) {
                this.num = 0;
            }
        }
        catch (Exception e1) {
            LoggerUtil.error(e1.getClass().getName());
        }
        return obj;
    }

    public Object decodeRLEorJPEG0(byte[] zipDatas, int imageWidth, int imageHeight) throws LibException {
        Object obj = null;
        try {
            this.zipImage = (byte[])zipDatas.clone();
            obj = this.decodeRLEorJPEG1(this.zipImage, imageWidth, imageHeight);
        }
        catch (Exception e1) {
            LoggerUtil.error(e1.getClass().getName());
        }
        return obj;
    }

    public Object decodeRLEorJPEG3(byte[] zipDatas, int imageWidth, int imageHeight) throws LibException {
        int syclen = 0;
        int subSyclen = 0;
        int zipType = 0;
        int rZipType = 0;
        int len = 0;
        byte bufColor1 = 0;
        byte bufColor2 = 0;
        byte bufColor3 = 0;
        byte bgr233 = 0;
        int subLen = 0;
        int indexType = 0;
        int change_flag = 0;
        int tmpdata = 0;
        int lastnum = 0;
        int subPixlen = 0;
        byte[] imageData = new byte[12288];
        byte[] zipData = null;
        byte butcolor1 = 0;
        byte butcolor2 = 0;
        byte butcolor3 = 0;
        int blocknum = 0;
        byte rgb322Color = 0;
        ImageBlock imageBlock = null;
        byte[] temBlockData = null;
        byte[] temBlockData1 = null;
        int index = 0;
        if (this.imageWidth != imageWidth || this.imageHeight != imageHeight) {
            this.init(imageWidth, imageHeight);
        }
        for (int i = 8; i < zipDatas.length; i += syclen) {
            zipType = (zipDatas[i] & 0xFF & 0xE0) >> 5;
            rZipType = (zipDatas[i] & 0xFF & 0x1C) >> 2;
            imageBlock = null;
            switch (zipType) {
                case 0: 
                case 1: {
                    switch (rZipType) {
                        case 0: {
                            bufColor1 = zipDatas[i + 1];
                            bufColor2 = zipDatas[i + 2];
                            bufColor3 = zipDatas[i + 3];
                            bgr233 = ColorConverter.ycbcr2rgb332(bufColor1, bufColor2, bufColor3);
                            imageData = new byte[4096];
                            for (int j = 0; j < imageData.length; ++j) {
                                imageData[j] = bgr233;
                            }
                            syclen = 4;
                            break;
                        }
                        case 1: {
                            tmpdata = 0;
                            lastnum = 0;
                            butcolor1 = zipDatas[i + 3];
                            butcolor2 = zipDatas[i + 3 + 1];
                            butcolor3 = zipDatas[i + 3 + 2];
                            subSyclen = 0;
                            len = ((zipDatas[i + 1] & 0xFF) << 8) + (zipDatas[i + 2] & 0xFF);
                            temBlockData = new byte[len];
                            System.arraycopy(zipDatas, i + 1 + 2 + 6, temBlockData, 0, len);
                            for (int m = 0; m < temBlockData.length; ++m) {
                                if (lastnum <= 8) {
                                    tmpdata = tmpdata & 0xFFFF | (temBlockData[m] & 0xFF) << 8 - lastnum;
                                    lastnum += 8;
                                }
                                subPixlen = ((tmpdata & 0xFC00) >> 10) + 1;
                                tmpdata = tmpdata << 6 & 0xFFFF;
                                lastnum -= 6;
                                if (subPixlen < 64) {
                                    change_flag = 0;
                                } else {
                                    change_flag = (tmpdata & 0x200) >> 1;
                                    tmpdata <<= 1;
                                    --lastnum;
                                }
                                rgb322Color = ColorConverter.ycbcr2rgb332(butcolor1, butcolor2, butcolor3);
                                imageData = new byte[4096];
                                for (int j = 0; j < subPixlen; ++j) {
                                    imageData[subSyclen + j] = rgb322Color;
                                }
                                subSyclen += subPixlen;
                                if (change_flag != 0) continue;
                                if ((byte)butcolor1 == zipDatas[i + 3 + 0] && (byte)butcolor1 == zipDatas[i + 3 + 1] && (byte)butcolor1 == zipDatas[i + 3 + 2]) {
                                    butcolor1 = zipDatas[i + 3 + 3];
                                    butcolor2 = zipDatas[i + 3 + 4];
                                    butcolor3 = zipDatas[i + 3 + 5];
                                    continue;
                                }
                                butcolor1 = zipDatas[i + 3 + 0];
                                butcolor2 = zipDatas[i + 3 + 1];
                                butcolor3 = zipDatas[i + 3 + 2];
                            }
                            syclen = 9 + len;
                            break;
                        }
                        case 2: 
                        case 3: {
                            byte[] temcolor1 = new byte[]{ColorConverter.ycbcr2rgb332(zipDatas[i + 3 + 0], zipDatas[i + 3 + 1], zipDatas[i + 3 + 2]), ColorConverter.ycbcr2rgb332(zipDatas[i + 3 + 0], zipDatas[i + 3 + 1], zipDatas[i + 3 + 2]), ColorConverter.ycbcr2rgb332(zipDatas[i + 3 + 0], zipDatas[i + 3 + 1], zipDatas[i + 3 + 2])};
                            subSyclen = 0;
                            indexType = 4;
                            if (rZipType == 2) {
                                indexType = 3;
                            }
                            len = ((zipDatas[i + 1] & 0xFF) << 8) + (zipDatas[i + 2] & 0xFF);
                            temBlockData1 = new byte[len];
                            System.arraycopy(zipDatas, i + 1 + 2 + indexType * 3, temBlockData1, 0, len);
                            for (int m = 0; m < temBlockData1.length; ++m) {
                                subLen = (temBlockData1[i] & this.flagValue[6]) >> 2;
                                index = temBlockData1[i] & this.flagValue[2];
                                imageData = new byte[4096];
                                for (int j = 0; j < subLen; ++j) {
                                    imageData[subSyclen + j] = temcolor1[index];
                                }
                                subSyclen += subLen * 3;
                            }
                            syclen = 3 + indexType * 3 + len;
                            break;
                        }
                        case 4: {
                            imageBlock = new ImageBlock();
                            imageBlock.setImage(this.imageBlocks[blocknum - 1].getImage());
                            imageBlock.setFill(this.imageBlocks[blocknum - 1].isFill());
                            imageBlock.setCutWidth(this.imageBlocks[blocknum - 1].getCutWidth());
                            imageBlock.setCutHeight(this.imageBlocks[blocknum - 1].getCutHeight());
                            this.imageBlocks[blocknum] = imageBlock;
                            syclen = 1;
                            break;
                        }
                        case 6: {
                            imageBlock = new ImageBlock();
                            imageBlock.setImage(this.imageBlocks[blocknum - this.blockXcount].getImage());
                            imageBlock.setFill(this.imageBlocks[blocknum - this.blockXcount].isFill());
                            imageBlock.setCutWidth(this.imageBlocks[blocknum - this.blockXcount].getCutWidth());
                            imageBlock.setCutHeight(this.imageBlocks[blocknum - this.blockXcount].getCutHeight());
                            this.imageBlocks[blocknum] = imageBlock;
                            syclen = 1;
                            break;
                        }
                        case 5: 
                        case 7: {
                            syclen = 3 + len;
                            break;
                        }
                        default: {
                            throw new LibException("RLE imagedata error");
                        }
                    }
                    if (rZipType == 4 || rZipType == 6) break;
                    if (blocknum > this.blockcount) {
                        LoggerUtil.error("zip data fail! ");
                    }
                    BufferedImage imageRLE = this.imageCreater.createRLEImg_0(imageData, blockImageWidth, blockImageHeight);
                    imageBlock = new ImageBlock();
                    imageBlock.setImage(imageRLE);
                    this.imageBlocks[blocknum] = imageBlock;
                    break;
                }
                case 2: 
                case 3: {
                    len = ((zipDatas[i + 1] & 0xFF) << 8) + (zipDatas[i + 2] & 0xFF);
                    zipData = new byte[len];
                    System.arraycopy(zipDatas, i + 3, zipData, 0, len);
                    syclen = 3 + len;
                    BufferedImage JPEGimage = this.imageCreater.JPEGDecodeAsImage(zipData);
                    imageBlock = new ImageBlock();
                    imageBlock.setImage(JPEGimage);
                    this.imageBlocks[blocknum] = imageBlock;
                    break;
                }
                case 4: {
                    syclen = 1;
                    break;
                }
                case 5: {
                    imageBlock = new ImageBlock();
                    imageBlock.setImage(this.imageBlocks[blocknum - this.blockXcount].getImage());
                    imageBlock.setFill(this.imageBlocks[blocknum - this.blockXcount].isFill());
                    imageBlock.setCutHeight(this.imageBlocks[blocknum - this.blockXcount].getCutHeight());
                    imageBlock.setCutWidth(this.imageBlocks[blocknum - this.blockXcount].getCutWidth());
                    this.imageBlocks[blocknum] = imageBlock;
                    syclen = 1;
                    break;
                }
                case 6: {
                    imageBlock = new ImageBlock();
                    imageBlock.setImage(this.imageBlocks[blocknum - 1].getImage());
                    imageBlock.setFill(this.imageBlocks[blocknum - 1].isFill());
                    imageBlock.setCutWidth(this.imageBlocks[blocknum - 1].getCutWidth());
                    imageBlock.setCutHeight(this.imageBlocks[blocknum - 1].getCutHeight());
                    this.imageBlocks[blocknum] = imageBlock;
                    syclen = 1;
                    break;
                }
                default: {
                    throw new LibException("imagedata error");
                }
            }
            if (imageBlock != null) {
                imageBlock.setY(blocknum / this.blockXcount * blockImageHeight);
                imageBlock.setX(blocknum % this.blockXcount * blockImageWidth);
                if (zipType == 1 || zipType == 3) {
                    imageBlock.setFill(true);
                    imageBlock.setCutHeight(this.blockCutHeight);
                    imageBlock.setCutWidth(this.blockCutWidth);
                    if (blocknum / this.blockXcount < this.blockYcount - 1) {
                        imageBlock.setCutHeight(blockImageHeight);
                    } else if (blocknum != this.blockcount - 1) {
                        imageBlock.setCutWidth(blockImageWidth);
                    }
                }
            }
            ++blocknum;
        }
        return this.imageBlocks.clone();
    }

    public Object decodeRLEorJPEG1(byte[] zipDatas, int imageWidth, int imageHeight) throws LibException {
        int syclen = 0;
        int zipType = 0;
        int rZipType = 0;
        int len = 0;
        byte[] zipData = null;
        byte[] pixColors = null;
        int blocknum = 0;
        ImageBlock imageBlock = null;
        Object[] reObj = null;
        if (this.imageWidth != imageWidth || this.imageHeight != imageHeight) {
            this.init(imageWidth, imageHeight);
        }
        for (int i = 1; i < zipDatas.length; i += syclen) {
            zipType = (zipDatas[i] & 0xFF & 0xE0) >> 5;
            rZipType = (zipDatas[i] & 0xFF & 0x1C) >> 2;
            block0 : switch (zipType) {
                case 0: 
                case 1: {
                    switch (rZipType) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            reObj = this.decodeRle(zipDatas, i, blocknum, rZipType, null);
                            this.imageBlocks[blocknum] = imageBlock = (ImageBlock)reObj[1];
                            syclen = (Integer)reObj[0];
                            break block0;
                        }
                        case 4: {
                            if (0 == this.imageBlocks[blocknum - 1].getBlockRleType()) {
                                imageBlock = new ImageBlock();
                                imageBlock.setImage(this.imageBlocks[blocknum - 1].getImage());
                                imageBlock.setFill(this.imageBlocks[blocknum - 1].isFill());
                                imageBlock.setCutWidth(this.imageBlocks[blocknum - 1].getCutWidth());
                                imageBlock.setCutHeight(this.imageBlocks[blocknum - 1].getCutHeight());
                                imageBlock.setBlockType(this.imageBlocks[blocknum - 1].getBlockType());
                                imageBlock.setBlockRleType(this.imageBlocks[blocknum - 1].getBlockRleType());
                                this.imageBlocks[blocknum] = imageBlock;
                                syclen = 1;
                                break block0;
                            }
                            int collen4 = this.imageBlocks[blocknum - 1].getPixColors().length;
                            pixColors = new byte[collen4];
                            System.arraycopy(this.imageBlocks[blocknum - 1].getPixColors(), 0, pixColors, 0, collen4);
                            reObj = this.decodeRle(zipDatas, i, blocknum, this.imageBlocks[blocknum - 1].getBlockRleType(), pixColors);
                            this.imageBlocks[blocknum] = imageBlock = (ImageBlock)reObj[1];
                            syclen = (Integer)reObj[0];
                            break block0;
                        }
                        case 5: {
                            byte[] cols5 = this.imageBlocks[blocknum - 1].getPixColors();
                            pixColors = new byte[cols5.length];
                            if (1 == this.imageBlocks[blocknum - 1].getBlockRleType()) {
                                pixColors[0] = cols5[3];
                                pixColors[1] = cols5[4];
                                pixColors[2] = cols5[5];
                                pixColors[3] = cols5[0];
                                pixColors[4] = cols5[1];
                                pixColors[5] = cols5[2];
                            } else {
                                System.arraycopy(this.imageBlocks[blocknum - 1].getPixColors(), 0, pixColors, 0, cols5.length);
                            }
                            reObj = this.decodeRle(zipDatas, i, blocknum, this.imageBlocks[blocknum - 1].getBlockRleType(), pixColors);
                            this.imageBlocks[blocknum] = imageBlock = (ImageBlock)reObj[1];
                            syclen = (Integer)reObj[0];
                            break block0;
                        }
                        case 6: {
                            if (0 == this.imageBlocks[blocknum - this.blockXcount].getBlockRleType()) {
                                imageBlock = new ImageBlock();
                                imageBlock.setImage(this.imageBlocks[blocknum - this.blockXcount].getImage());
                                imageBlock.setFill(this.imageBlocks[blocknum - this.blockXcount].isFill());
                                imageBlock.setCutWidth(this.imageBlocks[blocknum - this.blockXcount].getCutWidth());
                                imageBlock.setCutHeight(this.imageBlocks[blocknum - this.blockXcount].getCutHeight());
                                imageBlock.setBlockType(this.imageBlocks[blocknum - this.blockXcount].getBlockType());
                                imageBlock.setBlockRleType(this.imageBlocks[blocknum - this.blockXcount].getBlockRleType());
                                this.imageBlocks[blocknum] = imageBlock;
                                syclen = 1;
                                break block0;
                            }
                            int cols6 = this.imageBlocks[blocknum - this.blockXcount].getPixColors().length;
                            pixColors = new byte[cols6];
                            System.arraycopy(this.imageBlocks[blocknum - this.blockXcount].getPixColors(), 0, pixColors, 0, cols6);
                            reObj = this.decodeRle(zipDatas, i, blocknum, this.imageBlocks[blocknum - this.blockXcount].getBlockRleType(), pixColors);
                            this.imageBlocks[blocknum] = imageBlock = (ImageBlock)reObj[1];
                            syclen = (Integer)reObj[0];
                            break block0;
                        }
                        case 7: {
                            byte[] cols7 = this.imageBlocks[blocknum - this.blockXcount].getPixColors();
                            pixColors = new byte[cols7.length];
                            if (1 == this.imageBlocks[blocknum - this.blockXcount].getBlockRleType()) {
                                pixColors[0] = cols7[3];
                                pixColors[1] = cols7[4];
                                pixColors[2] = cols7[5];
                                pixColors[3] = cols7[0];
                                pixColors[4] = cols7[1];
                                pixColors[5] = cols7[2];
                            } else {
                                System.arraycopy(this.imageBlocks[blocknum - this.blockXcount].getPixColors(), 0, pixColors, 0, cols7.length);
                            }
                            reObj = this.decodeRle(zipDatas, i, blocknum, this.imageBlocks[blocknum - this.blockXcount].getBlockRleType(), pixColors);
                            this.imageBlocks[blocknum] = imageBlock = (ImageBlock)reObj[1];
                            syclen = (Integer)reObj[0];
                            break block0;
                        }
                    }
                    throw new LibException("RLE imagedata error");
                }
                case 2: 
                case 3: {
                    len = ((zipDatas[i + 1] & 0xFF) << 8) + (zipDatas[i + 2] & 0xFF);
                    byte[] synHeadData = JPEGData.createSynHeadData();
                    zipData = new byte[len + synHeadData.length + JPEGData.TAIL.length];
                    System.arraycopy(synHeadData, 0, zipData, 0, synHeadData.length);
                    System.arraycopy(zipDatas, i + 3, zipData, synHeadData.length, len);
                    System.arraycopy(JPEGData.TAIL, 0, zipData, synHeadData.length + len, JPEGData.TAIL.length);
                    syclen = 3 + len;
                    BufferedImage JPEGimage = this.imageCreater.JPEGDecodeAsImage(zipData);
                    imageBlock = new ImageBlock();
                    imageBlock.setImage(JPEGimage);
                    imageBlock.setBlockType(zipType);
                    this.imageBlocks[blocknum] = imageBlock;
                    break;
                }
                case 4: {
                    syclen = 1;
                    break;
                }
                case 5: {
                    imageBlock = new ImageBlock();
                    imageBlock.setImage(this.imageBlocks[blocknum - this.blockXcount].getImage());
                    imageBlock.setFill(this.imageBlocks[blocknum - this.blockXcount].isFill());
                    imageBlock.setCutWidth(this.imageBlocks[blocknum - this.blockXcount].getCutWidth());
                    imageBlock.setCutHeight(this.imageBlocks[blocknum - this.blockXcount].getCutHeight());
                    imageBlock.setBlockType(this.imageBlocks[blocknum - this.blockXcount].getBlockType());
                    imageBlock.setBlockRleType(this.imageBlocks[blocknum - this.blockXcount].getBlockRleType());
                    this.imageBlocks[blocknum] = imageBlock;
                    syclen = 1;
                    break;
                }
                case 6: {
                    imageBlock = new ImageBlock();
                    imageBlock.setImage(this.imageBlocks[blocknum - 1].getImage());
                    imageBlock.setFill(this.imageBlocks[blocknum - 1].isFill());
                    imageBlock.setCutWidth(this.imageBlocks[blocknum - 1].getCutWidth());
                    imageBlock.setCutHeight(this.imageBlocks[blocknum - 1].getCutHeight());
                    imageBlock.setBlockType(this.imageBlocks[blocknum - 1].getBlockType());
                    imageBlock.setBlockRleType(this.imageBlocks[blocknum - 1].getBlockRleType());
                    this.imageBlocks[blocknum] = imageBlock;
                    syclen = 1;
                    break;
                }
                default: {
                    throw new LibException("imagedata error");
                }
            }
            if (imageBlock != null) {
                imageBlock.setX(blocknum % this.blockXcount * blockImageWidth);
                imageBlock.setY(blocknum / this.blockXcount * blockImageHeight);
                if (zipType == 1 || zipType == 3) {
                    imageBlock.setFill(true);
                    imageBlock.setCutWidth(this.blockCutWidth);
                    imageBlock.setCutHeight(this.blockCutHeight);
                    if (blocknum / this.blockXcount < this.blockYcount - 1) {
                        imageBlock.setCutHeight(blockImageHeight);
                    } else if (blocknum != this.blockcount - 1) {
                        imageBlock.setCutWidth(blockImageWidth);
                    }
                }
            }
            ++blocknum;
            imageBlock = null;
            reObj = null;
        }
        return this.imageBlocks.clone();
    }

    public Object[] decodeRle(byte[] zipDatas, int srcPos, int blocknum, int type, byte[] pixColors) throws LibException {
        int len = 0;
        int syclen = 0;
        int rleZipType = 0;
        int subSyclen = 0;
        int indexType = 0;
        int subPixlen = 0;
        int collen = 0;
        int srcColPos = 0;
        byte[] butPixColors = null;
        int coefficient = 1;
        int[] imageData = null;
        ImageBlock imageBlock = null;
        rleZipType = type;
        if (pixColors != null) {
            butPixColors = new byte[pixColors.length];
            System.arraycopy(pixColors, 0, butPixColors, 0, pixColors.length);
            srcColPos = 0;
            coefficient = 0;
        } else {
            srcColPos = srcPos + 1;
            if (rleZipType != 0) {
                srcColPos = srcPos + 3;
            }
            collen = zipDatas.length <= srcColPos + 12 ? zipDatas.length - srcColPos : 12;
            butPixColors = new byte[collen];
            System.arraycopy(zipDatas, srcColPos, butPixColors, 0, butPixColors.length);
            srcColPos = 0;
            coefficient = 1;
        }
        switch (rleZipType) {
            case 0: {
                imageData = new int[4096];
                for (int j = 0; j < imageData.length; ++j) {
                    imageData[j] = ColorConverter.ycbcr2rgb(butPixColors[srcColPos + 0], butPixColors[srcColPos + 1], butPixColors[srcColPos + 2]);
                }
                syclen = 4;
                break;
            }
            case 1: {
                int change_flag = 0;
                int tmpdata = 0;
                int lastnum = 0;
                boolean isLastCyc = false;
                int bufColor1 = 0;
                int bufColor2 = 0;
                int bufColor3 = 0;
                bufColor1 = ColorConverter.ycbcr2rgb(butPixColors[srcColPos + 0], butPixColors[srcColPos + 1], butPixColors[srcColPos + 2]);
                bufColor2 = ColorConverter.ycbcr2rgb(butPixColors[srcColPos + 3], butPixColors[srcColPos + 4], butPixColors[srcColPos + 5]);
                bufColor3 = bufColor1;
                subSyclen = 0;
                len = ((zipDatas[srcPos + 1] & 0xFF) << 8) + (zipDatas[srcPos + 2] & 0xFF);
                byte[] temBlockData = new byte[len];
                System.arraycopy(zipDatas, srcPos + 1 + 2 + 6 * coefficient, temBlockData, 0, len);
                imageData = new int[4096];
                int m_tmp = 0;
                int m = 0;
                while (m < temBlockData.length) {
                    m_tmp = m;
                    if (!isLastCyc && lastnum < 8) {
                        tmpdata = tmpdata & 0xFFFF | (temBlockData[m_tmp] & 0xFF) << 8 - lastnum;
                        lastnum += 8;
                        ++m_tmp;
                    }
                    subPixlen = ((tmpdata & 0xFC00) >> 10) + 1;
                    tmpdata = tmpdata << 6 & 0xFFFF;
                    lastnum -= 6;
                    if (subPixlen < 64) {
                        change_flag = 0;
                    } else {
                        change_flag = (tmpdata & 0x8000) >> 15;
                        tmpdata = tmpdata << 1 & 0xFFFF;
                        --lastnum;
                    }
                    for (int k = 0; k < subPixlen; ++k) {
                        if (subSyclen + k >= imageData.length) {
                            LoggerUtil.error("RLE 2 decode error: ");
                        }
                        imageData[subSyclen + k] = bufColor3;
                    }
                    subSyclen += subPixlen;
                    if (change_flag == 0) {
                        bufColor3 = bufColor3 == bufColor1 ? bufColor2 : bufColor1;
                    }
                    if (isLastCyc || m_tmp >= len) {
                        if (isLastCyc) {
                            ++m_tmp;
                            isLastCyc = false;
                        }
                        if (tmpdata != 0 || lastnum != 0 && subSyclen < imageData.length) {
                            isLastCyc = true;
                        }
                    }
                    m = --m_tmp;
                }
                syclen = 3 + 6 * coefficient + len;
                break;
            }
            case 2: 
            case 3: {
                int index = 0;
                int[] temcolor = new int[]{ColorConverter.ycbcr2rgb(butPixColors[srcColPos + 0], butPixColors[srcColPos + 1], butPixColors[srcColPos + 2]), ColorConverter.ycbcr2rgb(butPixColors[srcColPos + 3], butPixColors[srcColPos + 4], butPixColors[srcColPos + 5]), ColorConverter.ycbcr2rgb(butPixColors[srcColPos + 6], butPixColors[srcColPos + 7], butPixColors[srcColPos + 8]), ColorConverter.ycbcr2rgb(butPixColors[srcColPos + 9], butPixColors[srcColPos + 10], butPixColors[srcColPos + 11])};
                subSyclen = 0;
                indexType = 4;
                if (rleZipType == 2) {
                    indexType = 3;
                }
                len = ((zipDatas[srcPos + 1] & 0xFF) << 8) + (zipDatas[srcPos + 2] & 0xFF);
                byte[] temBlockData1 = new byte[len];
                System.arraycopy(zipDatas, srcPos + 1 + 2 + indexType * 3 * coefficient, temBlockData1, 0, len);
                imageData = new int[4096];
                for (int m = 0; m < temBlockData1.length; ++m) {
                    subPixlen = ((temBlockData1[m] & 0xFC) >> 2) + 1;
                    index = temBlockData1[m] & 3;
                    for (int j = 0; j < subPixlen; ++j) {
                        imageData[subSyclen + j] = temcolor[index];
                    }
                    subSyclen += subPixlen;
                }
                syclen = 3 + indexType * 3 * coefficient + len;
                break;
            }
            default: {
                throw new LibException("RLE imagedata error");
            }
        }
        BufferedImage imageRLE = this.imageCreater.createRLEImg(imageData, blockImageWidth, blockImageHeight);
        imageBlock = new ImageBlock();
        imageBlock.setBlockRleType(rleZipType);
        imageBlock.setBlockType(0);
        imageBlock.setPixColors(butPixColors);
        imageBlock.setImage(imageRLE);
        int dataLen = zipDatas.length - srcPos < imageBlock.zipDataBak.length ? zipDatas.length - srcPos : imageBlock.zipDataBak.length;
        for (int i = 0; i < dataLen; ++i) {
            imageBlock.zipDataBak[i] = zipDatas[srcPos + i] & 0xFF;
        }
        imageBlock.zipDataBak[7] = srcPos;
        imageBlock.zipDataBak[8] = syclen;
        imageBlock.zipDataBak[9] = len;
        Object[] reObj = new Object[]{syclen, imageBlock};
        return reObj;
    }

    public Object[] decodeRle_0(byte[] zipDatas, int srcPos, int blocknum, int type, byte[] pixColors) throws LibException {
        int len = 0;
        int syclen = 0;
        int rZipType = 0;
        int subSyclen = 0;
        int indexType = 0;
        int subPixlen = 0;
        byte[] butPixColors = null;
        int srcColPos = 0;
        int collen = 0;
        int coefficient = 1;
        byte[] imageData = null;
        ImageBlock imageBlock = null;
        rZipType = type;
        if (pixColors != null) {
            butPixColors = new byte[pixColors.length];
            System.arraycopy(pixColors, 0, butPixColors, 0, pixColors.length);
            srcColPos = 0;
            coefficient = 0;
        } else {
            srcColPos = srcPos + 1;
            if (rZipType != 0) {
                srcColPos = srcPos + 3;
            }
            collen = zipDatas.length <= srcColPos + 12 ? zipDatas.length - srcColPos : 12;
            butPixColors = new byte[collen];
            System.arraycopy(zipDatas, srcColPos, butPixColors, 0, butPixColors.length);
            srcColPos = 0;
            coefficient = 1;
        }
        switch (rZipType) {
            case 0: {
                byte bgr233 = ColorConverter.ycbcr2rgb332(butPixColors[srcColPos + 0], butPixColors[srcColPos + 1], butPixColors[srcColPos + 2]);
                imageData = new byte[4096];
                for (int j = 0; j < imageData.length; ++j) {
                    imageData[j] = bgr233;
                }
                syclen = 4;
                break;
            }
            case 1: {
                int change_flag = 0;
                int tmpdata = 0;
                int lastnum = 0;
                boolean isLastCyc = false;
                byte bufColor1 = 0;
                byte bufColor2 = 0;
                byte bufColor3 = 0;
                bufColor1 = ColorConverter.ycbcr2rgb332(butPixColors[srcColPos + 0], butPixColors[srcColPos + 1], butPixColors[srcColPos + 2]);
                bufColor2 = ColorConverter.ycbcr2rgb332(butPixColors[srcColPos + 3], butPixColors[srcColPos + 4], butPixColors[srcColPos + 5]);
                bufColor3 = bufColor1;
                subSyclen = 0;
                len = ((zipDatas[srcPos + 1] & 0xFF) << 8) + (zipDatas[srcPos + 2] & 0xFF);
                byte[] temBlockData = new byte[len];
                System.arraycopy(zipDatas, srcPos + 1 + 2 + 6 * coefficient, temBlockData, 0, len);
                imageData = new byte[4096];
                int m_temp = 0;
                int m = 0;
                while (m < temBlockData.length) {
                    m_temp = m;
                    if (!isLastCyc && lastnum <= 8) {
                        tmpdata = tmpdata & 0xFFFF | (temBlockData[m_temp] & 0xFF) << 8 - lastnum;
                        lastnum += 8;
                        ++m_temp;
                    }
                    subPixlen = ((tmpdata & 0xFC00) >> 10) + 1;
                    tmpdata = tmpdata << 6 & 0xFFFF;
                    lastnum -= 6;
                    if (subPixlen < 64) {
                        change_flag = 0;
                    } else {
                        change_flag = (tmpdata & 0x8000) >> 15;
                        tmpdata = tmpdata << 1 & 0xFFFF;
                        --lastnum;
                    }
                    for (int j = 0; j < subPixlen; ++j) {
                        if (subSyclen + j >= imageData.length) {
                            LoggerUtil.error("RLE 2 decode error");
                        }
                        imageData[subSyclen + j] = bufColor3;
                    }
                    subSyclen += subPixlen;
                    if (change_flag == 0) {
                        bufColor3 = bufColor3 == bufColor1 ? bufColor2 : bufColor1;
                    }
                    if (isLastCyc || len <= m_temp) {
                        if (isLastCyc) {
                            isLastCyc = false;
                            ++m_temp;
                        }
                        if (tmpdata != 0) {
                            isLastCyc = true;
                        }
                    }
                    m = --m_temp;
                }
                syclen = 3 + 6 * coefficient + len;
                break;
            }
            case 2: 
            case 3: {
                int index = 0;
                byte[] temcolor1 = new byte[]{ColorConverter.ycbcr2rgb332(butPixColors[srcColPos + 0], butPixColors[srcColPos + 1], butPixColors[srcColPos + 2]), ColorConverter.ycbcr2rgb332(butPixColors[srcColPos + 3], butPixColors[srcColPos + 4], butPixColors[srcColPos + 5]), ColorConverter.ycbcr2rgb332(butPixColors[srcColPos + 6], butPixColors[srcColPos + 7], butPixColors[srcColPos + 8]), ColorConverter.ycbcr2rgb332(butPixColors[srcColPos + 9], butPixColors[srcColPos + 10], butPixColors[srcColPos + 11])};
                subSyclen = 0;
                indexType = 4;
                if (rZipType == 2) {
                    indexType = 3;
                }
                len = ((zipDatas[srcPos + 1] & 0xFF) << 8) + (zipDatas[srcPos + 2] & 0xFF);
                byte[] temBlockData1 = new byte[len];
                System.arraycopy(zipDatas, srcPos + 1 + 2 + indexType * 3 * coefficient, temBlockData1, 0, len);
                imageData = new byte[4096];
                for (int m = 0; m < temBlockData1.length; ++m) {
                    subPixlen = ((temBlockData1[m] & 0xFC) >> 2) + 1;
                    index = temBlockData1[m] & 3;
                    for (int j = 0; j < subPixlen; ++j) {
                        imageData[subSyclen + j] = temcolor1[index];
                    }
                    subSyclen += subPixlen;
                }
                syclen = 3 + indexType * 3 * coefficient + len;
                break;
            }
            default: {
                throw new LibException("RLE imagedata error");
            }
        }
        BufferedImage imageRLE = this.imageCreater.createRLEImg_0(imageData, blockImageWidth, blockImageHeight);
        imageBlock = new ImageBlock();
        imageBlock.setBlockRleType(rZipType);
        imageBlock.setBlockType(0);
        imageBlock.setPixColors(butPixColors);
        imageBlock.setImage(imageRLE);
        int len1 = zipDatas.length - srcPos < imageBlock.zipDataBak.length ? zipDatas.length - srcPos : imageBlock.zipDataBak.length;
        for (int i = 0; i < len1; ++i) {
            imageBlock.zipDataBak[i] = zipDatas[srcPos + i] & 0xFF;
        }
        imageBlock.zipDataBak[7] = srcPos;
        imageBlock.zipDataBak[8] = syclen;
        imageBlock.zipDataBak[9] = len;
        Object[] reObj = new Object[]{syclen, imageBlock};
        return reObj;
    }

    public byte[] decodeOldRLE(byte[] bytes, int imageWidth, int imageHeight) throws LibException {
        byte[] imageData = null;
        int pixNumber = imageWidth * imageHeight;
        imageData = new byte[pixNumber];
        int countNum = 0;
        int temLength = 0;
        int bytesLength = bytes.length;
        boolean flagRem = false;
        byte bufColor = 0;
        block14: for (int i = 1; i < bytesLength; i += temLength) {
            int j;
            int size22;
            int extendNum22;
            int j2;
            int size18;
            int extendNum18;
            int j3;
            int extendNum10;
            int size6;
            int j4;
            int jend;
            int tem;
            if (flagRem) {
                if (i + 1 >= bytesLength) {
                    byte[] tmp = null;
                    return tmp;
                }
                bufColor = (byte)(bytes[i] | bytes[i + 1] >>> 4 & 0xF);
                tem = (byte)(bytes[i + 1] & 0xF);
                if (0 != tem) {
                    int temInt = tem;
                    if (temInt + countNum > pixNumber) {
                        temInt = pixNumber - countNum;
                    }
                    jend = temInt + countNum;
                    for (j4 = countNum; j4 < jend; ++j4) {
                        imageData[j4] = bufColor;
                    }
                    countNum = jend;
                    if (countNum == pixNumber) {
                        return imageData;
                    }
                    temLength = 2;
                    if (bytesLength == i + 3) {
                        temLength = 3;
                    }
                    flagRem = false;
                    continue;
                }
                if (i + 2 >= bytesLength) {
                    byte[] tmp = null;
                    return tmp;
                }
                switch (bytes[i + 2] & 0xC0) {
                    case 0: {
                        if (i + 2 >= bytesLength) {
                            byte[] tmp = null;
                            return tmp;
                        }
                        int extendNum6 = bytes[i + 2] & 0x3F;
                        size6 = countNum + extendNum6;
                        size6 = size6 > pixNumber ? pixNumber : size6;
                        for (j4 = countNum; j4 < size6; ++j4) {
                            imageData[j4] = bufColor;
                        }
                        countNum = size6;
                        if (countNum == pixNumber) {
                            return imageData;
                        }
                        temLength = 3;
                        if (bytesLength == 4 + i) {
                            temLength = 4;
                        }
                        flagRem = false;
                        break;
                    }
                    case 64: {
                        if (3 + i >= bytesLength) {
                            byte[] tmp = null;
                            return tmp;
                        }
                        extendNum10 = (bytes[i + 2] << 4 & 0x3F0) + (bytes[i + 3] >>> 4 & 0xF);
                        int size10 = countNum + extendNum10;
                        size10 = size10 > pixNumber ? pixNumber : size10;
                        for (j3 = countNum; j3 < size10; ++j3) {
                            imageData[j3] = bufColor;
                        }
                        countNum = size10;
                        if (countNum == pixNumber) {
                            return imageData;
                        }
                        temLength = 3;
                        if (bytesLength == i + 4) {
                            temLength = 4;
                            break;
                        }
                        if (i + 3 >= bytesLength) {
                            byte[] bt = null;
                            return bt;
                        }
                        bytes[i + 3] = (byte)(bytes[i + 3] << 4);
                        flagRem = true;
                        break;
                    }
                    case 128: {
                        if (i + 4 >= bytesLength) {
                            byte[] bt = null;
                            return bt;
                        }
                        extendNum18 = (bytes[i + 2] << 12 & 0x3F000) + (bytes[i + 3] << 4 & 0xFF0) + (bytes[i + 4] >>> 4 & 0xF);
                        size18 = countNum + extendNum18;
                        size18 = size18 > pixNumber ? pixNumber : size18;
                        for (j2 = countNum; j2 < size18; ++j2) {
                            imageData[j2] = bufColor;
                        }
                        countNum = size18;
                        if (countNum == pixNumber) {
                            return imageData;
                        }
                        temLength = 4;
                        if (bytesLength == i + 5) {
                            temLength = 5;
                            break;
                        }
                        if (bytesLength <= i + 4) {
                            byte[] tmp = null;
                            return tmp;
                        }
                        bytes[i + 4] = (byte)(bytes[i + 4] << 4);
                        flagRem = true;
                        break;
                    }
                    case 192: {
                        if (bytesLength <= i + 4) {
                            byte[] tmp = null;
                            return tmp;
                        }
                        extendNum22 = (bytes[i + 2] << 16 & 0x3F0000) + (bytes[i + 3] << 8 & 0xFF00) + (bytes[i + 4] & 0xFF);
                        size22 = extendNum22 + countNum;
                        size22 = size22 > pixNumber ? pixNumber : size22;
                        for (j = countNum; j < size22; ++j) {
                            imageData[j] = bufColor;
                        }
                        countNum = size22;
                        if (pixNumber == countNum) {
                            return imageData;
                        }
                        temLength = 5;
                        if (bytesLength == i + 6) {
                            temLength = 6;
                        }
                        flagRem = false;
                        break;
                    }
                    default: {
                        throw new LibException("imagedata error");
                    }
                }
                continue;
            }
            tem = 0;
            bufColor = bytes[i];
            try {
                if (bytesLength <= i + 1) {
                    byte[] tmp = null;
                    return tmp;
                }
                tem = bytes[i + 1] >>> 4 & 0xF;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                LoggerUtil.error("i = " + i);
            }
            if (0 != tem) {
                int temInt = tem;
                if (temInt + countNum > pixNumber) {
                    temInt = pixNumber - countNum;
                }
                jend = countNum + temInt;
                for (j4 = countNum; j4 < jend; ++j4) {
                    imageData[j4] = bufColor;
                }
                countNum = jend;
                if (countNum == pixNumber) {
                    return imageData;
                }
                temLength = 1;
                if (bytesLength == i + 2) {
                    temLength = 2;
                    continue;
                }
                if (bytesLength <= i + 1) {
                    byte[] tmp = null;
                    return tmp;
                }
                bytes[i + 1] = (byte)(bytes[i + 1] << 4);
                flagRem = true;
                continue;
            }
            if (bytesLength <= i + 1) {
                byte[] tmp = null;
                return tmp;
            }
            switch (bytes[i + 1] & 0xC) {
                case 0: {
                    if (bytesLength <= i + 2) {
                        byte[] tmp = null;
                        return tmp;
                    }
                    int extendNum6 = (bytes[i + 1] << 4 & 0x30) + (bytes[i + 2] >>> 4 & 0xF);
                    size6 = extendNum6 + countNum;
                    size6 = size6 > pixNumber ? pixNumber : size6;
                    for (j4 = countNum; j4 < size6; ++j4) {
                        imageData[j4] = bufColor;
                    }
                    countNum = size6;
                    if (countNum == pixNumber) {
                        return imageData;
                    }
                    temLength = 2;
                    if (bytesLength == i + 3) {
                        temLength = 3;
                        continue block14;
                    }
                    if (i + 2 >= bytesLength) {
                        byte[] tmp = null;
                        return tmp;
                    }
                    bytes[i + 2] = (byte)(bytes[i + 2] << 4);
                    flagRem = true;
                    continue block14;
                }
                case 4: {
                    if (i + 2 >= bytesLength) {
                        byte[] tmp = null;
                        return tmp;
                    }
                    extendNum10 = (bytes[i + 1] << 8 & 0x300) + (bytes[i + 2] & 0xFF);
                    int sizeTen = countNum + extendNum10;
                    sizeTen = sizeTen > pixNumber ? pixNumber : sizeTen;
                    for (j3 = countNum; j3 < sizeTen; ++j3) {
                        imageData[j3] = bufColor;
                    }
                    countNum = sizeTen;
                    if (countNum == pixNumber) {
                        return imageData;
                    }
                    temLength = 3;
                    if (bytesLength == i + 4) {
                        temLength = 4;
                    }
                    flagRem = false;
                    continue block14;
                }
                case 8: {
                    if (i + 3 >= bytesLength) {
                        byte[] tmp = null;
                        return tmp;
                    }
                    extendNum18 = (bytes[i + 1] << 16 & 0x30000) + (bytes[i + 2] << 8 & 0xFF00) + (bytes[i + 3] & 0xFF);
                    size18 = countNum + extendNum18;
                    size18 = size18 > pixNumber ? pixNumber : size18;
                    for (j2 = countNum; j2 < size18; ++j2) {
                        imageData[j2] = bufColor;
                    }
                    countNum = size18;
                    if (countNum == pixNumber) {
                        return imageData;
                    }
                    temLength = 4;
                    if (bytesLength == i + 5) {
                        temLength = 5;
                    }
                    flagRem = false;
                    continue block14;
                }
                case 12: {
                    if (i + 4 >= bytesLength) {
                        byte[] tmp = null;
                        return tmp;
                    }
                    extendNum22 = (bytes[i + 1] << 20 & 0x300000) + (bytes[i + 2] << 12 & 0xFF000) + (bytes[i + 3] << 4 & 0xFF0) + (bytes[i + 4] >>> 4 & 0xF);
                    size22 = countNum + extendNum22;
                    size22 = size22 > pixNumber ? pixNumber : size22;
                    for (j = countNum; j < size22; ++j) {
                        imageData[j] = bufColor;
                    }
                    countNum = size22;
                    if (countNum == pixNumber) {
                        return imageData;
                    }
                    temLength = 4;
                    if (bytesLength == i + 5) {
                        temLength = 5;
                        continue block14;
                    }
                    if (i + 4 >= bytesLength) {
                        byte[] tp = null;
                        return tp;
                    }
                    bytes[i + 4] = (byte)(bytes[i + 4] << 4);
                    flagRem = true;
                    continue block14;
                }
                default: {
                    throw new LibException("imagedata error");
                }
            }
        }
        return imageData;
    }
}

